; ---------------------------------------------------------------------------e
;
; Universal Extractor v1.6.1
; Author:	Jared Breland <jbreland@legroom.net>
; Homepage:	http://www.legroom.net/mysoft
; Language:	AutoIt v3.3.6.1
; License:	GNU General Public License v2 (http://www.gnu.org/copyleft/gpl.html)
;
; Very Basic Script Function:
;	Extract known archive types
;	Use TrID to determine filetype
;	Use PEiD to identify executable filetypes
;
; ----------------------------------------------------------------------------

; Setup environment 
;  
;#notrayicon
#include <Array.au3> ; _ArraySort, _ArrayAdd
#include <File.au3> ; _PathFull, _FileListToArray, _TempFile
#include <GUIConstantsEx.au3>
#include <StaticConstants.au3>
#include <ComboConstants.au3>
#include <WindowsConstants.au3>
#include <Date.au3> ; _DateAdd
$name = "Universal Extractor"
$website = "http://www.legroom.net/software/uniextract"
$prefs = @scriptdir & "\UniExtract.ini"
$version = "1.6.1 mod by koros"
$reg = "HKCU\Software\UniExtract"
$peidtitle = "PEiD v"
$title = $name & " v" & $version
;$msxml_down = "http://www.microsoft.com/downloads/details.aspx?FamilyID=993c0bcf-3bcf-4009-be21-27e85e1857b1&displaylang=en"
Opt("GUIOnEventMode", 1)

; Preferences 
; 
Global $langdir = @scriptdir & "\lang"
Global $height = @desktopheight/4
Global $globalprefs = 1
Global $language = "English"
Global $debugdir = @tempdir
Global $history = 1
Global $appendext = 0
Global $removetemp = 1
Global $removedupe = 1
Global $warnexecute = 1
Global $nodoswin = 0
Global $mindoswin = 0

; Global variables
;  
Dim $file, $filename, $filedir, $fileext, $initoutdir, $outdir, $filetype
Dim $prompt, $packed, $return, $output, $langlist, $prefsonly
Dim $exsig, $loadplugins, $stayontop
Dim $testinno, $testarj, $testace, $test7z, $testzip, $testie
Dim $innofailed, $arjfailed, $acefailed, $7zfailed, $zipfailed, $iefailed, $isfailed
Dim $aceinst, $kgbinst, $peainst, $sitinst
Dim $oldpath
Dim $createdir, $dirmtime
Dim $exitcode = 0
Dim $consolewin = 1

; Extractors 
; 
$7z = "7z.exe"
$ace = "xace.exe" ;optional
$arc = "arc.exe"
$arj = "arj.exe"
$aspack = "AspackDie.exe"
$aspack22 = "AspackDie22.exe"
;$bin = "bin2iso.exe"
;$bz2 = "7z.exe"
$cdi = "cdirip.exe"
;$chm = "7z.exe"
$dbx = "cmdTotal.exe dbxplug.wcx"
;$gz = "7z.exe"
$unarc = "unarc.exe"
$hlp = "helpdeco.exe"
$ie = "cmdTotal.exe InstExpl.wcx"
$img = "7z.EXE"
;$img = "EXTRACT.EXE"
$inno = "innounp.exe"
$is3arc = "i3comp.exe"
$is3exe = "stix_d.exe"
$is6cab = "i6comp.exe"
$is5cab = "i5comp.exe"
$isexe = "IsXunpack.exe"
$iso = "cmdTotal.exe iso.wcx"
;$iswcx = "cmdTotal.exe IShield.wcx"
$kgb = "kgb_arch_decompress.exe" ;optional
$lit = "clit.exe"
$lzo = "lzop.exe"
$lzx = "unlzx.exe"
$mht = "extractMHT.exe"
$mht_ct = "cmdTotal.exe MHTUnp.wcx"
;$msi_msi2xml = "msi2xml.exe"
$msi_ct = "cmdTotal.exe msi.wcx"
$msi_JSWare = 'wscript.exe "' &  @ScriptDir & '\bin\MSIUnPack.vbs" '
$msi_msix = "MsiX.exe"
$nbh = "NBHextract.exe"
;$nrg = "nrg2iso.exe"
$pea = "pea.exe" ;optional
$peid = "peid.exe"
$rai = "RAIU.EXE"
$rar = "unrar.exe"
$sis = "cmdTotal.exe PDunSIS.wcx"
$sit = "Expander.exe" ;optional
;$tar = "7z.exe"
$trid = "trid.exe"
$uharc = "UNUHARC06.EXE"
$uharc04 = "UHARC04.EXE"
$uharc02 = "UHARC02.EXE"
$upx = "upx.exe"
$uu = "uudeview.exe"
$wise_ewise = "e_wise_w.exe"
$wise_wun = "wun.exe"
;$Z = "7z.exe"
$zip = "unzip.exe"
$zoo = "booz.exe"

; Check parameters 
;    UniExtract.ini   
ReadPrefs()
If $cmdline[0] = 0 Then
	$prompt = 1
Else
	If $cmdline[1] = "/help" OR $cmdline[1] = "/h" OR $cmdline[1] = "/?" _
						 OR $cmdline[1] = "-h" OR $cmdline[1] = "-?" Then
		terminate("syntax", "", "")
	ElseIf $cmdline[1] = "/prefs" Then
		$prefsonly = True
		GUI_Prefs()
		$finishprefs = False
		While 1
			If $finishprefs Then ExitLoop 
			Sleep(10)
		WEnd
		terminate("silent", "", "")
	Else
		If FileExists($cmdline[1]) Then
			$file = _PathFull($cmdline[1])
		Else
			terminate("syntax", "", "")
		EndIf
		If $cmdline[0] > 1 Then
			;$outdir = _PathFull($cmdline[2])
			$outdir = $cmdline[2]
		Else
			$prompt = 1
		EndIf
	EndIf
EndIf

; If no file passed, display GUI to select file and set options 
;        ,   GUI
If $prompt Then
	CreateGUI()
	$finishgui = False
	While 1
		If $finishgui Then ExitLoop 
		Sleep(10)
	WEnd
EndIf

; Parse filename
;   
FilenameParse($file)

; Set full output directory
;   
If $outdir = '/sub' Then
	$outdir = $initoutdir
ElseIf StringMid($outdir, 2, 1) <> ":" Then
	If StringLeft($outdir, 1) == '\' AND StringMid($outdir, 2, 1) <> '\' Then
		$outdir = StringLeft($filedir, 2) & $outdir
	ElseIf StringLeft($outdir, 2) <> '\\' Then
		$outdir = _PathFull($filedir & '\' & $outdir)
	EndIf
EndIf

; Verify debug file output
;      
If StringRight(EnvParse($debugdir), 1) <> '\' Then $debugdir &= '\'
$debugfile = FileGetShortName(EnvParse($debugdir)) & 'uniextract.txt'
$testdebug = FileOpen($debugfile, 2)
If $testdebug == -1 Then
	;terminate("debug", $debugdir, "")
	MsgBox(48, $title, t('CANNOT_DEBUG', CreateArray(EnvParse($debugdir))))
	$debugdir = @tempdir & '\'
	$debugfile = FileGetShortName($debugdir) & 'uniextract.txt'
Else
	FileClose($testdebug)
	FileDelete($debugfile)
EndIf

; Update history
;    
;WritePrefs()
If $history Then
	WriteHist('file', $file)
	WriteHist('directory', $outdir)
EndIf

;     (,   )
If $mindoswin Then $consolewin = 2
If $nodoswin Then $consolewin = 0

; Set environment options for Windows NT
;    Windows NT
$cmd = @comspec & ' /d /c '
$output = ' 2>&1 | tee.exe ' & $debugfile
EnvSet("path", @scriptdir & "\bin" & ';' & EnvGet("path"))

; Check for optional binaries
;    
If PathSearch($ace) Then $aceinst = True
If PathSearch($kgb) Then $kgbinst = True
If PathSearch($pea) Then $peainst = True
If PathSearch($sit) Then $sitinst = True

; Extract contents from known file types
;      
;
; UniExtract uses four methods of detection (in order):
; 1. File extensions for special cases
; 2. Binary file analysis of files using TrID
; 3. Binary file analysis of PE (executable) files using PEiD
; 4. File extensions
;
; If detection fails, extraction is always attempted 7-Zip and InfoZip
; UniExtract    
; 1.      
; 2.      TrID
; 3.      PEiD
; 4.   
;
;      ,   7-Zip  InfoZip

; First, check for file extensions that require special actiona
; -,        
; Compound compressed files that require multiple actions
;  ,      
If $fileext = "ipk" OR $fileext = "tbz2" OR $fileext = "tgz" _
	OR $fileext = "tz" OR $fileext = "tlz" OR $fileext = "txz" Then
	extract("ctar", 'Compressed Tar ' & t('TERM_ARCHIVE'))

; CD-ROM images - TrID is not reliable with these formats
;   CD - TrID     
ElseIf $fileext = "cdi" Then
	extract("cdi", 'CDI CD-ROM ' & t('TERM_IMAGE'))
ElseIf $fileext = "iso" Then
	extract("7z", 'ISO CD-ROM ' & t('TERM_IMAGE'))

; Second, analyze file using TrID
; -,  TrID
Else
	SplashTextOn($title, t('SCANNING_FILE'), 330, 50, -1, $height, 16)
	filescan($file)
EndIf


; Third, run PEiD scan if appropriate
; Determine type of .exe and extract if possible
; -,  PEiD  exe-,   ,  ,  
If $fileext = "exe" OR StringInStr($filetype, 'Executable', 0) Then

	; Check for known exe filetypes
	;     
	$scantypes = CreateArray('deep', 'hard', 'ext')
	For $i = 0 To UBound($scantypes)-1
		; Run PEiD scan
		;  PEiD
		If $scantypes[$i] == 'hard' Then
			$tempftype = exescan($file, $scantypes[$i])
		Else
			exescan($file, $scantypes[$i])
		EndIf

		; Perform additional tests if necessary
		;     
		SplashTextOn($title, t('TERM_TESTING') & ' ' & t('TERM_UNKNOWN') & ' ' & t('TERM_EXECUTABLE'), 330, 50, -1, $height, 16)
		If $testinno AND NOT $innofailed Then checkInno()
		If $testarj AND NOT $arjfailed Then checkArj()
		If $testace AND NOT $acefailed Then checkAce()
		If $testzip AND NOT $zipfailed Then checkZip()
		if $testie AND NOT $iefailed Then checkIE()

		; Wait until after External scan is run before trying 7-Zip;
		; new version is too agreessive
		;        7-Zip
		if $scantypes[$i] == 'ext' AND $test7z AND NOT $7zfailed Then check7z()
		SplashOff()
	Next
	$filetype = $tempftype

	; Try 7-Zip and Unzip if all else fails
	;     7-Zip,      
	If NOT $7zfailed Then check7z()
	If NOT $zipfailed Then checkZip()
	if NOT $iefailed Then checkIE()

	; Unpack (vs. extract) packed file
	; ,     ,  exe-
	if $packed Then unpack()

	; Exit with unknown file type
	;         
	terminate("unknownexe", $file, $filetype)


; Fourth, use file extension if signature not recognized
; -,     ,    
ElseIf $fileext = "1" OR $fileext = "lib" Then
	extract("is3arc", 'InstallShield 3.x ' & t('TERM_ARCHIVE'))

ElseIf $fileext = "7z" Then
	extract("7z", '7-Zip ' & t('TERM_ARCHIVE'))

ElseIf $fileext = "ace" AND $aceinst Then
	extract("ace", 'ace ' & t('TERM_ARCHIVE'))

ElseIf $fileext = "arc" Then
	extract("arc", 'ARC ' & t('TERM_ARCHIVE'))

ElseIf $fileext = "arj" Then
	extract("arj", 'ARJ ' & t('TERM_ARCHIVE'))

ElseIf $fileext = "b64" Then
	extract("uu", 'Base64 ' & t('TERM_ENCODED'))

ElseIf $fileext = "bz2" Then
	extract("bz2", 'bzip2 ' & t('TERM_COMPRESSED'))

ElseIf $fileext = "cab" Then
	RunWait($cmd & $7z & ' l "' & $file & '"' & $output, $filedir, @SW_HIDE)
	If StringInStr(FileReadLine($debugfile, 4), "Listing archive:", 0) Then
		extract("cab", 'Microsoft CAB ' & t('TERM_ARCHIVE'))
	Else
		extract("iscab", 'InstallShield CAB ' & t('TERM_ARCHIVE'))
	EndIf
	FileDelete($debugfile)

ElseIf $fileext = "chm" Then
	extract("chm", 'Compiled HTML ' & t('TERM_HELP'))

ElseIf $fileext = "cpio" Then
	extract("7z", 'CPIO ' & t('TERM_ARCHIVE'))

ElseIf $fileext = "dbx" Then
	extract("dbx", 'Outlook Express ' & t('TERM_ARCHIVE'))

ElseIf $fileext = "deb" Then
	extract("7z", 'Debian ' & t('TERM_PackAGE'))

ElseIf $fileext = "dll" Then
	exescan($file, 'deep')
	If $packed Then
		unpack()
	Else
		terminate("unknownexe", $file, $filetype)
	EndIf

ElseIf $fileext = "gz" Then
	extract("gz", 'gzip ' & t('TERM_COMPRESSED'))

ElseIf $fileext = "hlp" Then
	extract("hlp", 'Windows ' & t('TERM_HELP'))

ElseIf $fileext = "imf" Then
	extract("cab", 'IncrediMail ' & t('TERM_ECARD'))

ElseIf $fileext = "img" Then
	extract("img", 'Floppy ' & t('TERM_DISK') & ' ' & t('TERM_IMAGE'))

ElseIf ($fileext = "kgb" OR $fileext = "kge") AND $kgbinst Then
	extract("kgb", 'KGB ' & t('TERM_ARCHIVE'))

ElseIf $fileext = "lit" Then
	extract("lit", 'Microsoft LIT ' & t('TERM_EBOOK'))    
                        
ElseIf $fileext = "lzh" OR $fileext = "lha" Then                                      
	extract("7z", 'LZH ' & t('TERM_COMPRESSED'))   
                               
ElseIf $fileext = "lzma" Then                                                         
	extract("7z", 'LZMA ' & t('TERM_COMPRESSED')) 
                                
ElseIf $fileext = "lzo" Then                                                          
	extract("lzo", 'LZO ' & t('TERM_COMPRESSED'))
                                 
ElseIf $fileext = "lzx" Then                                                          
	extract("lzx", 'LZX ' & t('TERM_COMPRESSED')) 
                                
ElseIf $fileext = "mht" Then                                                          
	extract("mht", 'MHTML ' & t('TERM_ARCHIVE')) 
                                 
ElseIf $fileext = "msi" Then                                                          
	extract("msi", 'Windows Installer (MSI) ' & t('TERM_PackAGE')) 
               
ElseIf $fileext = "msm" Then                                                          
	extract("msm", 'Windows Installer (MSM) ' & t('TERM_MERGE_MODULE')) 
          
ElseIf $fileext = "msp" Then                                                          
	extract("msp", 'Windows Installer (MSP) ' & t('TERM_PATCH'))    
              
ElseIf $fileext = "nbh" Then                                                          
	extract("nbh", 'NBH ' & t('TERM_IMAGE'))    
                                  
ElseIf $fileext = "pea" AND $peainst Then                                             
	extract("pea", 'Pea ' & t('TERM_ARCHIVE')) 
                                   
ElseIf $fileext = "rar" OR $fileext = "001" OR $fileext = "cbr" Then                  
	extract("rar", 'RAR ' & t('TERM_ARCHIVE'))       
                             
ElseIf $fileext = "rpm" Then                                                          
	extract("7z", 'RPM ' & t('TERM_PackAGE'))  
                                   
ElseIf $fileext = "sis" Then                                                          
	extract("sis", 'SymbianOS ' & t('TERM_INSTALLER'))  
                          
ElseIf $fileext = "sit" AND $sitinst Then                                             
	extract("sit", 'StuffIt ' & t('TERM_ARCHIVE'))   
                             
ElseIf $fileext = "tar" Then                                                          
	extract("tar", 'Tar ' & t('TERM_ARCHIVE'))   
                                 
ElseIf $fileext = "uha" Then                                                          
	extract("uha", 'UHARC ' & t('TERM_ARCHIVE'))  
                                
ElseIf $fileext = "uu" OR $fileext = "uue" _                                          
	OR $fileext = "xx" OR $fileext = "xxe" Then                                   
	extract("uu", 'UUencode ' & t('TERM_ENCODED'))  
                              
ElseIf $fileext = "wim" Then                                                          
	extract("7z", 'WIM ' & t('TERM_IMAGE'))    
                                   
ElseIf $fileext = "xz" Then                                                           
	extract("xz", 'XZ ' & t('TERM_COMPRESSED'))  
                                 
ElseIf $fileext = "yenc" OR $fileext = "ntx" Then                                     
	extract("uu", 'yEnc ' & t('TERM_ENCODED'))     
                               
ElseIf $fileext = "z" Then
	If NOT check7z() Then extract("is3arc", 'InstallShield 3.x ' & t('TERM_ARCHIVE'))

ElseIf $fileext = "zip" OR $fileext = "cbz" OR $fileext = "jar" OR $fileext = "xpi" OR $fileext = "wz" Then
	extract("zip", 'ZIP ' & t('TERM_ARCHIVE'))

ElseIf $fileext = "zoo" Then
	extract("zoo", 'ZOO ' & t('TERM_ARCHIVE'))

; Unknown extension
;  
Else
	; Cannot determine filetype - abort
	;     - 
	SplashOff()
	terminate("unknownext", $file, "")
EndIf

; -------------------------- Begin Custom Functions ---------------------------

; Parse filename
;   
Func FilenameParse($f)
	$filedir = StringLeft($f, StringInStr($f, '\', 0, -1)-1)
	$filename = StringTrimLeft($f, StringInStr($f, '\', 0, -1))
	If StringInStr($filename, '.') Then
		$fileext = StringTrimLeft($filename, StringInStr($filename, '.', 0, -1))
		$filename = StringTrimRight($filename, StringLen($fileext)+1)
		$initoutdir = $filedir & '\' & $filename
	Else
		$fileext = ''
		$initoutdir = $filedir & '_extracted'
	EndIf
EndFunc

; Parse string for environmental variables and return expanded output
;        
Func EnvParse($string)
	$arr = StringRegExp($string, "%.*%", 2)
	For $i = 0 To UBound($arr)-1
		$string = StringReplace($string, $arr[$i], EnvGet(StringReplace($arr[$i], "%", "")))
	Next
	Return $string
EndFunc

; Translate text
;  
Func t($t, $vars = '')
	Local $ldir = @scriptdir
	If $language <> 'English' Then $ldir &= '\lang'
	$return = IniRead($ldir & '\' & $language & '.ini', 'UniExtract', $t, '')
	If $return == '' Then $return = IniRead(@scriptdir & '\English.ini', 'UniExtract', $t, '???')
	;If StringInStr($return, ' //') Then
	;	$return = StringLeft($return, StringInStr($return, ' //')-1)
	;	If StringLeft($return, 1) == '"' AND StringRight($return, 1) == '"' Then
	;		$return = StringTrimLeft($return, 1)
	;		$return = StringTrimRight($return, 1)
	;	EndIf
	;EndIf
	$return = StringReplace($return, '%n', @CRLF)
	$return = StringReplace($return, '%t', @TAB)
	For $i = 0 To UBound($vars)-1
		$return = StringReplace($return, '%s', $vars[$i], 1)
	Next
	Return $return
EndFunc

; Read preferences
;    UniExtract.ini 
Func ReadPrefs()
	$section = "UniExtract Preferences"
	$value = IniRead($prefs, $section, "globalprefs", "")
	If $value <> '' Then $globalprefs = Int($value)
	$value = IniRead($prefs, $section, "history", "")
	If $value <> '' Then $history = Int($value)
	$value = IniRead($prefs, $section, "debugdir", "")
	If $value <> '' Then $debugdir = $value
	$value = IniRead($prefs, $section, "language", "")
	If $value <> '' Then $language = $value
	$value = IniRead($prefs, $section, "appendext", "")
	If $value <> '' Then $appendext = Int($value)
	$value = IniRead($prefs, $section, "removetemp", "")
	If $value <> '' Then $removetemp = Int($value)
	$value = IniRead($prefs, $section, "removedupe", "")
	If $value <> '' Then $removedupe = Int($value)
	$value = IniRead($prefs, $section, "warnexecute", "")
	If $value <> '' Then $warnexecute = Int($value)
	$version = IniRead($prefs, $section, "version", "1.6.1")
	$value = IniRead($prefs, $section, "nodoswin", "")
	If $value <> '' Then $nodoswin = Int($value)
	$value = IniRead($prefs, $section, "mindoswin", "")
	If $value <> "" Then $mindoswin = Int($value)

	; read local preferences, if appropriate, and override global preferences
	;        
	If NOT $globalprefs Then
		$value = RegRead($reg, "history")
		If $value <> '' Then $history = Int($value)
		$value = RegRead($reg, "debugdir")
		If $value <> '' Then $debugdir = $value
		$value = RegRead($reg, "language")
		If $value <> '' Then $language = $value
		$value = RegRead($reg, "appendext")
		If $value <> '' Then $appendext = Int($value)
		$value = RegRead($reg, "removetemp")
		If $value <> '' Then $removetemp = Int($value)
		$value = RegRead($reg, "removedupe")
		If $value <> '' Then $removedupe = Int($value)
		$value = RegRead($reg, "warnexecute")
		If $value <> '' Then $warnexecute = Int($value)
		$version = RegRead($reg, "version", "1.6.1")
		$value = RegRead($reg, "nodoswin")
		If $value <> '' Then $nodoswin = Int($value)
		$value = RegRead($reg, "mindoswin")
		If $value <> '' Then $mindoswin = Int($value)
	EndIf

	; Read language files
	;   
	$langlist = ''
	Dim $langarr[1]
	$temp = FileFindFirstFile($langdir & '\*.ini')
	If $temp <> -1 Then
		Local $langarr = _FileListToArray($langdir, '*.ini', 1)
		FileClose($temp)
	EndIf
	$langarr[0] = 'English.ini'
	_ArraySort($langarr)
	For $i = 0 To UBound($langarr)-1
		$langlist &= StringTrimRight($langarr[$i], 4) & '|'
	Next
	$langlist = StringTrimRight($langlist, 1)
endfunc

; Write preferences
;  
Func WritePrefs()
	; Only update .ini file if globalprefs enabled
	;   .ini ,  globalprefs=1
	If $globalprefs Then
		$section = "UniExtract Preferences"
		IniWrite($prefs, $section, 'history', $history)
		IniWrite($prefs, $section, 'debugdir', $debugdir)
		IniWrite($prefs, $section, 'language', $language)
		IniWrite($prefs, $section, 'appendext', $appendext)
		IniWrite($prefs, $section, 'removetemp', $removetemp)
		IniWrite($prefs, $section, 'removedupe', $removedupe)
		IniWrite($prefs, $section, 'warnexecute', $warnexecute)
		IniWrite($prefs, $section, 'nodoswin', $nodoswin)
		IniWrite($prefs, $section, 'mindoswin', $mindoswin)

	; Otherwise, write local settings to registry
	;      
	Else
		RegWrite($reg, 'history', 'REG_SZ', $history)
		RegWrite($reg, 'debugdir', 'REG_SZ', $debugdir)
		RegWrite($reg, 'language', 'REG_SZ', $language)
		RegWrite($reg, 'appendext', 'REG_SZ', $appendext)
		RegWrite($reg, 'removetemp', 'REG_SZ', $removetemp)
		RegWrite($reg, 'removedupe', 'REG_SZ', $removedupe)
		RegWrite($reg, 'warnexecute', 'REG_SZ', $warnexecute)
		RegWrite($reg, 'nodoswin', 'REG_SZ', $nodoswin)
		RegWrite($reg, 'mindoswin', 'REG_SZ', $mindoswin)
	EndIf
endfunc

; Read history
;  
Func ReadHist($field)
	Local $items

	; Read from .ini file when globalprefs enabled
	;   .ini ,  globalprefs=1
	If $globalprefs Then
		If $field = 'file' Then
			$section = "File History"
		ElseIf $field = 'directory' Then
			$section = "Directory History"
		Else
			Return 
		EndIf
		For $i = 0 To 9
			$value = IniRead($prefs, $section, $i, "")
			If $value <> "" Then $items &= '|' & $value
		Next

	; Otherwise, read from HKCU registry
	;    
	Else
		If $field = 'file' Then
			$key = $reg & "\File"
		ElseIf $field = 'directory' Then
			$key = $reg & "\Directory"
		Else
			Return 
		EndIf
		For $i = 0 To 9
			$value = RegRead($key, $i)
			If $value <> "" Then $items &= '|' & $value
		Next
	EndIf

	; return trimmed results
	;   
	Return StringTrimLeft($items, 1)
EndFunc

; Write history
;  
Func WriteHist($field, $new)
	; Only update .ini file if globalprefs enabled
	;   .ini ,  globalprefs=1
	If $globalprefs Then
		If $field = 'file' Then
			$section = "File History"
		ElseIf $field = 'directory' Then
			$section = "Directory History"
		Else
			Return 
		EndIf
		$histarr = StringSplit(ReadHist($field), '|')
		IniWrite($prefs, $section, "0", $new)
		If $histarr[1] == "" Then Return 
		For $i = 1 To $histarr[0]
			If $i > 9 Then ExitLoop 
			If $histarr[$i] = $new Then
				IniDelete($prefs, $section, String($i))
				ContinueLoop 
			EndIf
			IniWrite($prefs, $section, String($i), $histarr[$i])
		Next

	; Otherwise, write local settings to registry
	;      
	Else
		If $field = 'file' Then
			$key = $reg & "\File"
		ElseIf $field = 'directory' Then
			$key = $reg & "\Directory"
		Else
			Return 
		EndIf
		$histarr = StringSplit(ReadHist($field), '|')
		RegWrite($key, "0", "REG_SZ", $new)
		If $histarr[1] == "" Then Return 
		For $i = 1 To $histarr[0]
			If $i > 9 Then ExitLoop 
			If $histarr[$i] = $new Then
				RegDelete($key, String($i))
				ContinueLoop 
			EndIf
			RegWrite($key, String($i), "REG_SZ", $histarr[$i])
		Next
	EndIf
EndFunc

; Scan file using TrID
;     TrID
Func filescan($f, $analyze = 1)
	; Run TrID and dump output
	;  TrID   
	RunWait($cmd & $trid & ' "' & $f & '" >' & $debugfile, $filedir, @SW_HIDE)

	; Parse through results and append to string
	;   
	$filetype = ''
	$infile = FileOpen($debugfile, 0)
	$line = FileReadLine($infile)
	Do
		If StringInStr($line, '%') Then $filetype &= $line
		$line = FileReadLine($infile)
	Until @error
	FileClose($infile)

	; Return filetype without matching if specified
	;   ,   " "
	If NOT $analyze Then Return $filetype

	; Match known patterns
	;       
	Select 
		Case StringInStr($filetype, "7-Zip compressed archive", 0)
			extract("7z", '7-Zip ' & t('TERM_ARCHIVE'))

		Case StringInStr($filetype, "ACE compressed archive", 0) _
			OR StringInStr($filetype, "ACE Self-Extracting Archive", 0)
			If $aceinst Then extract("ace", t('TERM_SFX') & ' ACE ' & t('TERM_ARCHIVE'))

		Case StringInStr($filetype, "FreeArc compressed archive", 0)
			extract("freearc", 'FreeARC ' & t('TERM_ARCHIVE'))

		Case StringInStr($filetype, "ARC Compressed archive", 0) _
			AND NOT StringInStr($filetype, "UHARC", 0)
			extract("arc", 'ARC ' & t('TERM_ARCHIVE'))

		Case StringInStr($filetype, "ARJ compressed archive", 0)
			extract("arj", 'ARJ ' & t('TERM_ARCHIVE'))

		Case StringInStr($filetype, "bzip2 compressed archive", 0)
			extract("bz2", 'bzip2 ' & t('TERM_COMPRESSED'))

		Case StringInStr($filetype, "Microsoft Cabinet Archive", 0) _
			OR StringInStr($filetype, "IncrediMail letter/ecard", 0)
			If $fileext = "msu" Then
				extract("msu", "Windows Update (MSU) " & t('TERM_PATCH'))
			Else
				extract("cab", 'Microsoft CAB ' & t('TERM_ARCHIVE'))
			EndIf

		Case StringInStr($filetype, "(.CHM) Windows HELP File", 0)
			extract("chm", 'Compiled HTML ' & t('TERM_HELP'))

		Case StringInStr($filetype, "CPIO Archive", 0)
			extract("7z", 'CPIO ' & t('TERM_ARCHIVE'))

		Case StringInStr($filetype, "Debian Linux Package", 0)
			extract("7z", 'Debian ' & t('TERM_PackAGE'))

		Case StringInStr($filetype, "Gentee Installer executable", 0)
			extract("ie", 'Gentee ' & t('TERM_INSTALLER'))

		Case StringInStr($filetype, "GZipped File", 0)
			extract("gz", 'gzip ' & t('TERM_COMPRESSED'))

		Case StringInStr($filetype, "(.HLP) Windows Help file", 0)
			extract("hlp", 'Windows ' & t('TERM_HELP'))

		Case StringInStr($filetype, "Generic PC disk image", 0)
			extract("img", 'Floppy ' & t('TERM_DISK') & ' ' & t('TERM_IMAGE'))

		Case StringInStr($filetype, "Inno Setup installer", 0)
			checkInno()

		Case StringInStr($filetype, "Installer VISE executable", 0)
			extract("ie", 'Installer VISE ' & t('TERM_INSTALLER'))

		Case StringInStr($filetype, "InstallShield archive", 0)
			extract("is3arc", 'InstallShield 3.x ' & t('TERM_ARCHIVE'))

		Case StringInStr($filetype, "InstallShield compressed archive", 0)
			extract("iscab", 'InstallShield CAB ' & t('TERM_ARCHIVE'))

		Case StringInStr($filetype, "ISO CDImage", 0)
			extract("iso", 'CD-ROM ' & t('TERM_IMAGE'))

		Case StringInStr($filetype, "KGB archive", 0)
			If $kgbinst Then extract("kgb", 'KGB ' & t('TERM_ARCHIVE'))

		Case StringInStr($filetype, "LHARC/LZARK compressed archive", 0)
			extract("7z", 'LZH ' & t('TERM_COMPRESSED'))

		Case StringInStr($filetype, "lzop compressed", 0)
			extract("lzo", 'LZO ' & t('TERM_COMPRESSED'))

		Case StringInStr($filetype, "LZX Amiga compressed archive", 0)
			extract("lzx", 'LZX ' & t('TERM_COMPRESSED'))

		Case StringInStr($filetype, "Microsoft Internet Explorer Web Archive", 0)
			extract("mht", 'MHTML ' & t('TERM_ARCHIVE'))

		Case StringInStr($filetype, "Microsoft Reader eBook", 0)
			extract("lit", 'Microsoft LIT ' & t('TERM_EBOOK'))

		Case StringInStr($filetype, "Microsoft Windows Installer merge module", 0)
			extract("msm", 'Windows Installer (MSM) ' & t('TERM_MERGE_MODULE'))

		Case StringInStr($filetype, "Microsoft Windows Installer package", 0)
			extract("msi", 'Windows Installer (MSI) ' & t('TERM_PACKAGE'))

		Case StringInStr($filetype, "Microsoft Windows Installer patch", 0)
			extract("msp", 'Windows Installer (MSP) ' & t('TERM_PATCH'))

		Case StringInStr($filetype, "(.MSU) Windows Update Package")
			extract("msu", "Windows Update (MSU) " & t('TERM_PATCH'))

		Case StringInStr($filetype, "HTC NBH ROM Image", 0)
			extract("nbh", 'NBH ' & t('TERM_IMAGE'))

		Case StringInStr($filetype, "Outlook Express E-mail folder", 0)
			extract("dbx", 'Outlook Express ' & t('TERM_ARCHIVE'))

		Case StringInStr($filetype, "PEA archive", 0)
			If $peainst Then extract("pea", 'Pea ' & t('TERM_ARCHIVE'))

		Case StringInStr($filetype, "RAR Archive", 0)
			extract("rar", 'RAR ' & t('TERM_ARCHIVE'))

		Case StringInStr($filetype, "RAR Self Extracting archive", 0)
			checkZip()
			extract("rar", 'RAR ' & t('TERM_ARCHIVE'))

		Case StringInStr($filetype, "Reflexive Arcade installer wrapper", 0)
			extract("inno", 'Reflexive Arcade ' & t('TERM_INSTALLER'))

		Case StringInStr($filetype, "RPM Linux Package", 0)
			extract("7z", 'RPM ' & t('TERM_PACKAGE'))

		Case StringInStr($filetype, "Setup Factory 6.x Installer", 0)
			extract("ie", 'Setup Factory ' & t('TERM_ARCHIVE'))

		Case StringInStr($filetype, "StuffIT SIT compressed archive", 0)
			if $sitinst Then extract("sit", 'StuffIt ' & t('TERM_ARCHIVE'))

		Case StringInStr($filetype, "SymbianOS Installer", 0)
			extract("sis", 'SymbianOS ' & t('TERM_INSTALLER'))

		Case StringInStr($filetype, "TAR archive", 0)
			extract("tar", 'Tar ' & t('TERM_ARCHIVE'))

		Case StringInStr($filetype, "UHARC compressed archive", 0)
			extract("uha", 'UHARC ' & t('TERM_ARCHIVE'))

		Case StringInStr($filetype, "Base64 Encoded file", 0)
			extract("uu", 'Base64 ' & t('TERM_ENCODED'))

		Case StringInStr($filetype, "Quoted-Printable Encoded file", 0)
			extract("uu", 'Quoted-Printable ' & t('TERM_ENCODED'))

		Case StringInStr($filetype, "UUencoded file", 0) _
			OR StringInStr($filetype, "XXencoded file", 0)
			extract("uu", 'UUencoded ' & t('TERM_ENCODED'))

		Case StringInStr($filetype, "yEnc Encoded file", 0)
			extract("uu", 'yEnc ' & t('TERM_ENCODED'))

		Case StringInStr($filetype, "Windows Imaging Format", 0)
			extract("7z", 'WIM ' & t('TERM_IMAGE'))

		Case StringInStr($filetype, "Wise Installer Executable", 0)
			extract("wise", 'Wise Installer ' & t('TERM_PACKAGE'))

		Case StringInStr($filetype, "UNIX Compressed file", 0)
			extract("Z", 'LZW ' & t('TERM_COMPRESSED'))

		Case StringInStr($filetype, "ZIP compressed archive", 0) _
			OR StringInStr($filetype, "Winzip Win32 self-extracting archive", 0)
			extract("zip", 'ZIP ' & t('TERM_ARCHIVE'))

		Case StringInStr($filetype, "Zip Self-Extracting archive", 0)
			checkInno()

		Case StringInStr($filetype, "ZOO compressed archive", 0)
			extract("zoo", 'ZOO ' & t('TERM_ARCHIVE'))

		; Forced to bottom of list due to false positives
		;    -  
		Case StringInStr($filetype, "LZMA compressed file", 0)
			check7z()

		Case StringInStr($filetype, "InstallShield setup", 0)
			;extract("isexe", 'InstallShield ' & t('TERM_INSTALLER'))
			checkInstallShield()

	EndSelect
EndFunc

; Scan .exe file using PEiD
;  .exe    PEiD
Func exescan($f, $scantype, $analyze = 1)
	SplashTextOn($title, t('SCANNING_EXE', CreateArray($scantype)), 330, 50, -1, $height, 16)
	; Backup existing PEiD options
	;   PEiD  
	$exsig = RegRead("HKCU\Software\PEiD", "ExSig")
	$loadplugins = RegRead("HKCU\Software\PEiD", "LoadPlugins")
	$stayontop = RegRead("HKCU\Software\PEiD", "StayOnTop")

	; Set PEiD options
	;   PEiD 
	RegWrite("HKCU\Software\PEiD", "ExSig", "REG_DWORD", 1)
	RegWrite("HKCU\Software\PEiD", "LoadPlugins", "REG_DWORD", 0)
	RegWrite("HKCU\Software\PEiD", "StayOnTop", "REG_DWORD", 0)

	; Analyze file
	;  
	$filetype = ""
	Run($peid & ' -' & $scantype & ' "' & $f & '"', @scriptdir, @SW_HIDE)
	WinWait($peidtitle)
	While ($filetype = "") OR ($filetype = "Scanning...")
		Sleep (100)
		$filetype = ControlGetText($peidtitle, "", "Edit2")
	WEnd
	WinClose($peidtitle)

	; Restore previous PEiD options
	;    PEiD
	If $exsig Then RegWrite("HKCU\Software\PEiD", "ExSig", "REG_DWORD", $exsig)
	If $loadplugins Then RegWrite("HKCU\Software\PEiD", "LoadPlugins", "REG_DWORD", $loadplugins)
	If $stayontop Then RegWrite("HKCU\Software\PEiD", "StayOnTop", "REG_DWORD", $stayontop)
	SplashOff()

	; Return filetype without matching if specified
	;   ,   " "
	If NOT $analyze Then Return $filetype

	; Match known patterns
	;       
	Select 
		Case StringInStr($filetype, "ARJ SFX", 0)
			extract("arj", t('TERM_SFX') & ' ARJ ' & t('TERM_ARCHIVE'))

		Case StringInStr($filetype, "Borland Delphi", 0) AND NOT StringInStr($filetype, "RAR SFX", 0)
			$testinno = True
			$testzip = True

		Case StringInStr($filetype, "Gentee Installer", 0)
			extract("ie", 'Gentee ' & t('TERM_INSTALLER'))

		Case StringInStr($filetype, "Inno Setup", 0)
			checkInno()

		Case StringInStr($filetype, "Installer VISE", 0)
			extract("ie", 'Installer VISE ' & t('TERM_INSTALLER'))

		Case StringInStr($filetype, "InstallShield", 0)
			If NOT $isfailed Then extract("isexe", 'InstallShield ' & t('TERM_INSTALLER'))

		Case StringInStr($filetype, "KGB SFX", 0)
			If $kgbinst Then extract("kgb", t('TERM_SFX') & ' KGB ' & t('TERM_PACKAGE'))

		Case StringInStr($filetype, "Microsoft Visual C++", 0) AND NOT StringInStr($filetype, "SPx Method", 0) AND NOT StringInStr($filetype, "Custom", 0) AND NOT StringInStr($filetype, "7.0", 0)
			$test7z = True
			$testie = True

		Case StringInStr($filetype, "Microsoft Visual C++ 7.0", 0) AND StringInStr($filetype, "Custom", 0) AND NOT StringInStr($filetype, "Hotfix", 0)
			extract("vssfx", 'Visual C++ ' & t('TERM_SFX') & ' ' & t('TERM_INSTALLER'))

		; removed - not possible to access due to 7zip check after deep scan
		;  -         7zip   
		;Case StringInStr($filetype, "Microsoft Visual C++ 7.0", 0) AND StringInStr($filetype, "Custom", 0) AND StringInStr($filetype, "Hotfix", 0)
		;	extract("vssfxhotfix", 'Visual C++ ' & t('TERM_SFX') & ' ' & t('TERM_HOTFIX'))

		Case StringInStr($filetype, "Microsoft Visual C++ 6.0", 0) AND StringInStr($filetype, "Custom", 0)
			extract("vssfxpath", 'Visual C++ ' & t('TERM_SFX') & '' & t('TERM_INSTALLER'))

		Case StringInStr($filetype, "Netopsystems FEAD Optimizer", 0)
			extract("fead", 'Netopsystems FEAD ' & t('TERM_PACKAGE'))

		Case StringInStr($filetype, "Nullsoft PiMP SFX", 0)
			checkNSIS()

		Case StringInStr($filetype, "PEtite", 0)
			$testarj = True
			If $aceinst Then $testace = True

		Case StringInStr($filetype, "RAR SFX", 0)
			extract("rar", t('TERM_SFX') & ' RAR ' & t('TERM_ARCHIVE'))

		Case StringInStr($filetype, "Reflexive Arcade Installer", 0)
			extract("inno", 'Reflexive Arcade ' & t('TERM_INSTALLER'))

		Case StringInStr($filetype, "RoboForm Installer", 0)
			extract("robo", 'RoboForm ' & t('TERM_INSTALLER'))

		Case StringInStr($filetype, "Setup Factory 6.x", 0)
			extract("ie", 'Setup Factory ' & t('TERM_ARCHIVE'))

		Case StringInStr($filetype, "SPx Method", 0) OR StringInStr($filetype, "CAB SFX", 0)
			extract("cab", t('TERM_SFX') & ' Microsoft CAB ' & t('TERM_ARCHIVE'))

		Case StringInStr($filetype, "SuperDAT", 0)
			extract("superdat", 'McAfee SuperDAT ' & t('TERM_UPDATER'))

		Case StringInStr($filetype, "Wise", 0) OR StringInStr($filetype, "PEncrypt 4.0", 0)
			extract("wise", 'Wise Installer ' & t('TERM_PACKAGE'))

		Case StringInStr($filetype, "ZIP SFX", 0)
			extract("zip", t('TERM_SFX') & ' ZIP ' & t('TERM_ARCHIVE'))

		Case StringInStr($filetype, "upx", 0) OR StringInStr($filetype, "aspack", 0)
			$packed = True


		; Default case for non-PE executables - try 7zip and unzip
		;  7zip     -PE exe-
		Case Else
			$test7z = True
			$testzip = True
			$testie = True
	EndSelect
	Return $filetype
EndFunc

; Determine if 7-zip can extract the file
; ,   7-zip  
Func check7z()
	SplashTextOn($title, t('TERM_TESTING') & ' 7-Zip ' & t('TERM_INSTALLER'), 330, 50, -1, $height, 16)
	RunWait($cmd & $7z & ' l -p "' & $file & '"' & $output, $filedir, @SW_HIDE)
	If StringInStr(FileReadLine($debugfile, 4), "Listing archive:", 0) OR StringInStr(FileReadLine($debugfile, 6), "Wrong password?", 0)Then
		; failsafe in case TrID misidentifies MS SFX hotfixes
		;  ,  TrID   MS SFX 
		$infile = FileOpen($debugfile, 0)
		$line = FileReadLine($infile)
		Do
			If StringInStr($line, "_sfx_manifest_") Then
				FileClose($infile)
				FileDelete($debugfile)
				SplashOff()
				extract("hotfix", 'Microsoft ' & t('TERM_HOTFIX'))
			EndIf
			$line = FileReadLine($infile)
		Until @error
		FileClose($infile)
		SplashOff()
		If $fileext = "exe" Then
			extract("7z", '7-Zip ' & t('TERM_INSTALLER') & ' ' & t('TERM_PACKAGE'))
		ElseIf $fileext = "xz" Then
			extract("xz", 'XZ ' & t('TERM_COMPRESSED'))
		ElseIf $fileext = "z" Then
			extract("Z", 'LZW ' & t('TERM_COMPRESSED'))
		EndIf
	EndIf
	FileDelete($debugfile)
	SplashOff()
	$7zfailed = True
	Return False
EndFunc

; Determine if file is self-extracting ARJ archive
;     SFX ARJ 
Func checkArj()
	SplashTextOn($title, t('TERM_TESTING') & ' SFX ARJ ' & t('TERM_ARCHIVE'), 330, 50, -1, $height, 16)
	RunWait($cmd & $arj & ' l "' & $file & '"' & $output, $filedir, @SW_HIDE)
	If StringInStr(FileReadLine($debugfile, 5), "Archive created:", 0) Then
		SplashOff()
		extract("arj", t('TERM_SFX') & ' ARJ ' & t('TERM_ARCHIVE'))
	EndIf
	FileDelete($debugfile)
	SplashOff()
	$arjfailed = True
	Return False
EndFunc

; Determine if file is self-extracting ACE archive
;     SFX ACE 
Func checkAce()
	; Ace testing handled by extract function
	extract("ace", t('TERM_SFX') & ' ACE ' & t('TERM_ARCHIVE'))
	$acefailed = True
	Return False
EndFunc

; Determine if InstallExplorer can extract the file
; ,   InstallExplorer  
Func checkIE()
	SplashTextOn($title, t('TERM_TESTING') & ' InstallExplorer ' & t('TERM_INSTALLER'), 330, 50, -1, $height, 16)
	RunWait($cmd & $ie & ' l "' & $file & '"' & $output, $filedir, @SW_HIDE)
	If StringInStr(FileReadLine($debugfile, 11), '##', 0) Then
		$type = StringStripWS(StringReplace(StringTrimLeft(FileReadLine($debugfile, 11), StringInStr(FileReadLine($debugfile, 11), '-> ', 0) + 2), '##', ''), 3)
		extract("ie", $type & ' ' & t('TERM_INSTALLER'))
	EndIf
	FileDelete($debugfile)
	SplashOff()
	$iefailed = True
	Return False
EndFunc

; Determine if file is Inno Setup installer
;      Inno Setup
Func checkInno()
	SplashTextOn($title, t('TERM_TESTING') & ' Inno Setup ' & t('TERM_INSTALLER'), 330, 50, -1, $height, 16)
	RunWait($cmd & $inno & ' "' & $file & '" >' & $debugfile, $filedir, @SW_HIDE)
	If (StringInStr(FileReadLine($debugfile, 1), "Version detected:", 0) _
		AND NOT (StringInStr(FileReadLine($debugfile, 2), "error", 0) _
		OR StringInStr(FileReadLine($debugfile, 3), "error", 0))) _
		OR (StringInStr(FileReadLine($debugfile, 1), "Signature detected:", 0) _
		AND NOT StringInStr(FileReadLine($debugfile, 1), "not a supported version", 0)) Then
		SplashOff()
		if stringinstr(filereadline($debugfile, 1), "Type in a password", 0) Then 
			$PassNeed = 1
		Else
			$PassNeed = 0
		EndIf
		extract("inno", 'Inno Setup ' & t('TERM_INSTALLER'), $PassNeed)
	EndIf
	FileDelete($debugfile)
	SplashOff()
	$innofailed = True
	checkIE()
	Return False
EndFunc

; Determine if file is really an InstallShield installer (not false positive)
;       InstallShield  (  )
Func checkInstallShield()
	; InstallShield testing handled by extract function
	extract("isexe", 'InstallShield ' & t('TERM_INSTALLER'))
	Return False
EndFunc

; Determine if file is NSIS installer
;      NSIS 
Func checkNSIS()
	SplashTextOn($title, t('TERM_TESTING') & ' NSIS ' & t('TERM_INSTALLER'), 330, 50, -1, $height, 16)
	RunWait($cmd & $7z & ' l "' & $file & '"' & $output, $filedir, @SW_HIDE)
	If StringInStr(FileReadLine($debugfile, 4), "Listing archive:", 0) Then
		SplashOff()
		extract("7z", 'NSIS ' & t('TERM_INSTALLER'))
	EndIf
	FileDelete($debugfile)
	SplashOff()
	checkIE()
	Return False
EndFunc

; Determine if file is self-extracting Zip archive
;     SFX Zip 
Func checkZip()
	SplashTextOn($title, t('TERM_TESTING') & ' SFX ZIP ' & t('TERM_ARCHIVE'), 330, 50, -1, $height, 16)
	RunWait($cmd & $zip & ' -l "' & $file & '"' & $output, $filedir, @SW_HIDE)
	If NOT StringInStr(FileReadLine($debugfile, 2), "signature not found", 0) Then
		SplashOff()
		extract("zip", t('TERM_SFX') & ' ZIP ' & t('TERM_ARCHIVE'))
	EndIf
	FileDelete($debugfile)
	SplashOff()
	$zipfailed = True
	Return False
EndFunc

; Extract from known archive format
;     
Func extract($arctype, $arcdisp, $password = 0)
	; Display banner and create subdirectory
	;     
	SplashTextOn($title, t('EXTRACTING') & @CRLF & $arcdisp, 330, 70, -1, $height, 16)
	If StringRight($outdir, 1) = '\' Then $outdir = StringTrimRight($outdir, 1)
	If FileExists($outdir) Then
		$datatime = @MDAY & '.' & @MON & '.' & StringRight(@YEAR, 2) & '_' & @HOUR & '-' & @MIN
		If Not StringInStr(FileGetAttrib($outdir), "D") Then
			$prompt = MsgBox(51, $title, t("WARN_FILE_EXIST", CreateArray($outdir, $outdir, $outdir, $outdir, $outdir, $datatime)))
			If $prompt = 2 Then $outdir = $outdir & '_' & $datatime
			If $prompt = 6 Then $outdir = $outdir & '_extracted'
			If $prompt = 7 Then $outdir = FileSelectFolder(t('EXTRACT_TO'), "", 3, $filedir)
			If @error Then	$outdir = $filedir & '\' & $filename & '_' & $datatime
	
		EndIf		
		If StringInStr(FileGetAttrib($outdir), "D") Then
			$prompt = MsgBox(51, $title, t("WARN_DIR_EXIST", CreateArray($outdir, $outdir)))
			If $prompt = 6 Then
				$validdir = DirRemove($outdir, 1)
				If NOT $validdir Then terminate("invaliddir", $outdir, "")
			EndIf
			If $prompt = 7 Then $outdir = FileSelectFolder(t('EXTRACT_TO'), "", 3, $filedir)
			If @error Then	$outdir = $filedir & '\' & $filename & '_' & $datatime
		EndIf
	EndIf
	$validdir = DirCreate($outdir)
	If NOT $validdir Then terminate("invaliddir", $outdir, "")
	$createdir = True
	$dirmtime = FileGetTime($outdir, 0, 1)
	$initdirsize = DirGetSize($outdir)
	$tempoutdir = _TempFile($outdir, 'uni_', '')
	; Extract archive based on filetype
	;  ,    
	Select 
		Case $arctype == "7z"
			RunWait($cmd & $7z & ' l -p "' & $file & '"' & $output, $filedir, @SW_HIDE)
			if stringinstr(filereadline($debugfile, 1), "Wrong password?", 0) Then $consolewin = 1
			; Ignore duplicates for specific files: NSIS
			;     : NSIS
			Local $appendargs = ''
			If StringInStr($filetype, 'Nullsoft Install System', 0) Then
				$appendargs = '-aos'
			EndIf

			If StringInStr($filetype, 'Nullsoft PiMP SFX', 0) Then
				$appendargs = '-aou'
			EndIf

			;RunWait($cmd & $7z & ' x -aos "' & $file & '"' & $output, $outdir)
			RunWait($cmd & $7z & ' x ' & $appendargs & ' "' & $file & '"', $outdir, $consolewin)
			; Extract inner CPIO for RPMs
			If StringInStr($filetype, 'RPM Linux Package', 0) Then
				If FileExists($outdir & '\' & $filename & '.cpio') Then
					RunWait($cmd & $7z & ' x "' & $outdir & '\' & $filename & '.cpio"', $outdir, $consolewin)
					FileDelete($outdir & '\' & $filename & '.cpio')
				EndIf

			; Extract inner tarball for DEBs
			ElseIf StringInStr($filetype, 'Debian Linux Package', 0) Then
				If FileExists($outdir & '\data.tar') Then
					RunWait($cmd & $7z & ' x "' & $outdir & '\data.tar"', $outdir, $consolewin)
					FileDelete($outdir & '\data.tar')
				EndIf


			EndIf
			FileWriteLine($debugfile, t('CANNOT_LOG', CreateArray("7-Zip " & $arcdisp)))

		Case $arctype == "ace"
			Opt("WinTitleMatchMode", 3)
			$pid = Run($ace & ' -x "' & $file & '" "' & $outdir & '"', $filedir)
			While 1
				If NOT ProcessExists($pid) Then ExitLoop 
				If WinExists("Error") Then
					ProcessClose($pid)
					ExitLoop 
				EndIf
				Sleep(100)
			WEnd
			FileWriteLine($debugfile, t('CANNOT_LOG', CreateArray($arcdisp)))

		Case $arctype == "arc"
			RunWait($cmd & $arc & ' x "' & $file & '"' & $output, $outdir, $consolewin)

		Case $arctype == "arj"
			RunWait($cmd & $arj & ' x "' & $file & '"' & $output, $outdir, $consolewin)
			FileWriteLine($debugfile, t('CANNOT_LOG', CreateArray($arcdisp)))

		Case $arctype == "bz2"
			;RunWait($cmd & $bz2 & ' x "' & $file & '"' & $output, $outdir)
			RunWait($cmd & $7z & ' x "' & $file & '"', $outdir, $consolewin)
			If FileExists($outdir & '\' & $filename) Then
				;RunWait($cmd & $tar & ' x "' & $outdir & '\' & $filename & '"' & $output, $outdir)
				RunWait($cmd & $7z & ' x "' & $outdir & '\' & $filename & '"', $outdir, $consolewin)
				FileDelete($outdir & '\' & $filename)
			EndIf
			FileWriteLine($debugfile, t('CANNOT_LOG', CreateArray("7-Zip " & $arcdisp)))

		Case $arctype == "cab"
			If StringInStr($filetype, 'Type 1', 0) Then
				If $warnexecute Then Warn_Execute($filename & '.exe /q /x:"<outdir>"')
				RunWait('"' & $file & '" /q /x:"' & $outdir & '"', $outdir, $consolewin)
			Else
				;RunWait($cmd & $7z & ' x -aos "' & $file & '"' & $output, $outdir)
				RunWait($cmd & $7z & ' x "' & $file & '"', $outdir, $consolewin)
				FileWriteLine($debugfile, t('CANNOT_LOG', CreateArray("7-Zip " & $arcdisp)))
			EndIf

		Case $arctype == "cdi"
			; Prompt user to continue
			;    
			SplashOff()
			$convert = MsgBox(65, $title, t('CONVERT_CDROM', CreateArray('CDI')))
			If $convert <> 1 Then
				If $createdir Then DirRemove($outdir, 0)
				terminate("silent", '', '')
			EndIf
			SplashTextOn($title, t('EXTRACTING') & @CRLF & $arcdisp, 330, 70, -1, $height, 16)

			; Begin conversion to .iso format
			;     .iso
			DirCreate($tempoutdir)
			ControlSetText($title, '', 'Static1', t('EXTRACTING') & @CRLF & 'CDI CD-ROM ' & t('TERM_IMAGE') & ' (' & t('TERM_STAGE') & ' 1)')
			RunWait($cmd & $cdi & ' "' & $file & '" -iso' & $output, $tempoutdir, $consolewin)

			; Exit if conversion failed
			; ,    
			$isos = FileFindFirstFile($tempoutdir & '\*.iso')
			If @error Then
				FileClose($isos)
				SplashOff()
				MsgBox(64, $title, t('CONVERT_CDROM_STAGE1_FAILED'))
				DirRemove($tempoutdir, 1)
				If $createdir Then DirRemove($outdir, 0)
				terminate("failed", $file, $arcdisp)

			; Otherwise, begin extraction from .iso
			;  -   .iso
			Else
				ControlSetText($title, '', 'Static1', t('EXTRACTING') & @CRLF & 'CDI CD-ROM ' & t('TERM_IMAGE') & ' (' & t('TERM_STAGE') & ' 2)')
				While 1
					$isofile = FileFindNextFile($isos)
					If @error Then ExitLoop 
					;RunWait($cmd & $7z & ' x -aos "' & $tempoutdir & '\' & $isofile & '"' & $output, $outdir)
					RunWait($cmd & $7z & ' x "' & $tempoutdir & '\' & $isofile & '"', $outdir, $consolewin)
					FileWriteLine($debugfile, t('CANNOT_LOG', CreateArray("7-Zip " & $arcdisp)))
				WEnd
				FileClose($isos)

				; Prompt to keep .iso if extraction failed
				;    .iso,    
				If DirGetSize($outdir) <= $initdirsize Then
					$image = MsgBox(52, $title, t('CONVERT_CDROM_STAGE2_FAILED', CreateArray('CDI')))
					If $image == 7 Then DirRemove($tempoutdir, 1)
					If $createdir Then DirRemove($outdir, 0)
					terminate("silent", '', '')

				; Otherwise, delete .iso
				;   .iso
				Else
					DirRemove($tempoutdir, 1)
					If $createdir Then DirRemove($outdir, 0)
				EndIf
			EndIf

		Case $arctype == "chm"
			RunWait($cmd & $7z & ' x "' & $file & '"', $outdir, $consolewin)
			FileDelete($outdir & '\#*')
			FileDelete($outdir & '\$*')
			$dirs = FileFindFirstFile($outdir & '\*')
			If $dirs <> -1 Then
				$dir = FileFindNextFile($dirs)
				Do
					If StringLeft($dir, 1) == '#' OR StringLeft($dir, 1) == '$' Then DirRemove($outdir & '\' & $dir,  1)
					$dir = FileFindNextFile($dirs)
				Until @error
			EndIf
			FileClose($dirs)
			FileWriteLine($debugfile, t('CANNOT_LOG', CreateArray("7-Zip " & $arcdisp)))

		Case $arctype == "dbx"
			RunWait($cmd & $dbx & ' x "' & $file & '" "' & $outdir & '\"' & $output, $filedir, $consolewin)
		Case $arctype == "fead"
			If $warnexecute Then Warn_Execute($filename & '.exe /s -nos_ne -nos_o"<outdir>"')
			RunWait($file & ' /s -nos_ne -nos_o"' & $tempoutdir & '"', $filedir, $consolewin)
			FileSetAttrib($tempoutdir & '\*', '-R', 1)
			MoveFiles($tempoutdir, $outdir)
			DirRemove($tempoutdir)
			FileWriteLine($debugfile, t('CANNOT_LOG', CreateArray($arcdisp)))

		Case $arctype == "freearc"
			RunWait($cmd & $unarc & ' x "' & $file & '" -o+ -dp"' & $outdir & '"' & $output, $outdir, $consolewin)

		Case $arctype == "gz"
			;RunWait($cmd & $gz & ' x "' & $file & '"' & $output, $outdir)
			RunWait($cmd & $7z & ' x "' & $file & '"', $outdir, $consolewin)
			If FileExists($outdir & '\' & $filename) AND StringTrimLeft($filename, StringInStr($filename, '.', 0, -1)) = "tar" Then
				;RunWait($cmd & $tar & ' x "' & $outdir & '\' & $filename & '"' & $output, $outdir)
				RunWait($cmd & $7z & ' x "' & $outdir & '\' & $filename & '"', $outdir, $consolewin)
				FileDelete($outdir & '\' & $filename)
			EndIf
			FileWriteLine($debugfile, t('CANNOT_LOG', CreateArray("7-Zip " & $arcdisp)))

		Case $arctype == "hlp"
			RunWait($cmd & $hlp & ' "' & $file & '"', $outdir, $consolewin)
			If DirGetSize($outdir) > $initdirsize Then
				DirCreate($tempoutdir)
				RunWait($cmd & $hlp & ' /r /n "' & $file & '"' & $output, $tempoutdir, $consolewin)
				FileMove($tempoutdir & '\' & $filename & '.rtf', $outdir & '\' & $filename & '_Reconstructed.rtf')
				DirRemove($tempoutdir, 1)
			EndIf
			FileWriteLine($debugfile, t('CANNOT_LOG', CreateArray($arcdisp)))

		; failsafe in case TrID misidentifies MS SFX hotfixes
		;  ,  TrID   MS SFX 
		Case $arctype == "hotfix"
			If $warnexecute Then Warn_Execute($filename & '.exe /q /x:"<outdir>"')
			RunWait('"' & $file & '" /q /x:"' & $outdir & '"', $outdir, $consolewin)

		Case $arctype == "ie"
			DirCreate($tempoutdir)
			RunWait($cmd & $ie & ' x "' & $file & '" "' & $tempoutdir & '"' & $output, $filedir, $consolewin)
			; Remove duplicate files
			;  
			If $removedupe Then
				; Read list of extracted files from InstallExplorer
				;       InstallExplorer
				Local $iefiles[1]
				$infile = FileOpen($debugfile, 0)
				$line = FileReadLine($infile, 12)
				Do
					_ArrayAdd($iefiles, StringTrimLeft($line, StringInStr($line, '-> ', 0) + 2))
					$line = FileReadLine($infile)
				Until @error

				; Read actual extracted files
				;    
				$exfiles = FileSearch($tempoutdir)

				; Remove extracted files not listed by InstallExplorer
				;   ,     InstallExplorer
				For $i = 1 To $exfiles[0]
					For $j = 1 To UBound($iefiles) - 1
						If $exfiles[$i] = $tempoutdir & '\' & $iefiles[$j] Then
							ContinueLoop 2
						EndIf
					Next
					FileDelete($exfiles[$i])
				Next

				; Remove duplicate directories
				;   
				For $i = 1 To $exfiles[0]
					If StringInStr(FileGetAttrib($exfiles[$i]), 'D') Then
						If DirGetSize($exfiles[$i]) == 0 Then
							DirRemove($exfiles[$i], 1)
						EndIf
					EndIf
				Next
			EndIf

			; Append missing file extensions
			;    
			If $appendext Then
				AppendExtensions($tempoutdir)
			EndIf

			; Move files to output directory and remove tempdir
			;         
			MoveFiles($tempoutdir & '\', $tempoutdir)
			DirRemove($tempoutdir & '\')
			MoveFiles($tempoutdir, $outdir)
			DirRemove($tempoutdir)

		Case $arctype == "img"
			;RunWait($cmd & $img & ' -x "' & $file & '"' & $output, $outdir, $consolewin)
			RunWait($cmd & $img & ' x "' & $outdir & '\' & $filename & '"', $outdir, $consolewin)

		Case $arctype == "inno"
			If StringInStr($filetype, "Reflexive Arcade", 0) Then
				DirCreate($tempoutdir)
				If $password = 1 Then
					RunWait($cmd & $rai & ' "' & $file & '" "' & $tempoutdir & '\' & $filename & '.exe"' & $output, $filedir)
					RunWait($cmd & $inno & ' -x -m -a "' & $tempoutdir & '\' & $filename & '.exe"' & $output, $outdir)
				Else
					RunWait($cmd & $rai & ' "' & $file & '" "' & $tempoutdir & '\' & $filename & '.exe"' & $output, $filedir, $consolewin)
					RunWait($cmd & $inno & ' -x -m -a "' & $tempoutdir & '\' & $filename & '.exe"' & $output, $outdir, $consolewin)
				EndIf

				FileDelete($tempoutdir & '\' & $filename & '.exe')
				DirRemove($tempoutdir)
			Else
				If $password = 1 Then
					RunWait($cmd & $inno & ' -x -m -a "' & $file & '"' & $output, $outdir)
				Else
					RunWait($cmd & $inno & ' -x -m -a "' & $file & '"' & $output, $outdir, $consolewin)
				EndIf

			EndIf

		Case $arctype == "ctar"
			; Get existing files in $outdir
			;     $outdir
			$oldfiles = ReturnFiles($outdir)

			; Decompress archive with 7-zip
			;     7-zip
			;RunWait($cmd & $7z & ' x "' & $file & '"' & $output, $outdir)
			RunWait($cmd & $7z & ' x "' & $file & '"', $outdir, $consolewin)

			; Check for new files
			;   
			$handle = FileFindFirstFile($outdir & "\*")
			If NOT @error Then
				While 1
					$fname = FileFindNextFile($handle)
					If @error Then ExitLoop 
					If NOT StringInStr($oldfiles, $fname) Then

						; Check for supported archive format
						;     
						;RunWait($cmd & $tar & ' l "' & $outdir & '\' & $fname & '"' & $output, $outdir, @SW_HIDE)
						RunWait($cmd & $7z & ' l "' & $outdir & '\' & $fname & '"' & $output, $outdir, @SW_HIDE)
						If StringInStr(FileReadLine($debugfile, 4), "Listing archive:", 0) Then
							;RunWait($cmd & $tar & ' x "' & $outdir & '\' & $fname & '"' & $output, $outdir, @SW_HIDE)
							RunWait($cmd & $7z & ' x "' & $outdir & '\' & $fname & '"', $outdir, , $consolewin)
							FileWriteLine($debugfile, t('CANNOT_LOG', CreateArray("7-Zip " & $arcdisp)))
							FileDelete($outdir & '\' & $fname)
						EndIf
					EndIf
				WEnd
			EndIf
			FileClose($handle)
			FileWriteLine($debugfile, t('CANNOT_LOG', CreateArray("7-Zip " & $arcdisp)))

		Case $arctype == "is3arc"
			$choice = MethodSelect($arctype, $arcdisp)

			; Extract using ExtractMHT
			;    ExtractMHT
			If $choice == 'i3comp' Then
				RunWait($cmd & $is3arc & ' "' & $file & '" *.* -d -i' & $output, $outdir, $consolewin)

			; Extract using STIX
			;    STIX
			ElseIf $choice == 'STIX' Then
				RunWait($cmd & $is3exe & ' ' & FileGetShortName($file) & ' ' & FileGetShortName($outdir) & $output, $filedir, $consolewin)
			EndIf

		Case $arctype == "iscab"
			; Generate list of files to extract (workaround bug in group mode)
			;      (workaround bug in group mode)
			Local $isfiles[1]
			RunWait($cmd & $is6cab & ' l -o -r -d "' & $file & '"' & $output, $outdir, $consolewin)
			$infile = FileOpen($debugfile, 0)
			$line = FileReadLine($infile)
			Do
				;_ArrayAdd($isfiles, StringTrimLeft($line, StringInStr($line, ' ', 0, -1)))
				_ArrayAdd($isfiles, StringTrimLeft($line, 50))
				$line = FileReadLine($infile)
			Until @error
			FileClose($infile)

			; If successful, display status window and extract files
			;  ,      
			If $isfiles[1] <> '' Then
				SplashOff()
				ISCabExtract($is6cab, $isfiles, $arcdisp)
			EndIf

			; Otherwise, attempt to extract with i5comp
			;      i5comp
			If $isfiles[1] == '' OR DirGetSize($outdir) <= $initdirsize Then
				Local $isfiles[1]
				RunWait($cmd & $is5cab & ' l -o -r -d "' & $file & '"' & $output, $outdir, $consolewin)
				$infile = FileOpen($debugfile, 0)
				$line = FileReadLine($infile)
				Do
					;_ArrayAdd($isfiles, StringTrimLeft($line, StringInStr($line, ' ', 0, -1)))
					_ArrayAdd($isfiles, StringTrimLeft($line, 47))
					$line = FileReadLine($infile)
				Until @error
				FileClose($infile)

				; If successful, display status window and extract files
				;  ,      
				If $isfiles[1] <> '' Then
					SplashOff()
					ISCabExtract($is5cab, $isfiles, $arcdisp)
				EndIf
			EndIf

		Case $arctype == "isexe"
			exescan($file, 'ext', 0)
			If StringInStr($filetype, "3.x", 0) Then
				; Extract 3.x SFX installer using stix
				;   3.x SFX    stix
				RunWait($cmd & $is3exe & ' ' & FileGetShortName($file) & ' ' & FileGetShortName($outdir) & $output, $filedir, $consolewin)

			Else
				$choice = MethodSelect($arctype, $arcdisp)

				; User-specified false positive; return for additional analysis
				;   -  InstallShield;    
				If $choice == 'not InstallShield' Then
					$isfailed = True
					Return False

				; Extract using isxunpack
				;    isxunpack
				ElseIf $choice == 'isxunpack' Then
					FileMove($file, $outdir)
					Run($cmd & $isexe & ' "' & $outdir & '\' & $filename & '.' & $fileext & '"' & $output, $outdir, $consolewin)
					WinWait(@comspec)
					WinActivate(@comspec)
					Send("{ENTER}")
					ProcessWaitClose($isexe)
					FileMove($outdir & '\' & $filename & '.' & $fileext, $filedir)

				; Try to extract using cmdtotal
				;     cmdtotal
				;ElseIf $choice == 'IShield TC Packer' Then
				;	RunWait($cmd & $iswcx & ' x "' & $file & '" "' & $outdir & '\"' & $output, $filedir)

				; Try to extract MSI using cache switch
				;    MSI   cache switch
				ElseIf $choice == 'InstallShield /b' Then
					; Run installer and wait for temp files to be copied
					;       
					If $warnexecute Then Warn_Execute($filename & '.exe /b"<outdir>" /v"/l "<debugfile>""')
					SplashTextOn($title, t('INIT_WAIT'), 330, 70, -1, $height, 16)
					Run('"' & $file & '" /b"' & $tempoutdir & '" /v"/l "' & $debugfile & '""', $filedir)

					; Wait for matching windows for up to 20 seconds (40 * .5)
					;         20  (40 * 0.5)
					Opt("WinTitleMatchMode", 4)
					Local $success
					For $i = 1 To 40
						If NOT WinExists("classname=MsiDialogCloseClass") Then
							Sleep(500)
						Else
							; Search temp directory for MSI support and copy to tempoutdir
							;     MSI     tempoutdir
							$msihandle = FileFindFirstFile($tempoutdir & "\*.msi")
							If NOT @error Then
								While 1
									$msiname = FileFindNextFile($msihandle)
									If @error Then ExitLoop 
									$tsearch = FileSearch(EnvGet("temp") & "\" & $msiname)
									If NOT @error Then
										$isdir = StringLeft($tsearch[1], StringInStr($tsearch[1], '\', 0, -1)-1)
										$ishandle = FileFindFirstFile($isdir & "\*")
										$fname = FileFindNextFile($ishandle)
										Do
											If $fname <> $msiname Then
												FileCopy($isdir & "\" & $fname, $tempoutdir)
											EndIf
											$fname = FileFindNextFile($ishandle)
										Until @error
										FileClose($ishandle)
									EndIf
								WEnd
								FileClose($msihandle)
							EndIf


							; Move files to outdir
							;    outdir
							SplashOff()
							MsgBox(32, $title, t('INIT_COMPLETE', CreateArray(t('TERM_SUCCEEDED'))))
							MoveFiles($tempoutdir, $outdir)
							DirRemove($tempoutdir, 1)
							$success = True
							ExitLoop 
						EndIf
					Next

					; Not a supported installer
					;   
					If NOT $success Then
						SplashOff()
						MsgBox(48, $title, t('INIT_COMPLETE', CreateArray(t('TERM_FAILED'))))
					EndIf
				EndIf
			EndIf

		Case $arctype == "iso"
				DirCreate($tempoutdir)
				RunWait($cmd & $iso & ' x "' & $file & '" "' & $tempoutdir & '\"' & $output, $tempoutdir, $consolewin)

				; Move files to output directory and remove tempdir
				;         
				MoveFiles($tempoutdir, $outdir)
				DirRemove($tempoutdir)

		Case $arctype == "kgb"
			$show_stats = RegRead("HKCU\Software\KGB Archiver", "show_stats")
			RegWrite("HKCU\Software\KGB Archiver", "show_stats", "REG_DWORD", 0)
			RunWait($kgb & ' /s "' & $file & '" "' & $outdir & '"', $outdir, $consolewin)
			If $show_stats == "" Then
				RegDelete("HKCU\Software\KGB Archiver")
			Else
				RegWrite("HKCU\Software\KGB Archiver", "show_stats", "REG_DWORD", $show_stats)
			EndIf

		Case $arctype == "lit"
			RunWait($cmd & $lit & ' "' & $file & '" "' & $outdir & '"' & $output, $outdir, $consolewin)

		Case $arctype == "lzo"
			RunWait($cmd & $lzo & ' -d -p"' & $outdir & '" "' & $file & '"' & $output, $filedir, $consolewin)

		Case $arctype == "lzx"
			RunWait($cmd & $lzx & ' -x "' & $file & '"' & $output, $outdir, $consolewin)

		Case $arctype == "mht"
			$choice = MethodSelect($arctype, $arcdisp)

			; Extract using ExtractMHT
			;    ExtractMHT
			If $choice == 'ExtractMHT' Then
				RunWait($mht & ' "' & $file & '" "' & $outdir & '"', $consolewin)

			ElseIf $choice == 'MHT TC Packer' Then
				DirCreate($tempoutdir)
				RunWait($cmd & $mht_ct & ' x "' & $file & '" "' & $tempoutdir & '\"' & $output, $tempoutdir, $consolewin)

				; Move files to output directory and remove tempdir
				;         
				MoveFiles($tempoutdir, $outdir)
				DirRemove($tempoutdir)
			EndIf

		Case $arctype == "msi"
			$choice = MethodSelect($arctype, $arcdisp)

			; Extract using administrative install
			;     
			If $choice == 'MSI' Then
				RunWait('msiexec.exe /a "' & $file & '" /qb /l ' & $debugfile & ' TARGETDIR="' & $outdir & '"', $filedir, $consolewin)

			; Extract with msi2xml
			;    msi2xml
			;ElseIf $choice == 'msi2xml' Then
			;	RunWait($cmd & $msi_msi2xml & ' -b streams -c files "' & $file & '"' & $output, $outdir)

				; Append missing file extensions
				;If $appendext Then
				;	AppendExtensions($outdir)
				;EndIf

			; Extract with MsiX
			;    MsiX
			ElseIf $choice == 'MsiX' Then
				Local $appendargs = ''
				If $appendext Then $appendargs = '/ext'
				RunWait($cmd & $msi_msix & ' "' & $file & '" /out "' & $outdir & '" ' & $appendargs & $output, $filedir, $consolewin)

			; Extract with JSWare Unpacker
			;    JSWare Unpacker
			ElseIf $choice == 'JSWare Unpacker' Then
				RunWait($msi_JSWare & ' "' & $file & '" "' & $debugfile & '" "' & $outdir & '" ', $filedir, $consolewin)

			; Extract with MSI Total Commander plugin
			;     MSI  Total Commander
			ElseIf $choice == 'MSI TC Packer' Then
				DirCreate($tempoutdir)
				RunWait($cmd & $msi_ct & ' x "' & $file & '" "' & $tempoutdir & '\"' & $output, $filedir, $consolewin)

				; Extract files from extracted CABs
				;     CAB-
				$cabfiles = FileSearch($tempoutdir)
				For $i = 1 To $cabfiles[0]
					filescan($cabfiles[$i], 0)
					If StringInStr($filetype, "Microsoft Cabinet Archive", 0) Then
						;RunWait($cmd & $7z & ' x -aos "' & $cabfiles[$i] & '"' & $output, $tempoutdir)
						RunWait($cmd & $7z & ' x "' & $cabfiles[$i] & '"', $outdir, $consolewin)
						FileWriteLine($debugfile, t('CANNOT_LOG', CreateArray("7-Zip " & $arcdisp)))
						FileDelete($cabfiles[$i])
					EndIf
				Next

				; Append missing file extensions
				;    
				If $appendext Then
					AppendExtensions($tempoutdir)
				EndIf

				; Move files to output directory and remove tempdir
				;         
				MoveFiles($tempoutdir, $outdir)
				DirRemove($tempoutdir)

			EndIf

		Case $arctype == "msm"
			Local $appendargs = ''
			If $appendext Then $appendargs = '/ext'
			RunWait($cmd & $msi_msix & ' "' & $file & '" /out "' & $outdir & '" ' & $appendargs & $output, $filedir, $consolewin)

		Case $arctype == "msp"
			$choice = MethodSelect($arctype, $arcdisp)

			; Extract using TC MSI
			;    TC MSI
			DirCreate($tempoutdir)
			If $choice == 'MSI TC Packer' Then
				RunWait($cmd & $msi_ct & ' x "' & $file & '" "' & $tempoutdir & '\"' & $output, $filedir, $consolewin)

			; Extract with MsiX
			;    MsiX
			ElseIf $choice == 'MsiX' Then
				RunWait($cmd & $msi_msix & ' "' & $file & '" /out "' & $tempoutdir & '"' & $output, $filedir, $consolewin)

			; Extract using 7-Zip
			;    7-Zip
			ElseIf $choice == '7-Zip' Then
				;RunWait($cmd & $7z & ' x -aos "' & $file & '"' & $output, $tempoutdir)
				RunWait($cmd & $7z & ' x "' & $file & '"', $outdir, $consolewin)
				FileWriteLine($debugfile, t('CANNOT_LOG', CreateArray("7-Zip " & $arcdisp)))

			EndIf

			; Regardless of method, extract files from extracted CABs
			;        CABs
			$cabfiles = FileSearch($tempoutdir)
			For $i = 1 To $cabfiles[0]
				filescan($cabfiles[$i], 0)
				If StringInStr($filetype, "Microsoft Cabinet Archive", 0) Then
					;RunWait($cmd & $7z & ' x -aos "' & $cabfiles[$i] & '"' & $output, $tempoutdir)
					RunWait($cmd & $7z & ' x "' & $cabfiles[$i] & '"', $outdir, $consolewin)
					FileWriteLine($debugfile, t('CANNOT_LOG', CreateArray("7-Zip " & $arcdisp)))
					FileDelete($cabfiles[$i])
				EndIf
			Next

			; Append missing file extensions
			;    
			If $appendext Then
				AppendExtensions($tempoutdir)
			EndIf

			; Move files to output directory and remove tempdir
			;         
			MoveFiles($tempoutdir, $outdir)
			DirRemove($tempoutdir)

		Case $arctype == "msu"
			DirCreate($tempoutdir)
			;RunWait($cmd & $7z & ' x -aos "' & $file & '"' & $output, $tempoutdir)
			RunWait($cmd & $7z & ' x "' & $file & '"', $outdir, $consolewin)
			FileWriteLine($debugfile, t('CANNOT_LOG', CreateArray("7-Zip " & $arcdisp)))

			; Regardless of method, extract files from extracted CABs
			;        CABs
			$cabfiles = FileSearch($tempoutdir)
			For $i = 1 To $cabfiles[0]
				filescan($cabfiles[$i], 0)
				If StringInStr($filetype, "Microsoft Cabinet Archive", 0) Then
					;RunWait($cmd & $7z & ' x -aos "' & $cabfiles[$i] & '"' & $output, $tempoutdir)
					RunWait($cmd & $7z & ' x "' & $cabfiles[$i] & '"', $outdir, $consolewin)
					FileWriteLine($debugfile, t('CANNOT_LOG', CreateArray("7-Zip " & $arcdisp)))
					FileDelete($cabfiles[$i])
				EndIf
			Next

			; Append missing file extensions
			;    
			If $appendext Then
				AppendExtensions($tempoutdir)
			EndIf

			; Move files to output directory and remove tempdir
			;         
			MoveFiles($tempoutdir, $outdir)
			DirRemove($tempoutdir)

		Case $arctype == "nbh"
			RunWait($cmd & $nbh & ' "' & $file & '"', $outdir, $consolewin)

		Case $arctype == "pea"
			Local $pid, $windows, $title, $status
			$pid = Run($pea & ' UNPEA "' & $file & '" "' & $tempoutdir & '" RESETDATE SETATTR EXTRACT2DIR INTERACTIVE', $filedir, $consolewin)
			WinWait("PEA", "", 20)
			$windows = WinList("PEA")
			For $i = 0 To $windows[0][0]
				If WinGetProcess($windows[$i][0]) == $pid Then
					$peatitle = $windows[$i][0]
				EndIf
			Next
			While ProcessExists($pid)
				$status = ControlGetText($peatitle, '', 'Button1')
				If StringLeft($status, 4) = 'Done' Then ProcessClose($pid)
				Sleep(10)
			WEnd
			MoveFiles($tempoutdir, $outdir)
			DirRemove($tempoutdir)
			FileWriteLine($debugfile, t('CANNOT_LOG', CreateArray($arcdisp)))

		Case $arctype == "rar"
			RunWait($cmd & $rar & ' t -p- "' & $file & '"' & $output, $filedir, @SW_HIDE)
			if stringinstr(filereadline($debugfile, 8), "(password incorrect ?)", 0) Then $consolewin = 1
			RunWait($cmd & $rar & ' x "' & $file & '"' & $output, $outdir, $consolewin)


		Case $arctype == "robo"
			If $warnexecute Then Warn_Execute($filename & '.exe /unpack="<outdir>"')
			RunWait($file & ' /unpack="' & $outdir & '"', $filedir, $consolewin)
			FileWriteLine($debugfile, t('CANNOT_LOG', CreateArray($arcdisp)))

		Case $arctype == "sis"
			RunWait($cmd & $sis & ' x "' & $file & '" "' & $outdir & '\"' & $output, $filedir, $consolewin)

		Case $arctype == "sit"
			DirCreate($tempoutdir)
			FileMove($file, $tempoutdir)
			RunWait($sit & ' "' & $tempoutdir & '\' & $filename & '.' & $fileext & '"', $tempoutdir, $consolewin)
			FileMove($tempoutdir & '\' & $filename & '.' & $fileext, $file)
			MoveFiles($tempoutdir & '\' & $filename, $outdir)
			DirRemove($tempoutdir, 1)
			FileWriteLine($debugfile, t('CANNOT_LOG', CreateArray($arcdisp)))

		Case $arctype == "superdat"
			If $warnexecute Then Warn_Execute($filename & '.exe /e "<outdir>"')
			RunWait($file & ' /e "' & $outdir & '"', $outdir, $consolewin)
			FileMove($filedir & '\SuperDAT.log', $debugfile, 1)

		Case $arctype == "tar"
			If $fileext = "tar" Then
				;RunWait($cmd & $tar & ' x "' & $file & '"' & $output, $outdir)
				RunWait($cmd & $7z & ' x "' & $file & '"', $outdir, $consolewin)
			Else
				;RunWait($cmd & $7z & ' x "' & $file & '"' & $output, $outdir)
				RunWait($cmd & $7z & ' x "' & $file & '"', $outdir, $consolewin)
				;RunWait($cmd & $tar & ' x "' & $outdir & '\' & $filename  & '.tar"' & $output, $outdir)
				RunWait($cmd & $7z & ' x "' & $outdir & '\' & $filename & '.tar"', $outdir, $consolewin)
				FileDelete($outdir & '\' & $filename & '.tar')
			EndIf
			FileWriteLine($debugfile, t('CANNOT_LOG', CreateArray("7-Zip " & $arcdisp)))
			
		Case $arctype == "vssfx"
			If $warnexecute Then Warn_Execute($filename & '.exe /extract')
			FileMove($file, $outdir)
			RunWait($outdir & '\' & $filename & '.' & $fileext & ' /extract', $outdir, $consolewin)
			FileMove($outdir & '\' & $filename & '.' & $fileext, $filedir)

		; removed - not possible to access due to 7zip check after deep scan
		;  -         7zip   
		;Case $arctype == "vssfxhotfix"
		;	If $warnexecute Then Warn_Execute($filename & '.exe /xp:"<outdir>" /q')
		;	RunWait($file & ' /xp:"' & $outdir & '" /q', $outdir)

		Case $arctype == "vssfxpath"
			If $warnexecute Then Warn_Execute($filename & '.exe /extract:"<outdir>" /quiet')
			RunWait($file & ' /extract:"' & $outdir & '" /quiet', $outdir, $consolewin)

		Case $arctype == "wise"
			$choice = MethodSelect($arctype, $arcdisp)

			; Extract with E_WISE
			;    E_WISE
			If $choice == 'E_Wise' Then
				RunWait($cmd & $wise_ewise & ' "' & $file & '" "' & $outdir & '"' & $output, $filedir, $consolewin)
				If DirGetSize($outdir) > $initdirsize Then
					RunWait($cmd & '00000000.BAT', $outdir, , $consolewin)
					FileDelete($outdir & '\00000000.BAT')
				EndIf

			; Extract with WUN
			;    WUN
			ElseIf $choice == 'WUN' Then
				RunWait($cmd & $wise_wun & ' "' & $filename & '" "' & $tempoutdir & '"', $filedir, $consolewin)
				If $removetemp Then
					FileDelete($tempoutdir & "\INST0*")
					FileDelete($tempoutdir & "\WISE0*")
				Else
					FileMove($tempoutdir & "\INST0*", $outdir)
					FileMove($tempoutdir & "\WISE0*", $outdir)
				EndIf
				MoveFiles($tempoutdir, $outdir)
				DirRemove($tempoutdir)
				FileWriteLine($debugfile, t('CANNOT_LOG', CreateArray($arcdisp)))

			; Extract using the /x switch
			;     /x
			ElseIf $choice == 'Wise Installer /x' Then
				If $warnexecute Then Warn_Execute($filename & '.exe /x <outdir>')
				RunWait($file & ' /x ' & $outdir, $filedir, $consolewin)
				FileWriteLine($debugfile, t('CANNOT_LOG', CreateArray($arcdisp)))

			; Attempt to extract MSI
			;  t MSI
			ElseIf $choice == 'Wise MSI' Then

				; Prompt to continue
				;   
				SplashOff()
				$continue = MsgBox(65, $title, t('WISE_MSI_PROMPT', CreateArray($name)))
				If $continue <> 1 Then
					If $createdir Then DirRemove($outdir, 0)
					terminate("silent", '', '')
				EndIf

				; First, check for any files that are already in extraction dir
				;      =    
				If $warnexecute Then Warn_Execute($filename & '.exe /?')
				SplashTextOn($title, t('EXTRACTING') & @CRLF & $arcdisp, 330, 70, -1, $height, 16)
				$oldfiles = ReturnFiles(@commonfilesdir & "\Wise Installation Wizard")

				; Run installer
				;  
				Opt("WinTitleMatchMode", 3)
				$pid = Run($file & ' /?', $filedir)
				While 1
					Sleep(10)
					If WinExists("Windows Installer") Then
						WinSetState("Windows Installer", '', @SW_HIDE)
						ExitLoop 
					Else
						If NOT ProcessExists($pid) Then ExitLoop 
					EndIf
				WEnd

				; Move new files
				;   
				MoveFiles(@commonfilesdir & "\Wise Installation Wizard", $outdir, 0, $oldfiles)
				DirRemove(@commonfilesdir & "\Wise Installation Wizard", 0)
				WinClose("Windows Installer")
				FileWriteLine($debugfile, t('CANNOT_LOG', CreateArray($arcdisp)))

			; Extract using unzip, falling back to 7-Zip
			;    unzip,   -   7-Zip
			ElseIf $choice == 'Unzip' Then
				$return = RunWait($cmd & $zip & ' -x "' & $file & '"', $outdir, $consolewin)
				If $return <> 0 Then
					;RunWait($cmd & $7z & ' x -aos "' & $file & '"' & $output, $outdir)
					RunWait($cmd & $7z & ' x "' & $file & '"', $outdir, $consolewin)
					FileWriteLine($debugfile, t('CANNOT_LOG', CreateArray("7-Zip " & $arcdisp)))
				EndIf
			EndIf

			; Append missing file extensions
			;    
			If $appendext Then
				AppendExtensions($outdir)
			EndIf

		Case $arctype == "uha"
			RunWait($cmd & $uharc & ' x -t"' & $outdir & '" "' & $file & '"' & $output, $outdir, $consolewin)
			If DirGetSize($outdir) <= $initdirsize Then
				$error = FileReadLine($debugfile, 6)
				If StringInStr($error, "use UHARC version", 0) Then
					$version = StringTrimLeft($error, StringInStr($error, ' ', 0, -1))
					If $version == '0.4' Then
						RunWait($cmd & $uharc04 & ' x -t"' & $outdir & '" "' & $file & '"' & $output, $outdir, $consolewin)
					ElseIf $version == '0.2' Then
						RunWait($cmd & $uharc02 & ' x -t' & FileGetShortName($outdir) & ' ' & FileGetShortName($file) & $output, $outdir, $consolewin)
					EndIf
				EndIf
			EndIf

		Case $arctype == "uu"
			RunWait($cmd & $uu & ' -p "' & $outdir & '" -i "' & $file & '"', $filedir, $consolewin)

		Case $arctype == "xz"
			RunWait($cmd & $7z & ' x "' & $file & '"', $outdir, $consolewin)
			If FileExists($outdir & '\' & $filename) AND StringTrimLeft($filename, StringInStr($filename, '.', 0, -1)) = "tar" Then
				RunWait($cmd & $7z & ' x "' & $outdir & '\' & $filename & '"', $outdir, $consolewin)
				FileDelete($outdir & '\' & $filename)
			EndIf
			FileWriteLine($debugfile, t('CANNOT_LOG', CreateArray("7-Zip " & $arcdisp)))

		Case $arctype == "Z"
			;RunWait($cmd & $Z & ' x "' & $file & '"' & $output, $outdir)
			RunWait($cmd & $7z & ' x "' & $file & '"', $outdir, $consolewin)
			If FileExists($outdir & '\' & $filename) AND StringTrimLeft($filename, StringInStr($filename, '.', 0, -1)) = "tar" Then
				RunWait($cmd & $7z & ' x "' & $outdir & '\' & $filename & '"', $outdir, $consolewin)
				FileDelete($outdir & '\' & $filename)
			EndIf
			FileWriteLine($debugfile, t('CANNOT_LOG', CreateArray("7-Zip " & $arcdisp)))

		Case $arctype == "zip"
			RunWait($cmd & $zip & ' -t -P p "' & $file & '"' & $output, $filedir, @SW_HIDE)
			if stringinstr(filereadline($debugfile, 4), "because of incorrect password", 0) Then $consolewin = 1
			$return = RunWait($cmd & $zip & ' -x "' & $file & '"' & $output, $outdir, $consolewin)
			If $return > 1 Then
				;RunWait($cmd & $7z & ' x -aos "' & $file & '"' & $output, $outdir)
				RunWait($cmd & $7z & ' x "' & $file & '"', $outdir, $consolewin)
				FileWriteLine($debugfile, t('CANNOT_LOG', CreateArray("7-Zip " & $arcdisp)))
			EndIf

		Case $arctype == "zoo"
			DirCreate($tempoutdir)
			FileMove($file, $tempoutdir)
			RunWait($cmd & $zoo & ' x ' & FileGetShortName($filename & '.' & $fileext) & $output, $tempoutdir, $consolewin)
			FileMove($tempoutdir & '\' & $filename & '.' & $fileext, $file)
			MoveFiles($tempoutdir, $outdir)
			DirRemove($tempoutdir)
	EndSelect

	; Check for successful output
	;   
	SplashOff()
	If $createdir Then
		If DirGetSize($outdir) <= $initdirsize Then
			If $createdir Then DirRemove($outdir, 0)
			If $arctype == "ace" AND $fileext = "exe" Then Return False
			terminate("failed", $file, $arcdisp)
		EndIf
	Else
		;MsgBox(0, 'Test', "new = " & FileGetTime($outdir, 0, 1) & @CRLF & "old   = " & $dirmtime)
		If FileGetTime($outdir, 0, 1) == $dirmtime Then
			terminate("failed", $file, $arcdisp)
		EndIf
	EndIf
	terminate("success", "", "")
EndFunc

; Unpack packed executable
;    
Func unpack()
	Local $packer
	If StringInStr($filetype, "UPX", 0) OR $fileext = "dll" Then
		$packer = "UPX"
	ElseIf StringInStr($filetype, "ASPack", 0) Then
		$packer = "ASPack"
	EndIf

	; prompt to continue
	;   
	$unpack = MsgBox(65, $title, t('UNPack_PROMPT', CreateArray($packer, $filedir, $filename, $fileext)))
	If $unpack <> 1 Then Return

	; unpack file
	;  
	If $packer == "UPX" Then
		RunWait($cmd & $upx & ' -d -k "' & $file & '"', $filedir, $consolewin)
		$tempext = StringTrimRight($fileext, 1) & '~'
		If FileExists($filedir & "\" & $filename & "." & $tempext) Then
			FileMove($file, $filedir & "\" & $filename & "_" & t('TERM_UNPackED') & "." & $fileext, 1)
			FileMove($filedir & "\" & $filename & "." & $tempext, $file)
			terminate("success", "", "")
		Else
			MsgBox(48, $title, t('UNPack_FAILED', CreateArray($file)))
			terminate("silent", '', '')
		EndIf
	ElseIf $packer == "ASPack" Then
		$choice = MethodSelect("ASPack", "ASPack " & t('TERM_PackAGE'))
		If $choice == "AspackDie 2.2" Then $aspack = $aspack22
		RunWait($cmd & $aspack & ' "' & $file & '" "' & $filedir & '\' & $filename & '_' & t('TERM_UNPackED') & '.exe" /NO_PROMPT', $filedir)
		If FileExists($filedir & "\" & $filename & "_" & t('TERM_UNPackED') & ".exe") Then
			terminate("success", "", "")
		Else
			MsgBox(48, $title, t('UNPack_FAILED', CreateArray($file)))
			terminate("silent", '', '')
		EndIf
	EndIf
	Return
EndFunc

; Return list of files and directories in directory as a pipe-delimited string
;       ,  |
Func ReturnFiles($dir)
	Local $handle, $files, $fname
	$handle = FileFindFirstFile($dir & "\*")
	If NOT @error Then
		While 1
			$fname = FileFindNextFile($handle)
			If @error Then ExitLoop 
			$files &= $fname & '|'
		WEnd
		StringTrimRight($files, 1)
		FileClose($handle)
	Else
		SetError(1)
		Return 
	EndIf
	Return $files
EndFunc

; Move all files and subdirectories from one directory to another
; $force is an integer that specifies whether or not to replace existing files
; $omit is a string that includes files to be excluded from move
;          
; $force - ,       
; $omit -     ,    
Func MoveFiles($source, $dest, $force = 0, $omit = '')
	Local $handle, $fname
	DirCreate($dest)
	$handle = FileFindFirstFile($source & "\*")
	If NOT @error Then
		While 1
			$fname = FileFindNextFile($handle)
			If @error Then
				ExitLoop 
			ElseIf StringInStr($omit, $fname) Then
				ContinueLoop 
			Else
				If StringInStr(FileGetAttrib($source & '\' & $fname), 'D') Then
					DirMove($source & '\' & $fname, $dest, 1)
				Else
					FileMove($source & '\' & $fname, $dest, $force)
				EndIf
			EndIf
		WEnd
		FileClose($handle)
	Else
		SetError(1)
		Return 
	EndIf
EndFunc

; Extract contents of InstallShield cabs file-by-file
;   InstallShield cabs 
Func ISCabExtract($iscab, $files, $subtitle)
	ProgressOn($title, $subtitle, '', -1, $height, 16)
	For $i = 1 To UBound($files)-1
		ProgressSet(Round($i/(UBound($files)-1), 2)*100, 'Extracting: ' & $files[$i])
		RunWait($cmd & $iscab & ' x -r -d "' & $file & '" "' & $files[$i] & '"', $outdir, , $consolewin)
	Next
	ProgressOff()
EndFunc

; Append missing file extensions using TrID
;       TrID
Func AppendExtensions($dir)
	Local $files
	$files = FileSearch($dir)
	If $files[1] <> '' Then
		For $i = 1 To $files[0]
			If NOT StringInStr(FileGetAttrib($files[$i]), 'D') Then
				$filename = StringTrimLeft($files[$i], StringInStr($files[$i], '\', 0, -1))
				If NOT StringInStr($filename, '.') _
					OR StringLeft($filename, 7) = 'Binary.' _
					OR StringRight($filename, 4) = '.bin' Then
					RunWait($cmd & $trid & ' "' & $files[$i] & '" -ae', $dir, , $consolewin)
				EndIf
			EndIf
		Next
	EndIf
EndFunc

; Recursively search for given pattern
; code by w0uter (http://www.autoitscript.com/forum/index.php?showtopic=16421)
;  
Func FileSearch($s_Mask = '', $i_Recurse = 1)
	Local $s_Buf = ''
	If $i_Recurse Then
		Local $s_Command = ' /c dir /B /S "'
	Else
		Local $s_Command = ' /c dir /B "'
	EndIf
	$i_Pid = Run(@ComSpec & $s_Command & $s_Mask & '"', @WorkingDir, @SW_HIDE, 2+4)
	While NOT @error
		$s_Buf &= StdoutRead($i_Pid)
	WEnd
	$s_Buf = StringSplit(StringTrimRight($s_Buf, 2), @CRLF, 1)
	ProcessClose($i_Pid)
	If UBound($s_Buf) = 2 AND $s_Buf[1] = '' Then SetError(1)
	Return $s_Buf
EndFunc

; Search %path% for passed executable
;   %path%   
Func PathSearch($file)
	; Search DOS path directories
	;  DOS 
	$dir = StringSplit(EnvGet("path"), ';')
	ReDim $dir[$dir[0]+1]
	$dir[$dir[0]] = @scriptdir
	For $i = 1 To $dir[0]
		$exefiles = FileFindFirstFile($dir[$i] & "\*.exe")
		If $exefiles == -1 Then ContinueLoop 
		$exename = FileFindNextFile($exefiles)
		Do
			If $exename = $file Then
				FileClose($exefiles)
				Return _PathFull($dir[$i] & '\' & $exename)
			EndIf
			$exename = FileFindNextFile($exefiles)
		Until @error
		FileClose($exefiles)
	Next

	; Search Windows registered applications
	;$apppaths = "HKLM\SOFTWARE\Microsoft\Windows\CurrentVersion\App Paths"
	;$i = 1
	;$exefile = RegEnumKey($apppaths, $i)
	;Do
	;	If $exefile = $file Then
	;		$exepath = RegRead($apppaths & '\' & $exefile, '')
	;		If FileExists($exepath) Then
	;			Return $exepath
	;		Else
	;			Return False
	;		EndIf
	;	EndIf
	;	$i = $i + 1
	;	$exefile = RegEnumKey($apppaths, $i)
	;Until @error
	Return False
EndFunc

; Handle program termination with appropriate error message
;           
Func terminate($status, $fname, $id)
	; Display error message if file could not be extracted
	;    ,      
	Select 
		; Display usage information and exit
		;    
		Case $status == "syntax"
			$syntax = t('HELP_SUMMARY')
			$syntax &= t('HELP_SYNTAX', CreateArray(@scriptname))
			$syntax &= t('HELP_ARGUMENTS')
			$syntax &= t('HELP_HELP')
			$syntax &= t('HELP_PREFS')
			$syntax &= t('HELP_FILENAME')
			$syntax &= t('HELP_DESTINATION')
			$syntax &= t('HELP_SUB', CreateArray($name))
			$syntax &= t('HELP_EXAMPLE1')
			$syntax &= t('HELP_EXAMPLE2', CreateArray(@scriptname))
			$syntax &= t('HELP_NOARGS', CreateArray($name))
			MsgBox(48, $title, $syntax)
			$exitcode = 0

		; Debug file is not writable
		;    
		Case $status == "debug"
			MsgBox(48, $title, t('CANNOT_DEBUG', CreateArray($fname, $name)))
			$exitcode = 2

		; Display error information and exit
		;      
		Case $status == "unknownexe"
			$prompt = MsgBox(305, $title, t('CANNOT_EXTRACT', CreateArray($file, $id)))
			If $prompt == 1 Then
				Run($peid & ' "' & $file & '"', $filedir)
				WinWait($peidtitle)
				WinActivate($peidtitle)
			EndIf
			$exitcode = 3
		Case $status == "unknownext"
			MsgBox(48, $title, t('UNKNOWN_EXT', CreateArray($file)))
			$exitcode = 4
		Case $status == "invaliddir"
			MsgBox(48, $title, t('INVALID_DIR', CreateArray($fname)))
			$exitcode = 5
		; Display failed attempt information and exit
		;       
		Case $status == "failed"

			; Convert log to DOS format
			;    DOS 
			RunWait($cmd & 'type ' & FileGetShortName($debugfile) & ' >' & FileGetShortName(EnvParse($debugdir)) & 'uniextract_temp.txt', EnvParse($debugdir), $consolewin)
			FileMove(FileGetShortName(EnvParse($debugdir)) & 'uniextract_temp.txt', $debugfile, 1)
			$prompt = MsgBox(305, $title, t('EXTRACT_FAILED', CreateArray($file, $id, FileGetLongName($debugfile))))
			If $prompt == 1 Then
				ShellExecute($debugfile)
			EndIf
			$exitcode = 1

		; Exit successfully
		;     
		Case $status == "success"
			FileDelete($debugfile)
			$exitcode = 0
		; Exit silently
		;   
		Case $status == "silent"
			$exitcode = 0
	EndSelect
	Exit $exitcode
EndFunc

; Function to prompt user for choice of extraction method
;         
Func MethodSelect($format, $splashdisp)
	SplashOff()
	$base_height = 130
	$base_radio = 100
	$url = 'dummy'
	If $format == 'wise' Then
		$select_type = 'Wise Installer'
		Dim $method[5][2], $select[5]
		$method[0][0] = 'E_Wise'
		$method[0][1] = 'METHOD_UNPackER_RADIO'
		$method[1][0] = 'WUN'
		$method[1][1] = 'METHOD_UNPackER_RADIO'
		$method[2][0] = 'Wise Installer /x'
		$method[2][1] = 'METHOD_SWITCH_RADIO'
		$method[3][0] = 'Wise MSI'
		$method[3][1] = 'METHOD_EXTRACTION_RADIO'
		$method[4][0] = 'Unzip'
		$method[4][1] = 'METHOD_EXTRACTION_RADIO'
		;$base_height += 45
	ElseIf $format == 'msi' Then
		$select_type = 'MSI Installer'
		Dim $method[4][2], $select[4]
		$method[0][0] = 'MSI'
		$method[0][1] = 'METHOD_ADMIN_RADIO'
		$method[1][0] = 'MsiX'
		$method[1][1] = 'METHOD_EXTRACTION_RADIO'
		;$method[1][0] = 'msi2xml'
		;$method[1][1] = 'METHOD_EXTRACTION_RADIO'
		$method[2][0] = 'MSI TC Packer'
		$method[2][1] = 'METHOD_EXTRACTION_RADIO'
		$method[3][0] = 'JSWare Unpacker'
		$method[3][1] = 'METHOD_EXTRACTION_RADIO'
		;$base_height += 15
		;$base_radio += 15
	ElseIf $format == 'msp' Then
		$select_type = 'MSP Package'
		Dim $method[3][2], $select[3]
		$method[0][0] = 'MSI TC Packer'
		$method[0][1] = 'METHOD_EXTRACTION_RADIO'
		$method[1][0] = 'MsiX'
		$method[1][1] = 'METHOD_EXTRACTION_RADIO'
		$method[2][0] = '7-Zip'
		$method[2][1] = 'METHOD_EXTRACTION_RADIO'
	ElseIf $format == 'mht' Then
		$select_type = 'MHTML Archive'
		Dim $method[2][2], $select[2]
		$method[0][0] = 'ExtractMHT'
		$method[0][1] = 'METHOD_EXTRACTION_RADIO'
		$method[1][0] = 'MHT TC Packer'
		$method[1][1] = 'METHOD_EXTRACTION_RADIO'
	ElseIf $format == 'is3arc' Then
		$select_type = 'InstallShield 3.x Archive'
		Dim $method[2][2], $select[2]
		$method[0][0] = 'i3comp'
		$method[0][1] = 'METHOD_EXTRACTION_RADIO'
		$method[1][0] = 'STIX'
		$method[1][1] = 'METHOD_EXTRACTION_RADIO'
	ElseIf $format == 'isexe' Then
		$select_type = 'InstallShield Installer'
		Dim $method[3][2], $select[3]
		$method[0][0] = 'isxunpack'
		$method[0][1] = 'METHOD_EXTRACTION_RADIO'
		$method[1][0] = 'InstallShield /b'
		$method[1][1] = 'METHOD_SWITCH_RADIO'
		$method[2][0] = 'not InstallShield'
		$method[2][1] = 'METHOD_NOTIS_RADIO'
	ElseIf $format == 'ASPack' Then
		$select_type = 'ASPack Packer'
		Dim $method[2][2], $select[2]
		$method[0][0] = 'AspackDie 2.12'
		$method[0][1] = 'METHOD_UNPackER_RADIO'
		$method[1][0] = 'AspackDie 2.2'
		$method[1][1] = 'METHOD_UNPackER_RADIO'
	EndIf

	; Create GUI and set header information
	;  GUI    
	Opt("GUIOnEventMode", 0)
	Local $guimethod = GUICreate($title, 330, $base_height + (UBound($method) * 20))
	$header = GUICtrlCreateLabel(t('METHOD_HEADER', CreateArray($select_type)), 5, 5, 320, 20)
	GUICtrlCreateLabel(t('METHOD_TEXT_LABEL', CreateArray($name, $select_type, $name)), 5, 25, 320, 65, $SS_LEFT)
	#cs
	if $format == 'msi' Then
		local $note = GUICtrlCreateLabel(t('METHOD_MSI_NOTE_LABEL'), 5, 80, -1, 20)
		local $requirespos = GetPos($guimethod, $note, 0)
		local $requires = GUICtrlCreateLabel(t('METHOD_MSI_REQUIRES_LABEL'), $requirespos, 80, -1, 20)
		local $urlpos = GetPos($guimethod, $requires, -5)
		local $url = GUICtrlCreateLabel(t('METHOD_MSI_URL_LABEL'), $urlpos, 80, -1, 20)
	EndIf
	#ce
	; Create radio selection options
	;  -  
	GUICtrlCreateGroup(t('METHOD_RADIO_LABEL'), 5, $base_radio, 215, 25 + (UBound($method) * 20))
	For $i = 0 To UBound($method)-1
		$select[$i] = GUICtrlCreateRadio(t($method[$i][1], CreateArray($method[$i][0])), 10, $base_radio + 20 + ($i * 20), 205, 20)
	Next
	GUICtrlCreateGroup("", -99, -99, 1, 1)
	; Create buttons
	;  
	$ok = GUICtrlCreateButton(t('OK_BUT'), 235, $base_radio - 10 + (UBound($method) * 10), 80, 20)
	$cancel = GUICtrlCreateButton(t('CANCEL_BUT'), 235, $base_radio - 10 + (UBound($method) * 10) + 30, 80, 20)

	; Set properties
	;  
	GUICtrlSetFont($header, -1, 1200)
	GUICtrlSetState($select[0], $GUI_CHECKED)
	GUICtrlSetState($ok, $GUI_DEFBUTTON)
	#cs
	If $format == 'msi' Then
		GUICtrlSetFont($note, 8.7, 800)
		GUICtrlSetFont($url, 8.7, -1, 4)
		GUICtrlSetColor($url, 0x0000ff)
		GUICtrlSetCursor($url, 0)
	EndIf
	#ce

	; Display GUI and wait for action
	;  GUI    
	GUISetState(@SW_SHOW)
	While 1
		$action = GUIGetMsg()
		Select 
			Case $action == $ok
				For $i = 0 To UBound($method)-1
					If GUICtrlRead($select[$i]) == $GUI_CHECKED Then
						GUIDelete($guimethod)
						SplashTextOn($title, t('EXTRACTING') & @CRLF & $splashdisp, 330, 70, -1, $height, 16)
						Return $method[$i][0]
					EndIf
				Next

			; Exit if Cancel clicked or window closed
			; ,       
			Case $action == $GUI_EVENT_CLOSE OR $action == $cancel
				If $createdir Then DirRemove($outdir, 0)
				terminate("silent", '', '')

			; Launch URL in browser (only valid for MSI)
			;  URL   (  MSI)
			;Case $action == $url
				;ShellExecute($msxml_down)

		EndSelect
	WEnd
EndFunc

; Warn user before executing files for extraction
;      
Func Warn_Execute($command)
	$prompt = MsgBox(49, $title, t('WARN_EXECUTE', CreateArray($command)))
	If $prompt <> 1 Then
		If $createdir Then DirRemove($outdir, 0)
		terminate('silent', '', '')
	EndIf
	Return True
EndFunc

; Create array on the fly
; Code based on _CreateArray UDF, which has been deprecated
;   " ".   _CreateArray UDF,  
Func CreateArray($i0, $i1 = 0, $i2 = 0, $i3 = 0, $i4 = 0, $i5 = 0, $i6 = 0, $i7 = 0, $i8 = 0, $i9 = 0)
	Local $arr[10] = [$i0, $i1, $i2, $i3, $i4, $i5, $i6, $i7, $i8, $i9]
	ReDim $arr[@numparams]
	Return $arr
EndFunc

; ------------------------ Begin GUI Control Functions ------------------------
; ------------------------                          ------------------------

; Build and display GUI if necessary (moved to function to allow on-the-fly language changes)
;    GUI   (   " ")
Func CreateGUI()
	; Create GUI
	;  GUI
	Global $guimain = GUICreate($title, 350, 135, -1, -1, -1, $WS_EX_ACCEPTFILES)
	Local $dropzone = GUICtrlCreateLabel("", 0, 0, 300, 135)

	; Menu controls
	;  
	Local $filemenu = GUICtrlCreateMenu(t('MENU_FILE_LABEL'))
	Local $quititem = GUICtrlCreateMenuItem(t('MENU_FILE_QUIT_LABEL'), $filemenu)
	Local $editmenu = GUICtrlCreateMenu(t('MENU_EDIT_LABEL'))
	Local $prefsitem = GUICtrlCreateMenuItem(t('MENU_EDIT_PREFS_LABEL'), $editmenu)
	Local $helpmenu = GUICtrlCreateMenu(t('MENU_HELP_LABEL'))
	Local $webitem = GUICtrlCreateMenuItem(t('MENU_HELP_WEB_LABEL', CreateArray($name)), $helpmenu)
	Local $aboutitem = GUICtrlCreateMenuItem(t('MENU_HELP_ABOUT_LABEL', CreateArray($name)), $helpmenu)

	; File controls
	;   
	GUICtrlCreateLabel(t('MAIN_FILE_LABEL'), 5, 5, -1, 15)
	If $history Then
		Global $filecont = GUICtrlCreateCombo("", 5, 20, 310, 20)
	Else
		Global $filecont = GUICtrlCreateInput("", 5, 20, 310, 20)
	EndIf
	Local $filebut = GUICtrlCreateButton("...", 320, 20, 25, 20)

	; Directory controls
	;    
	GUICtrlCreateLabel(t('MAIN_DEST_DIR_LABEL'), 5, 45, -1, 15)
	If $history Then
		Global $dircont = GUICtrlCreateCombo("", 5, 60, 310, 20)
	Else
		Global $dircont = GUICtrlCreateInput("", 5, 60, 310, 20)
	EndIf
	Local $dirbut = GUICtrlCreateButton("...", 320, 60, 25, 20)

	; Buttons
	; 
	Global $ok = GUICtrlCreateButton(t('OK_BUT'), 80, 90, 80, 20)
	Local $cancel = GUICtrlCreateButton(t('CANCEL_BUT'), 190, 90, 80, 20)

	; Set properties
	;   
	GUICtrlSetBkColor($dropzone, $GUI_BKCOLOR_TRANSPARENT)
	GUICtrlSetState($dropzone, $GUI_DISABLE)
	GUICtrlSetState($dropzone, $GUI_DROPACCEPTED)
	GUICtrlSetState($filecont, $GUI_FOCUS)
	GUICtrlSetState($ok, $GUI_DEFBUTTON)
	If $file <> "" Then
		FilenameParse($file)
		If $history Then
			$filelist = '|' & $file & '|' & ReadHist('file')
			GUICtrlSetData($filecont, $filelist, $file)
			$dirlist = '|' & $initoutdir & '|' & ReadHist('directory')
			GUICtrlSetData($dircont, $dirlist, $initoutdir)
		Else
			GUICtrlSetData($filecont, $file)
			GUICtrlSetData($dircont, $initoutdir)
		EndIf
		GUICtrlSetState($dircont, $GUI_FOCUS)
	ElseIf $history Then
		GUICtrlSetData($filecont, ReadHist('file'))
		GUICtrlSetData($dircont, ReadHist('directory'))
	EndIf

	; Set events
	;   
	GUISetOnEvent($GUI_EVENT_DROPPED, "GUI_Drop")
	GUICtrlSetOnEvent($filebut, "GUI_File")
	GUICtrlSetOnEvent($dirbut, "GUI_Directory")
	GUICtrlSetOnEvent($prefsitem, "GUI_Prefs")
	GUICtrlSetOnEvent($webitem, "GUI_Website")
	GUICtrlSetOnEvent($aboutitem, "GUI_ABOUT")
	GUICtrlSetOnEvent($ok, "GUI_Ok")
	GUICtrlSetOnEvent($cancel, "GUI_Exit")
	GUICtrlSetOnEvent($quititem, "GUI_Exit")
	GUISetOnEvent($GUI_EVENT_CLOSE, "GUI_Exit")

	; Display GUI and wait for action
	;  GUI    
	GUISetState(@SW_SHOW)
EndFunc

; Return control width (for dynamic positioning)
;    (  )
Func GetPos($gui, $control, $offset = 0)
	$location = ControlGetPos($gui, '', $control)
	If @error Then
		SetError(1, '', 0)
	Else
		Return $location[0] + $location[2] + $offset
	EndIf
EndFunc

; Return number of times a character appears in a string
;       
Func CharCount($string, $char)
	Local $count = StringSplit($string, $char, 1)
	Return $count[0]
EndFunc

; Prompt user for file
;   
Func GUI_File()
	$file = FileOpenDialog(t('OPEN_FILE'), "", t('SELECT_FILE') & " (*.*)", 1)
	If NOT @error Then
		If $history Then
			$filelist = '|' & $file & '|' & ReadHist('file')
			GUICtrlSetData($filecont, $filelist, $file)
		Else
			GUICtrlSetData($filecont, $file)
		EndIf
		If GUICtrlRead($dircont) = "" Then
			FilenameParse($file)
			If $history Then
				$dirlist = '|' & $initoutdir & '|' & ReadHist('directory')
				GUICtrlSetData($dircont, $dirlist, $initoutdir)
			Else
				GUICtrlSetData($dircont, $initoutdir)
			EndIf
		EndIf
		GUICtrlSetState($ok, $GUI_FOCUS)
	EndIf
EndFunc

; Prompt user for directory
;   
Func GUI_Directory()
	If FileExists(GUICtrlRead($dircont)) Then
		$defdir = GUICtrlRead($dircont)
	ElseIf FileExists(GUICtrlRead($filecont)) Then
		$defdir = StringLeft(GUICtrlRead($filecont), StringInStr(GUICtrlRead($filecont), '\', 0, -1)-1)
	Else
		$defdir = ''
	EndIf
	$outdir = FileSelectFolder(t('EXTRACT_TO'), "", 3, $defdir)
	If NOT @error Then
		If $history Then
			$dirlist = '|' & $outdir & '|' & ReadHist('directory')
			GUICtrlSetData($dircont, $dirlist, $outdir)
		Else
			GUICtrlSetData($dircont, $outdir)
		EndIf
	EndIf
EndFunc

; Prompt user for debug file directory
;     -
Func GUI_Prefs_Debug()
	If FileExists(EnvParse(GUICtrlRead(($debugcont)))) Then
		$defdir = EnvParse(GUICtrlRead($debugcont))
	ElseIf FileExists(EnvParse($debugdir)) Then
		$defdir = EnvParse($debugdir)
	Else
		$defdir = @tempdir
	EndIf
	If StringRight($defdir, 1) == ':' Then $defdir &= '\'
	$tempdir = FileSelectFolder(t('WRITE_TO'), "", 3, $defdir)
	If NOT @error Then GUICtrlSetData($debugcont, $tempdir)
EndFunc

; Exit preferences GUI if Cancel clicked or window closed
;         Cancel    
Func GUI_Prefs_Exit()
	GUIDelete($guiprefs)
	If $prefsonly Then
		terminate("silent", '', '')
	EndIf
EndFunc

; Exit preferences GUI if OK clicked
;         OK
Func GUI_Prefs_OK()
	; universal preferences
	;  
	$redrawgui = False
	If FileExists(EnvParse(GUICtrlRead($debugcont))) AND StringInStr(FileGetAttrib(EnvParse(GUICtrlRead($debugcont))), 'D') Then
		$debugdir = GUICtrlRead($debugcont)
	Else
		MsgBox(48, $title, t('INVALID_DIR_SELECTED', CreateArray(GUICtrlRead($debugcont))))
		Return 
	EndIf
	If GUICtrlRead($historyopt) == $GUI_CHECKED Then
		If $history == 0 Then
			$history = 1
			$redrawgui = True
		EndIf
	Else
		If $history == 1 Then
			$history = 0
			If $globalprefs Then
				IniDelete($prefs, "File History")
				IniDelete($prefs, "Directory History")
			Else
				RegDelete($reg & '\File')
				RegDelete($reg & '\Directory')
			EndIf
			$redrawgui = True
		EndIf
	EndIf
	If GUICtrlRead($nodoswinopt) == $GUI_CHECKED Then
		$nodoswin = 1
	Else
		$nodoswin = 0
	EndIf
	If GUICtrlRead($mindoswinopt) == $GUI_CHECKED Then
		$mindoswin = 1
	Else
		$mindoswin = 0
	EndIf
	If $language <> GUICtrlRead($langselect) Then
		$language = GUICtrlRead($langselect)
		$redrawgui = True
	EndIf

	; format-specific preferences
	;   
	If GUICtrlRead($warnexecuteopt) == $GUI_CHECKED Then
		$warnexecute = 1
	Else
		$warnexecute = 0
	EndIf
	If GUICtrlRead($removedupeopt) == $GUI_CHECKED Then
		$removedupe = 1
	Else
		$removedupe = 0
	EndIf
	If GUICtrlRead($removetempopt) == $GUI_CHECKED Then
		$removetemp = 1
	Else
		$removetemp = 0
	EndIf
	If GUICtrlRead($appendextopt) == $GUI_CHECKED Then
		$appendext = 1
	Else
		$appendext = 0
	EndIf
	WritePrefs()
	GUIDelete($guiprefs)
	If $prefsonly Then
		$finishprefs = True
	ElseIf $redrawgui Then
		GUIDelete($guimain)
		CreateGUI()
	EndIf
EndFunc

; Set file to extract and target directory, Then exit
;         
Func GUI_Ok()
	$file = EnvParse(GUICtrlRead($filecont))
	If FileExists($file) Then
		If EnvParse(GUICtrlRead($dircont)) == "" Then
			$outdir = '/sub'
		Else
			$outdir = EnvParse(GUICtrlRead($dircont))
		EndIf
		GUIDelete($guimain)
		$finishgui = True
	Else
		If $file == '' Then
			$file = ''
		Else
			$file &= ' ' & t('DOES_NOT_EXIST')
		EndIf
		MsgBox(48, $title, t('INVALID_FILE_SELECTED', CreateArray($file)))
		Return 
	EndIf
EndFunc

; Process dropped files outside of file input box
;           
Func GUI_Drop()
	If FileExists(@GUI_DragFile) Then
		$file = @GUI_DragFile
		If $history Then
			$filelist = '|' & $file & '|' & ReadHist('file')
			GUICtrlSetData($filecont, $filelist, $file)
		Else
			GUICtrlSetData($filecont, $file)
		EndIf
		If GUICtrlRead($dircont) = "" Then
			FilenameParse($file)
			If $history Then
				$dirlist = '|' & $initoutdir & '|' & ReadHist('directory')
				GUICtrlSetData($dircont, $dirlist, $initoutdir)
			Else
				GUICtrlSetData($dircont, $initoutdir)
			EndIf
		EndIf
	EndIf
EndFunc

; Build and display preferences GUI
;     
Func GUI_Prefs()
	; Create GUI
	;  GUI
	If $prefsonly Then
		Global $guiprefs = GUICreate(t('PREFS_TITLE_LABEL'), 270, 280)
	Else
		Global $guiprefs = GUICreate(t('PREFS_TITLE_LABEL'), 270, 280, -1, -1, -1, -1, $guimain)
	EndIf

	; Universal prefs box
	;     
	GUICtrlCreateGroup(t('PREFS_UNIEXTRACT_OPTS_LABEL'), 5, 0, 260, 140)

	; History option
	; 
	Global $historyopt = GUICtrlCreateCheckbox(t('PREFS_HISTORY_LABEL'), 10, 15, -1, 20)

	; Console windows controls
	;   
	Global $nodoswinopt = GUICtrlCreateCheckbox(t('PREFS_NODOSWIN_LABEL'), 10, 35, -1, 20)

	; Minimize windows controls
	;   
	Global $mindoswinopt = GUICtrlCreateCheckbox(t('PREFS_MINDOSWIN_LABEL'), 10, 55, 215, 20)

	GUICtrlCreateUpdown(-1)
	GUICtrlSetLimit(-1, 30, 7)

	; Language controls
	;  
	Local $langlabel = GUICtrlCreateLabel(t('PREFS_LANG_LABEL'), 10, 78, -1, 15)
	Local $langselectpos = GetPos($guiprefs, $langlabel, -8)
	Global $langselect = GUICtrlCreateCombo("", $langselectpos, 75, 265 - $langselectpos - 4, 20 * CharCount($langlist, '|'), $CBS_DROPDOWNLIST)

	; Debug controls
	; -
	Local $debuglabel = GUICtrlCreateLabel(t('PREFS_DEBUG_LABEL'), 10, 100, -1, 20)
	;Local $debugcontpos = GetPos($guiprefs, $debuglabel, -5)
	Global $debugcont = GUICtrlCreateInput($debugdir, 10, 115, 220, 20)
	Local $debugbut = GUICtrlCreateButton("...", 235, 115, 25, 20)
	GUICtrlCreateGroup("", -99, -99, 1, 1)

	; Format-specific preferences
	;    
	GUICtrlCreateGroup(t('PREFS_FORMAT_OPTS_LABEL'), 5, 145, 260, 100)
	Global $warnexecuteopt = GUICtrlCreateCheckbox(t('PREFS_WARN_EXECUTE_LABEL'), 10, 160, -1, 20)
	Global $removedupeopt = GUICtrlCreateCheckbox(t('PREFS_REMOVE_DUPE_LABEL'), 10, 180, -1, 20)
	Global $removetempopt = GUICtrlCreateCheckbox(t('PREFS_REMOVE_TEMP_LABEL'), 10, 200, -1, 20)
	Global $appendextopt = GUICtrlCreateCheckbox(t('PREFS_APPEND_EXT_LABEL'), 10, 220, -1, 20)
	GUICtrlCreateGroup("", -99, -99, 1, 1)

	; Buttons
	; 
	Local $prefsok = GUICtrlCreateButton(t('OK_BUT'), 65, 255, 60, 20)
	Local $prefscancel = GUICtrlCreateButton(t('CANCEL_BUT'), 145, 255, 60, 20)

	; Set properties
	;   
	GUICtrlSetState($prefsok, $GUI_DEFBUTTON)
	If $history Then GUICtrlSetState($historyopt, $GUI_CHECKED)
	If $nodoswin Then GUICtrlSetState($nodoswinopt, $GUI_CHECKED)
	If $mindoswin Then GUICtrlSetState($mindoswinopt, $GUI_CHECKED)
	If $warnexecute Then GUICtrlSetState($warnexecuteopt, $GUI_CHECKED)
	If $removedupe Then GUICtrlSetState($removedupeopt, $GUI_CHECKED)
	If $removetemp Then GUICtrlSetState($removetempopt, $GUI_CHECKED)
	If $appendext Then GUICtrlSetState($appendextopt, $GUI_CHECKED)
	If StringInStr($langlist, $language, 0) Then
		GUICtrlSetData($langselect, $langlist, $language)
	Else
		GUICtrlSetData($langselect, $langlist, 'English')
	EndIf

	; Set events
	;   
	GUICtrlSetOnEvent($debugbut, "GUI_Prefs_Debug")
	GUICtrlSetOnEvent($prefsok, "GUI_Prefs_OK")
	GUICtrlSetOnEvent($prefscancel, "GUI_Prefs_Exit")
	GUISetOnEvent($GUI_EVENT_CLOSE, "GUI_Prefs_Exit")

	; Display GUI and wait for action
	;  GUI    
	GUISetState(@SW_SHOW)
EndFunc

; Launch Universal Extractor website if Help menu item selected
;   Universal Extractor
 Func GUI_Website()
	ShellExecute($website)
EndFunc

Func GUI_ABOUT()
	MsgBox(64, t('MENU_HELP_ABOUT_LABEL'), $name & " " & $version & @CRLF & "Copyright  2005-2010 Jared Breland" & @CRLF & "Mod by koros aka ya158")
EndFunc

; Exit if Cancel clicked or window closed
;         
Func GUI_Exit()
	terminate("silent", '', '')
EndFunc
