//AssView v0.1 beta (c)2007-2008 Sergey V. Bulba <vorobey@mail.khstu.ru>

unit AssViewU;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, AssLib;

type
  TForm1 = class(TForm)
    Button1: TButton;
    Edit1: TEdit;
    Memo1: TMemo;
    Label1: TLabel;
    Label2: TLabel;
    Memo2: TMemo;
    Memo3: TMemo;
    Label3: TLabel;
    Button2: TButton;
    SaveDialog1: TSaveDialog;
    GroupBox1: TGroupBox;
    CheckBox1: TCheckBox;
    CheckBox2: TCheckBox;
    CheckBox3: TCheckBox;
    Label4: TLabel;
    Label5: TLabel;
    Button3: TButton;
    Button4: TButton;
    procedure Button1Click(Sender: TObject);
    function CallSaveDialog(const Tp:string):boolean;
    procedure Button2Click(Sender: TObject);
    procedure Button3Click(Sender: TObject);
    procedure Button4Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;
  FTypes:TAssFTypes;
  Ass:TAssAsses;
  ftn,asn:integer;

implementation

{$R *.dfm}

procedure TForm1.Button1Click(Sender: TObject);
var
 kn,i:integer;
 lkname:longword;
 s:string;
 Keys:TAssArrayOfString;

begin
if RegQueryInfoKey(HKEY_CLASSES_ROOT,nil,nil,nil,@kn,@lkname,nil,nil,nil,nil,nil,nil) <> ERROR_SUCCESS then exit;

Button2.Enabled := False;
Button3.Enabled := False;
Button4.Enabled := False;

Memo1.Clear; Memo2.Clear; Memo3.Clear;

GetKeys(Keys,kn,lkname);

ftn := GetFTypes(AnsiUpperCase(Edit1.Text),FTypes,Keys);
if ftn = 0 then exit;
for i := 0 to ftn - 1 do
 begin
  s := FTypes[i].Name;
  Memo1.Lines.Add(s + ' ' + FTypes[i].Command);
  Memo3.Lines.Add(s + ' ' + FTypes[i].Descr + ' ' + FTypes[i].Icon);
 end;

asn := GetAsses(Ass,FTypes,ftn,Keys);
for i := 0 to asn - 1 do
 Memo2.Lines.Add(Ass[i].Name + ' ' + FTypes[Ass[i].Tp].Name);

Button2.Enabled := True;
Button3.Enabled := True;
Button4.Enabled := True;
end;

function TForm1.CallSaveDialog(const Tp:string):boolean;
begin
SaveDialog1.DefaultExt := Tp;
SaveDialog1.Filter := Tp + '-|*.' + Tp;
Result := SaveDialog1.Execute;
if Result then SaveDialog1.InitialDir := ExtractFilePath(SaveDialog1.FileName);
end;

procedure TForm1.Button2Click(Sender: TObject);
begin
if CallSaveDialog('CMD') then
 SaveCMD(SaveDialog1.FileName,Ass,asn,FTypes,ftn,CheckBox1.Checked,CheckBox2.Checked,CheckBox3.Checked);
end;


procedure TForm1.Button3Click(Sender: TObject);
begin
if CallSaveDialog('REG') then
 SaveREG(SaveDialog1.FileName,Ass,asn,FTypes,ftn);
end;

procedure TForm1.Button4Click(Sender: TObject);
begin
if CallSaveDialog('INF') then
 SaveINF(SaveDialog1.FileName,Ass,asn,FTypes,ftn,CheckBox2.Checked,CheckBox3.Checked);
end;

end.
