//Part of AssTools (c)2007-2008 Sergey V. Bulba <vorobey@mail.khstu.ru>

unit AssLib;

interface

uses
  Windows, SysUtils;

type
 TAssArrayOfString = array of string;
 TAssFTypes = array of record
   Name,Command,Descr,Icon:string;
  end;
 TAssAsses = array of record
   Name:string;
   Tp:integer;
  end;

procedure GetKeys(var Keys:TAssArrayOfString;kn:integer;lkname:longword);
function GetFTypes(const Prg:string;var FTypes:TAssFTypes;const Keys:TAssArrayOfString):integer;
function GetAsses(var Ass:TAssAsses;const FTypes:TAssFTypes;ftn:integer;const Keys:TAssArrayOfString):integer;
procedure SaveCMD(const FN:string;const Ass:TAssAsses;asn:integer;const FTypes:TAssFTypes;ftn:integer;v0,v1,v2:boolean);
procedure SaveREG(const FN:string;const Ass:TAssAsses;asn:integer;const FTypes:TAssFTypes;ftn:integer);
procedure SaveINF(const FN:string;const Ass:TAssAsses;asn:integer;const FTypes:TAssFTypes;ftn:integer;v1,v2:boolean);

implementation

type
 tassvars = array[0..2]of string;

const
 varscmd:tassvars =
 ('%programfiles%','%systemroot%','%systemdrive%');
const
 varsinf:tassvars =
 ('','%10%','%24%');

function ExpandString(s:string):string;
var
 D2:string;
 i,l:integer;
begin
Result := '';
if Length(s) = 0 then exit;
i := MAX_PATH + 1;
repeat
 l := i;
 SetLength(D2,l);
 i := ExpandEnvironmentStrings(PChar(s),PChar(D2),l);
 if i = 0 then exit;
until i <= l;
Result := PChar(D2);
end;

function GetKey(Key:string;var Val:string):boolean;
var
 DataStr:string;
 i,j,size:integer;
 subKeyHnd1:HKey;
begin
Result := False;
i := RegOpenKeyEx(HKEY_CLASSES_ROOT,PChar(Key),0,KEY_READ,subKeyHnd1);
if i <> ERROR_SUCCESS then exit;
try
 i := RegQueryValueEx(subKeyHnd1,nil,nil,@j,nil,@size);
 if (i <> ERROR_SUCCESS) or (size < 2) then exit;
 if (j = REG_SZ) or (j = REG_EXPAND_SZ) then
  begin
   SetLength(DataStr,size);
   i := RegQueryValueEx(subKeyHnd1,nil,nil,@j,PByte(DataStr),@size);
   if i <> ERROR_SUCCESS then exit;
   if j = REG_EXPAND_SZ then
    DataStr := ExpandString(DataStr);
   DataStr := PChar(DataStr);
   if DataStr = '' then exit;
   Val := DataStr;
   Result := True;
  end
finally
 RegCloseKey(subKeyHnd1);
end;
end;

procedure GetKeys(var Keys:TAssArrayOfString;kn:integer;lkname:longword);
var
 KName:string;
 i:integer;
 l:longword;
 pft:TFileTime;
begin
SetLength(KName,lkname); inc(lkname);
SetLength(Keys,kn);
i := kn;
repeat
 dec(i);
 if i < 0 then break;
 Keys[i] := ''; l := lkname;
 if RegEnumKeyEx(HKEY_CLASSES_ROOT,i,PChar(KName),l,nil,nil,nil,@pft) <> ERROR_SUCCESS then continue;
 Keys[i] := PChar(KName);
until False;
end;

function GetFTypes(const Prg:string;var FTypes:TAssFTypes;const Keys:TAssArrayOfString):integer;
var
 kn,i:integer;
 s,s1,s2,s3:string;
 FullPath:boolean;

 function CheckRegPath(FType,Prg:string;var Val,Des,Ico:string):boolean;
 var
  i:integer;
 begin
 Result := False;
 if not GetKey(FType + '\shell\open\command',Val) then exit;
 i := Pos(Prg,AnsiUpperCase(Val));
 if Val[1] = '"' then dec(i);
 Result := (FullPath and (i = 1)) or (not FullPath and (i > 0));
 if Result then
  begin
   Des := ''; GetKey(FType,Des);
   Ico := ''; GetKey(FType + '\DefaultIcon',Ico);
  end;
 end;

begin
kn := Length(Keys);
SetLength(FTypes,kn);
Result := 0;
FullPath := True;
repeat
for i := 0 to kn - 1 do
 begin
  s := Keys[i];
  if (s <> '') and (s[1] <> '.') then
   begin
    if CheckRegPath(s,Prg,s1,s2,s3) then
     begin
      FTypes[Result].Name := s;
      FTypes[Result].Command := s1;
      FTypes[Result].Descr := s2;
      FTypes[Result].Icon := s3;
      inc(Result);
     end;
   end;
 end;
FullPath := not FullPath;
until (Result > 0) or FullPath;
end;

function GetAsses(var Ass:TAssAsses;const FTypes:TAssFTypes;ftn:integer;const Keys:TAssArrayOfString):integer;
var
 kn,i,j:integer;
 s,s1:string;

 function CheckFType(const ft:string;var fti:integer):boolean;
 var
  i:integer;
 begin
  Result := False;
  for i := 0 to ftn - 1 do
   if FTypes[i].Name = ft then
    begin
     fti := i;
     Result := True;
     exit;
    end;
 end;

begin
kn := Length(Keys);
SetLength(Ass,kn);
Result := 0;
for i := 0 to kn - 1 do
 begin
  s := Keys[i];
  if (s <> '') and (s[1] = '.') then
   begin
    if GetKey(s,s1) and CheckFType(s1,j) then
     begin
      Ass[Result].Name := s;
      Ass[Result].Tp := j;
      inc(Result);
     end;
   end;
 end;
end;

function CheckVars(s:string;v0,v1,v2:boolean;const vars,varsv:tassvars):string;
var
 i:integer;

  function SetVar(Yes:boolean;vi:integer;s:string;var Res:string;var i:integer):boolean;
  begin
  Result := False;
  if not Yes then exit;
  if Length(s) - i + 1 < Length(varsv[vi]) then exit;
  if CompareStr(varsv[vi],AnsiUpperCase(Copy(s,i,Length(varsv[vi])))) = 0 then
   begin
    Result := True;
    Res := Res + vars[vi];
    inc(i,Length(varsv[vi]));
   end;
  end;

begin
Result := '';

i := 1;
while i <= Length(s) do
begin
 if SetVar(v0,0,s,Result,i) then continue;
 if SetVar(v1,1,s,Result,i) then continue;
 if SetVar(v2,2,s,Result,i) then continue;
 Result := Result + s[i];
 inc(i);
end;
end;

procedure ExpandVars(var varsv:tassvars);
var
 i:integer;
begin
for i := 0 to 2 do
 varsv[i] := AnsiUpperCase(ExpandString(varscmd[i]));
end;

procedure SaveCMD(const FN:string;const Ass:TAssAsses;asn:integer;const FTypes:TAssFTypes;ftn:integer;v0,v1,v2:boolean);
var
 f:textfile;
 i:integer;
 s:string;
 varsv:tassvars;

 function CheckProcent(s:string):string;
 var
  i:integer;
 begin
 Result := '';
 for i := 1 to Length(s) do
  begin
   if s[i] = '%' then Result := Result + '%';
   Result := Result + s[i];
  end;
 end;

 function AnsiToOemF(s:string):string;
 begin
 SetLength(Result,Length(s));
 if Length(Result) = 0 then exit;
 AnsiToOem(PChar(s),PChar(Result));
 end;

begin

AssignFile(f,FN);
Rewrite(f);

for i := 0 to asn - 1 do
 Writeln(f,'assoc ',AnsiToOemF(Ass[i].Name),'=',AnsiToOemF(FTypes[Ass[i].Tp].Name));

ExpandVars(varsv);

for i := 0 to ftn - 1 do
 begin
  s := AnsiToOemF(FTypes[i].Name);
  Writeln(f,'ftype ',s,'=',AnsiToOemF(CheckVars(CheckProcent(FTypes[i].Command),v0,v1,v2,varscmd,varsv)));
  Writeln(f,'reg add "HKCR\',s,'" /ve /d "',AnsiToOemF(FTypes[i].Descr),'" /f');
  Writeln(f,'reg add "HKCR\',s,'\DefaultIcon" /ve /d "',AnsiToOemF(CheckVars(CheckProcent(FTypes[i].Icon),v0,v1,v2,varscmd,varsv)),'" /f');
 end;

CloseFile(f);
end;

procedure SaveREG(const FN:string;const Ass:TAssAsses;asn:integer;const FTypes:TAssFTypes;ftn:integer);
var
 f:textfile;
 i:integer;
 s:string;

 function CheckSlashQuote(s:string):string;
 var
  i:integer;
 begin
 Result := '';
 for i := 1 to Length(s) do
  begin
   if s[i] in ['"','\'] then Result := Result + '\';
   Result := Result + s[i];
  end;
 end;

begin

AssignFile(f,FN);
Rewrite(f);
Writeln(f,'REGEDIT4');

for i := 0 to asn - 1 do
 begin
  Writeln(f);
  Writeln(f,'[HKEY_CLASSES_ROOT\',Ass[i].Name,']');
  Writeln(f,'@="',CheckSlashQuote(FTypes[Ass[i].Tp].Name),'"');
 end;

for i := 0 to ftn - 1 do
 begin
  s := FTypes[i].Name;
  Writeln(f);
  Writeln(f,'[HKEY_CLASSES_ROOT\',s,']');
  Writeln(f,'@="',CheckSlashQuote(FTypes[i].Descr),'"');
  Writeln(f);
  Writeln(f,'[HKEY_CLASSES_ROOT\',s,'\DefaultIcon]');
  Writeln(f,'@="',CheckSlashQuote(FTypes[i].Icon),'"');
  Writeln(f);
  Writeln(f,'[HKEY_CLASSES_ROOT\',s,'\shell]');
  Writeln(f);
  Writeln(f,'[HKEY_CLASSES_ROOT\',s,'\shell\open]');
  Writeln(f);
  Writeln(f,'[HKEY_CLASSES_ROOT\',s,'\shell\open\command]');
  Writeln(f,'@="',CheckSlashQuote(FTypes[i].Command),'"');
 end;

CloseFile(f);
end;

procedure SaveINF(const FN:string;const Ass:TAssAsses;asn:integer;const FTypes:TAssFTypes;ftn:integer;v1,v2:boolean);
var
 f:file;
 i:integer;
 s:string;
 varsv:tassvars;
const
 um:word = $FEFF;

 function CheckProcentQuote(s:string):string;
 var
  i:integer;
 begin
 Result := '';
 for i := 1 to Length(s) do
  begin
   case s[i] of
   '%': Result := Result + '%';
   '"': Result := Result + '"';
   end;
   Result := Result + s[i];
  end;
 end;

 procedure WritelnW(const s:string);
 var
  ws:WideString;
 begin
  ws := s + #13#10;
  BlockWrite(f,ws[1],Length(ws)*2);
 end;

begin

AssignFile(f,FN);
Rewrite(f,1);
BlockWrite(f,um,2);//Utf-16

WritelnW('[version]');
WritelnW('signature="$CHICAGO$"');
WritelnW('ClassGUID={00000000-0000-0000-0000-000000000000}');
WritelnW('');
WritelnW('[DefaultInstall]');
WritelnW('AddReg=AssReg');
WritelnW('');
WritelnW('[AssReg]');

for i := 0 to asn - 1 do
 WritelnW('HKCR,"' + Ass[i].Name + '",,,"' + FTypes[Ass[i].Tp].Name + '"');

ExpandVars(varsv);

for i := 0 to ftn - 1 do
 begin
  s := FTypes[i].Name;
  WritelnW('HKCR,"' + s + '",,,"' + CheckProcentQuote(FTypes[i].Descr) + '"');
  WritelnW('HKCR,"' + s + '\shell\open\command",,,"' + CheckVars(CheckProcentQuote(FTypes[i].Command),False,v1,v2,varsinf,varsv) + '"');
  WritelnW('HKCR,"' + s + '\DefaultIcon",,,"' + CheckVars(CheckProcentQuote(FTypes[i].Icon),False,v1,v2,varsinf,varsv) + '"');
 end;

CloseFile(f);
end;

end.
