unit My;

interface

type
  MyType = Boolean;

  MyFile = object
    F: file of MyType;

    constructor Create(const FileName: String; const NewFile: Boolean);
    destructor Destroy;

    function ReWrite: Boolean;
    function Reset: Boolean;

    function ReadAt(const Position: Integer; var WhatToRead: MyType): Boolean;
    function WriteAt(const Position: Integer; WhatToPut: MyType): Boolean;
    function RandomPut(const N: Integer): Boolean;

    function FindFirst(const Proto: MyType): Integer;
    function FindAll(const Proto: MyType; var Result: array of Integer): Boolean;
  end;

implementation

constructor MyFile.Create(const FileName: String; const NewFile: Boolean);
{  ꥪ  뢠 易 䠩.

ࠬ:
  FileName      [in]  ন  䠩,  㤥 易  ꥪ⮬
  NewFile       [in]    䠩 (True)   ࠭ ᮧ (False) ? 

頥:
  < 祣  頥 >
 
} 
begin
  System.Assign(F, FileName);
  if NewFile then
    ReWrite
  else
    Reset;
end;

destructor MyFile.Destroy;
{ ⮦ ꥪ  뢠 易 䠩.

ࠬ:
  <  ࠬ஢ >

頥:
  < 祣  頥 >
} 
begin
  System.Close(F);
end;

function MyFile.ReWrite: Boolean;
{  ⠭ 㭪 ReWrite   ࠡ⪨ ᪫⥫쭮 樨.

ࠬ:
  <  ࠬ஢ >

頥:
  False =  뫠 ࢠ - 訡
  True  =  ᯥ譮 믮
}   
begin
{$I-}
  System.ReWrite(F);
  ReWrite := (IOResult = 0);
{$I+}
end;

function MyFile.Reset: Boolean;
{  ⠭ 㭪 Reset   ࠡ⪨ ᪫⥫쭮 樨.

ࠬ:
  <  ࠬ஢ >

頥:
  False =  뫠 ࢠ - 訡
  True  =  ᯥ譮 믮
}   
begin
{$I-}
  System.Reset(F);
  Reset := (IOResult = 0);
{$I+}
end;

function MyFile.ReadAt(const Position: Integer; var WhatToRead: MyType): Boolean;
{ ⠥ , ᯮ  樨 Position  易 䠩.

ࠬ:
  Position      [in]  뢠   ன 㤥 ந ⥭
  WhatToRead    [out] ন ⥭ 祭

頥:
  False =  뫠 ࢠ - 訡
  True  =  ᯥ譮 믮
}  
begin
{$I-}
  System.Seek(F, Position);
  if IOResult <> 0 then begin
    ReadAt := False;
    Exit;
  end;
  System.Read(F, WhatToRead);
  ReadAt := (IOResult = 0);
{$I+}
end;

function MyFile.WriteAt(const Position: Integer; WhatToPut: MyType): Boolean;
{ 뢠    Position  易 䠩.

ࠬ:
  Position      [in]  뢠 ,   㤥 ந 
  WhatToPut     [in]  ন 뢠 稭

頥:
  False =  뫠 ࢠ - 訡
  True  =  ᯥ譮 믮
} 
begin
{$I-}
  System.Seek(F, Position);
  if IOResult <> 0 then begin
    WriteAt := False;
    Exit;
  end;
  System.Write(F, WhatToPut);
  WriteAt := (IOResult = 0);
{$I+}
end;

function MyFile.RandomPut(const N: Integer): Boolean;
{  䠩 砩 ଠ樥.  㤥 १ᠭ!
- ᥩ । ࠬ஬ N.

ࠬ:
  N             [in]  뢠 - 뢠 

頥:
  False =  뫠 ࢠ - 訡
  True  =  ᯥ譮 믮
} 
var
  i: Integer;
begin
  ReWrite;
  System.Randomize;
  RandomPut := False;
  for i := 1 to n - 1 do begin
    if not WriteAt(i, Random(2) = 1) then Exit;
  end;
  RandomPut := Reset;
end;

function MyFile.FindFirst(const Proto: MyType): Integer;
{ 室 ࢮ ᮢ  䠩. Proto = ⨯, .. ,  .

ࠬ:
  Proto         [in]  뢠,   (True  False)

頥:
  -1 =  뫠 ࢠ - 訡
   0 = ᪮ ⨯   
  >0 =  ᯥ譮 믮, 頥 १ ᮤন  ࢮ ᮢ
}
var
  i: Integer;
  temp: MyType;
begin
  if not Reset then begin
    FindFirst := -1;
    Exit;
  end;
  i := 1;
  while not Eof(F) do begin
{$I-}
    System.Read(F, temp);
    if IOResult <> 0 then begin
      FindFirst := -1;
      Exit;
    end;
{$I+}
    if temp = Proto then begin
      FindFirst := i;
      Exit;
    end;
    inc(i);
  end;
  FindFirst := 0;
end;

function MyFile.FindAll(const Proto: MyType; var Result: array of Integer): Boolean;
{ 室  ᮢ Proto  易 䠩.  ࠭ 
᪮ ᨢ result. :    
 .  ᮧ ᨢ , ࠢ ᨬ쭮
 ᥩ (. ਬ).

ࠬ:
  Proto         [in]  뢠,   (True  False)
  Result        [out] ࠭  ᥡ  ᮢ

頥:
  False =  뫠 ࢠ - 訡
  True  =  ᯥ譮 믮
}
var
  i, k: Integer;
  temp: MyType;
begin
  if not Reset then begin
    FindAll := False;
    Exit;
  end;
  i := 1;
  k := 0;
  FindAll := True;
  while not Eof(F) do begin
{$I-}
    System.Read(F, temp);
    if IOResult <> 0 then begin
      FindAll := False;
      Exit;
    end;
{$I+}
    if temp = Proto then begin
      Result[k] := i;
      inc(k);
    end;
    inc(i);
  end;
end;

end.