@echo off
setlocal enabledelayedexpansion
Title Kaspersky Products Universal Constructor v.2.9

Set product=kis
Set series=8
Set addon=%product%%series%
Set Name=%product%%series%
Set Places=local
Set SrcDir=sources\%addon%
Set SfxFile=addons\Z_%addon%\Files\ForceCopy\SVCPACK\%addon%.exe
Set UpdDir=%CD%\upd_%Places%\%Name%
Set UpdDirInet=%CD%\upd_inet\%addon%
Set UpdDirLocal=%CD%\upd_local\%addon%
Set script_updfile=%UpdDir%\index\u0607g.xml
Set "kasper_updfile=%AllUsersProfile%\Application Data\Kaspersky Lab\AVP%series%\Update distribution\index\u0607g.xml"
If Defined ProgramFiles(x86) (Set xOS=x64) else (Set xOS=x32)
Set "ArcExe=%CD%\bin\%xOS%\7z.exe"
rem DictSize           (RAM):
rem 16, 24, 32, 48, 64, 96, 128, 192, 256
Set DictSize=

For /F %%i in ('echo.%* ^| find /i /c "/?"') Do if %%i==1 Set Help=1
For /F %%i in ('echo.%* ^| find /i /c "-?"') Do if %%i==1 Set Help=1
For /F %%i in ('echo.%* ^| find /i /c "/h"') Do if %%i==1 Set Help=1
For /F %%i in ('echo.%* ^| find /i /c "-h"') Do if %%i==1 Set Help=1

If "%Help%"=="1" (
	If not exist "%CD%\help\help_ru.chm" echo File "%CD%\help\help_ru.chm" not found & pause & exit
	start "" hh mk:@MSITStore:%CD%\help\help_ru.chm::/html\%addon%.htm & exit
)

if not exist "%CD%.\%SrcDir%\%addon%.msi" wscript "%CD%\bin\err_msi.vbs" & exit
echo Deleting old files...
if exist "%CD%\%SrcDir%\%addon%" RD /S /Q "%CD%\%SrcDir%\%addon%"

For /F %%i in ('echo.%* ^| find /i /c "/fullinet"') Do if %%i==1 GoTo :fullinet
For /F %%i in ('echo.%* ^| find /i /c "-fullinet"') Do if %%i==1 GoTo :fullinet
For /F %%i in ('echo.%* ^| find /i /c "/fulllocal"') Do if %%i==1 GoTo :fulllocal
For /F %%i in ('echo.%* ^| find /i /c "-fulllocal"') Do if %%i==1 GoTo :fulllocal

goto :arc

:fullinet
if not exist "%CD%\%addon%_make_updates_inet.cmd" echo CRITICAL ERROR: file "%addon%_make_updates_inet.cmd" not found... & GoTo :exit
Setlocal
call %addon%_make_updates_inet.cmd /noarc
endlocal
echo Copying inet updates files...
If not exist "%CD%\%SrcDir%\%addon%" MD "%CD%\%SrcDir%\%addon%"
xcopy "%UpdDirInet%" "%CD%\%SrcDir%\%addon%" /Q /Y /E /O /X > nul
goto :arc

:fulllocal
If not exist "%CD%\%SrcDir%\%addon%" MD "%CD%\%SrcDir%\%addon%"
If exist "%kasper_updfile%" (
	Set "UpdDirLocal=%AllUsersProfile%\Application Data\Kaspersky Lab\AVP%series%\Update distribution"
	Set "Places=Kaspersky Lab"
	echo Copying files from !Places! update folder. Please, wait...
	xcopy "!UpdDirLocal!\*.*" "%CD%\%SrcDir%\%addon%\" /Q /Y /E /O /X > nul
	GoTo :arc
) else (
	echo File "%kasper_updfile%" not found...
	If not exist "%script_updfile%" (
		echo File "%script_updfile%" not found...
		wscript "%CD%\bin\err_upd.vbs"
	) else (
		echo Copying files from %Places% update folder. Please, wait...
		xcopy "%UpdDirLocal%" "%CD%\%SrcDir%\%addon%" /Q /Y /E /O /X > nul
	)
)

:arc
If Defined DictSize Goto :archiving

echo Getting OS Settings...
For /F "skip=2 tokens=1-3 usebackq" %%i In (`"%ArcExe%" b -mmt2 -md22`) Do If "%%j"=="size:" Set Ram=%%k& Set /a dictM=%%k/12
For %%a In (16 24 32 48 64 96 128 192 256 384 512 768 1024) Do If %%a LEQ %dictM% Set DictSize=%%a
For /F %%i in ('echo.%* ^| find /i /c "/d32"') Do if %%i==1 Set DictSize=32
For /F %%i in ('echo.%* ^| find /i /c "-d32"') Do if %%i==1 Set DictSize=32
For /F %%i in ('echo.%* ^| find /i /c "/d64"') Do if %%i==1 Set DictSize=64
For /F %%i in ('echo.%* ^| find /i /c "-d64"') Do if %%i==1 Set DictSize=64
For /F %%i in ('echo.%* ^| find /i /c "/d128"') Do if %%i==1 Set DictSize=128
For /F %%i in ('echo.%* ^| find /i /c "-d128"') Do if %%i==1 Set DictSize=128

:archiving
Set "ArcSwitches=-ssw -mmt2 -m0=BCJ2 -m1=LZMA2:d%DictSize%m:fb128 -m2=LZMA2:d19:fb273 -m3=LZMA2:d19:fb273 -mb0:1 -mb0s1:2 -mb0s2:3"
echo Creating %addon% archive with DictSize=%DictSize%. Please, wait...
"%ArcExe%" a %ArcSwitches% "%CD%\temp\%addon%.7z" "%CD%\%SrcDir%\*" > nul
Set DictSize=
ping -n 1 -w 1 127.0.0.1 > nul

if not exist "%CD%\temp\%addon%.7z" (
	wscript "%CD%\bin\err_arc.vbs" & exit
) else (
	echo Creating addon...
	If not exist "%CD%\addons\Z_%addon%\Files\ForceCopy\SVCPACK" md "%CD%\addons\Z_%addon%\Files\ForceCopy\SVCPACK"
	copy /b "%CD%\bin\%addon%.bin" + "%CD%\temp\%addon%.7z" "%CD%\%SfxFile%" > nul
	ping -n 1 -w 1 127.0.0.1 > nul
	del /q "%CD%\temp\%addon%.7z"
)

if exist "%CD%\%SfxFile%" (wscript "%CD%\bin\finish.vbs") else (wscript "%CD%\bin\err_unkn.vbs")
:exit
echo.
pause
exit
