@echo off
Title Kaspersky Products Universal Constructor v.2.9

Set product=kav
Set series=9
Set Places=local
Set Name=%product%%series%
Set UpdDir=%CD%\upd_%Places%\%Name%
Set UpdFile=addons\Z_%Name%\Files\ForceCopy\SVCPACK\%Name%_upd.exe
Set script_updfile=%UpdDir%\index\u0607g.xml
Set kasper_updfile="%AllUsersProfile%\Application Data\Kaspersky Lab\AVP%series%\Update distribution\index\u0607g.xml"
If Defined ProgramFiles(x86) (Set xOS=x64) else (Set xOS=x32)
Set "ArcExe=%CD%\bin\%xOS%\7z.exe"
rem DictSize           (RAM):
rem 16, 24, 32, 48, 64, 96, 128, 192, 256
Set DictSize=

For /F %%i in ('echo.%* ^| find /i /c "/?"') Do if %%i==1 Set Help=1
For /F %%i in ('echo.%* ^| find /i /c "-?"') Do if %%i==1 Set Help=1
For /F %%i in ('echo.%* ^| find /i /c "/h"') Do if %%i==1 Set Help=1
For /F %%i in ('echo.%* ^| find /i /c "-h"') Do if %%i==1 Set Help=1

If "%Help%"=="1" (
	If not exist "%CD%\help\help_ru.chm" echo File "%CD%\help\help_ru.chm" not found & pause & exit
	start "" hh mk:@MSITStore:%CD%\help\help_ru.chm::/html\%Name%_make_updates_%Places%.htm & exit
)

For /F %%i in ('echo.%* ^| find /i /c "/arc"') Do if %%i==1 GoTo :arc
For /F %%i in ('echo.%* ^| find /i /c "-arc"') Do if %%i==1 GoTo :arc

echo Searching %Name% updates from local folders...

If exist %kasper_updfile% (
	Set "UpdDir=%AllUsersProfile%\Application Data\Kaspersky Lab\AVP%series%\Update distribution"
	Set "Places=Kaspersky Lab"
	GoTo :arc
) else (
	echo File "%kasper_updfile%" not found...
	If not exist "%script_updfile%" (
		echo File "%script_updfile%" not found... Process aborted...
		wscript "%CD%\bin\err_loc.vbs"
		exit
	)
)

:arc
If Defined DictSize Goto :archiving

echo Getting OS Settings...
For /F "skip=2 tokens=1-3 usebackq" %%i In (`"%ArcExe%" b -mmt2 -md22`) Do If "%%j"=="size:" Set Ram=%%k& Set /a dictM=%%k/12
For %%a In (16 24 32 48 64 96 128 192 256 384 512 768 1024) Do If %%a LEQ %dictM% Set DictSize=%%a
For /F %%i in ('echo.%* ^| find /i /c "/d32"') Do if %%i==1 Set DictSize=32
For /F %%i in ('echo.%* ^| find /i /c "-d32"') Do if %%i==1 Set DictSize=32
For /F %%i in ('echo.%* ^| find /i /c "/d64"') Do if %%i==1 Set DictSize=64
For /F %%i in ('echo.%* ^| find /i /c "-d64"') Do if %%i==1 Set DictSize=64
For /F %%i in ('echo.%* ^| find /i /c "/d128"') Do if %%i==1 Set DictSize=128
For /F %%i in ('echo.%* ^| find /i /c "-d128"') Do if %%i==1 Set DictSize=128

:archiving
Set "ArcSwitches=-ssw -mmt2 -m0=BCJ2 -m1=LZMA2:d%DictSize%m:fb128 -m2=LZMA2:d19:fb273 -m3=LZMA2:d19:fb273 -mb0:1 -mb0s1:2 -mb0s2:3"
echo Compressing files with DictSize=%DictSize% from %Places% update folder... Please, wait...
"%ArcExe%" a %ArcSwitches% "%CD%\temp\%Name%_upd.7z" "%UpdDir%\*" > nul
if not exist "%CD%\temp\%Name%_upd.7z" (
	wscript "%CD%\bin\err_arc.vbs" & exit
) else (
	echo Making Update file...
	copy /b "%CD%\bin\%Name%_upd.bin" + "%CD%\temp\%Name%_upd.7z" "%CD%\%UpdFile%" > nul
	ping -n 1 -w 1 127.0.0.1 > nul
	del /q "%CD%\temp\%Name%_upd.7z"
)
if exist "%UpdFile%" (wscript "%CD%\bin\finish.vbs") else (wscript "%CD%\bin\err_unkn.vbs")
echo.
pause
exit
