@echo off
Title Kaspersky Products Universal Constructor v.2.9

Set Name=kav9
Set Places=inet
Set UpdDir=upd_%Places%\%Name%
Set UpdFile=addons\Z_%Name%\Files\ForceCopy\SVCPACK\%Name%_upd.exe
Set UpdLog=iupdater.txt
If Defined ProgramFiles(x86) (Set xOS=x64) else (Set xOS=x32)
Set "ArcExe=%CD%\bin\%xOS%\7z.exe"
rem DictSize           (RAM):
rem 16, 24, 32, 48, 64, 96, 128, 192, 256
Set DictSize=

For /F %%i in ('echo.%* ^| find /i /c "/?"') Do if %%i==1 Set Help=1
For /F %%i in ('echo.%* ^| find /i /c "-?"') Do if %%i==1 Set Help=1
For /F %%i in ('echo.%* ^| find /i /c "/h"') Do if %%i==1 Set Help=1
For /F %%i in ('echo.%* ^| find /i /c "-h"') Do if %%i==1 Set Help=1

If "%Help%"=="1" (
	If not exist "%CD%\help\help_ru.chm" echo File "%CD%\help\help_ru.chm" not found & pause & exit
	start "" hh mk:@MSITStore:%CD%\help\help_ru.chm::/html\%Name%_make_updates_%Places%.htm & exit
)

For /F %%i in ('echo.%* ^| find /i /c "/arc"') Do if %%i==1 GoTo :arc
For /F %%i in ('echo.%* ^| find /i /c "-arc"') Do if %%i==1 GoTo :arc

if exist "%CD%\%UpdLog%" del /q /f "%CD%\%UpdLog%" > nul
if exist "%CD%\%UpdLog%" wscript "%CD%\bin\err_unkn.vbs" & exit

echo Downloading Updates %Name% from Internet...
echo If Script first run, please, wait 15-20 min or more...
Start "Downloading %Name% updates files" /Wait "%CD%\bin\updater.exe" -u -c -o "%CD%\bin\upd_%Name%.ini" -rpt "%CD%\bin\upd_%Name%.log"
del /q "..\rollbackForRetranslation.ini" > nul
if not exist "%CD%\%UpdLog%" wscript "%CD%\bin\err_unkn.vbs" & exit
Set ExitCode=""
for /f "tokens=* usebackq" %%i in (`findstr /B /C:"10" iupdater.txt`) do Set ExitCode=%%i
for /f "tokens=* usebackq" %%i in (`findstr /B /C:"19" iupdater.txt`) do Set ExitCode=%%i
for /f "tokens=* usebackq" %%i in (`findstr /B /C:"28" iupdater.txt`) do Set ExitCode=%%i
for /f "tokens=* usebackq" %%i in (`findstr /B /C:"35" iupdater.txt`) do Set ExitCode=%%i
for /f "tokens=* usebackq" %%i in (`findstr /B /C:"38" iupdater.txt`) do Set ExitCode=%%i
echo.
if "%ExitCode%"=="10" echo Download ExitCode 10: Bases don't need update...
if "%ExitCode%"=="19" echo Download ExitCode 19: Update process is terminated by user or system... & goto :exit
if "%ExitCode%"=="28" echo Download ExitCode 28: Download error, check connect to Internet... & goto :exit
if "%ExitCode%"=="35" echo Download ExitCode 35: Update process successful
if "%ExitCode%"=="38" echo Download ExitCode 38: Error connect to Kaspersky update server... & goto :exit
echo.

For /F %%i in ('echo.%* ^| find /i /c "/log"') Do if %%i==1 notepad "%CD%\%UpdLog%"
For /F %%i in ('echo.%* ^| find /i /c "-log"') Do if %%i==1 notepad "%CD%\%UpdLog%"
For /F %%i in ('echo.%* ^| find /i /c "/noarc"') Do if %%i==1 GoTo :eof
For /F %%i in ('echo.%* ^| find /i /c "-noarc"') Do if %%i==1 GoTo :eof

:arc
If Defined DictSize Goto :archiving

echo Getting OS Settings...
For /F "skip=2 tokens=1-3 usebackq" %%i In (`"%ArcExe%" b -mmt2 -md22`) Do If "%%j"=="size:" Set Ram=%%k& Set /a dictM=%%k/12
For %%a In (16 24 32 48 64 96 128 192 256 384 512 768 1024) Do If %%a LEQ %dictM% Set DictSize=%%a
For /F %%i in ('echo.%* ^| find /i /c "/d32"') Do if %%i==1 Set DictSize=32
For /F %%i in ('echo.%* ^| find /i /c "-d32"') Do if %%i==1 Set DictSize=32
For /F %%i in ('echo.%* ^| find /i /c "/d64"') Do if %%i==1 Set DictSize=64
For /F %%i in ('echo.%* ^| find /i /c "-d64"') Do if %%i==1 Set DictSize=64
For /F %%i in ('echo.%* ^| find /i /c "/d128"') Do if %%i==1 Set DictSize=128
For /F %%i in ('echo.%* ^| find /i /c "-d128"') Do if %%i==1 Set DictSize=128

:archiving
Set "ArcSwitches=-ssw -mmt2 -m0=BCJ2 -m1=LZMA2:d%DictSize%m:fb128 -m2=LZMA2:d19:fb273 -m3=LZMA2:d19:fb273 -mb0:1 -mb0s1:2 -mb0s2:3"
echo Compressing %Name% files with DictSize=%DictSize%. Please, wait...
"%ArcExe%" a %ArcSwitches% "%CD%\temp\%Name%_upd.7z" "%CD%\%UpdDir%\*" > nul

if not exist "%CD%\temp\%Name%_upd.7z" (
	wscript "%CD%\bin\err_arc.vbs" & exit
) else (
	echo Making Update file...
	copy /b "%CD%\bin\%Name%_upd.bin" + "%CD%\temp\%Name%_upd.7z" "%CD%\%UpdFile%" > nul
	ping -n 1 -w 1 127.0.0.1 > nul
	del /q "%CD%\temp\%Name%_upd.7z"
)

if exist "%CD%\%UpdFile%" (wscript "%CD%\bin\finish.vbs") else (wscript "%CD%\bin\err_unkn.vbs")
:exit
echo.
pause
exit
