/*******************************************************************************************
 This is the part that looks at the config.js file, and generates the checkboxes if they
 are filled in. If any element is blank, it should be ignored.
 ******************************************************************************************/
var lasti = 1;

function fillBoxes() 
{
	position = "boxes.js";
	var txt = new String(); txt = "";
	//used for columns / page flipping / categories ...
	var oldcat = "";
	var cats   = 0;
	var col    = 1;
	var pages  = 1;
	var pi     = 0;
  var winheight = screen.height;
	var i, cols, colwidth, a, b;
 	
	debug("Working on Windows " + getOSver(),1);
	if (sorting && CatsDefined()) SortPrograms();

	if (top.status != "") winheight = top.status;
	cols = Math.round((winheight/3*4)/320,0);
	debug("Winheight: " + winheight + " - Computed " + cols + " columns");
	if (winheight==600) cols=((numCols!=null)?Math.min(numCols,2):2); 
	if (winheight>=768 && numCols!=null) cols=numCols; 
	colwidth=Math.round(100/cols,0);     
	debug(" - Using max. " + cols + " columns with a column-width of " + colwidth + "%",1);

	if (!maxentries)
	{
		switch (winheight)
		{
			case '600': maxentries=21; break;
			case '768': maxentries=28; break;
			case '1024': maxentries=38; break;
			case '1200': maxentries=44; break;	
		}
	}
	debug("Max. Entries: " + maxentries,1,4);
	                                 
  // status debugs
  debug("Dependencies: | ",0,2);                                 
	for (i=1; (prog[i]!=null); i++)
	{     
		if (uid[i] && uid[i]!="" && deps[i]) debug(uid[i] + "->" + deps[i] + " | ",0,2);
  }
  debug("",1,2);                                 
          
  //
  // Render
  //	
	debug("Rendering of boxes started",1); tabs++;
	txt += ('<a name="#pg1"></a>');     
	txt += ('<table class="tclass" cellspacing=0 cellpadding=0><tr class="rtclass"><td width="' + colwidth + '%" valign="top" nowrap>');
	for (i=1; (prog[i]!=null); i++) // for defined programs do ...
	{     
		// We only display things that pass condition tests, unless we are in debug mode.
		//
		if(cond[i] && cond[i][0]) {
			var c = unescape(replpath(cond[i][0]).replace(/\\/g, "\\\\"));
			try {
				if(!eval(c)) {
					debug("Condition failed: " + c + " -- not rendering " + prog[i], 1);
					continue;
				}
			} catch(e) {
				alert("Error in condition statement for " + prog[i] + ":\n\n" + cond[i] + "\n\nTreating as a false condition.");
				continue;
			}
		}

		if ((cons[i]!=null)) // constraint checking
		{ 
			a = cons[i][0]; 
			b = cons[i][1];
			if (replpath(a)!=replpath(b)) // constraint ...
			  continue;
		}
	
		if (cat[i] && cat[i][0] != oldcat ) // insert new category header
		{
			//debug (cat[i][0] + "pi=" + pi+ " cats=" + cats + " col=" + col + " maxe=" + maxentries,1);  
			if ( dontSplitCats && (winheight >=600) && ((pi+catheight+ProgsInCat(cat[i][0]))>maxentries)) {
				if (col<cols)
				{ txt += ('</td><td width="' + colwidth + '%" valign="top" nowrap>'); col++; }
				else 
				{ 
					txt += backnext(lasti,colwidth,true,cols); pages++; col=1;  
				}
				pi=1;
			} 

			txt += ('<div class="category">' + cat[i][0] + '</div><hr align="left" width="95%">\n');
			oldcat = cat[i][0];
			pi+=catheight;
		}
		
		if (CatsDefined() && pi==1)
		{
			txt += ('<div class="category">' + (col==1?oldcat:'&nbsp;') + '</div><hr align="left" width="95%">\n');
			pi+=catheight;			
		}
		//insert checkbox and label
		// -- checkbox --  
		if (debugOn) txt += ('<font class="txt">' + i + '</font>\n');
		txt += ('<input type="checkbox" id="chkbox' + i + '" ');
		if (uid[i]==null || uid[i]=="") 
			txt += ('name="chkbox' + i + '" ');
		else 
		{
			txt += ('name="' + uid[i] + '" ');
			txt += ('onclick="checkDeps(' + i + ');" ');
		}
		txt += ('onMouseOver="qdh(prog[' + i + '],desc[' + i + '],Style[0]);" ');
		txt += ('onMouseOut="htm();"');
		txt += ('/>\n');
		// -- label --
		txt += ('<label class="txt"  ');
		if (uid[i]==null || uid[i]=="") 
			txt += ('  for="chkbox' + i + '" ');
		else
		{
			txt += ('for="' + uid[i] + '" ');
			txt += ('onClick="toggleChecked('+i+');checkDeps(' + i + ');" ');
		}
		txt += ('onMouseOver="qdh(prog[' + i + '],desc[' + i + '],Style[0]);" ');
		txt += ('onMouseOut="htm();" ');
		txt += ('/>' + prog[i] + ((uid[i]&&debugOn)?(' ['+uid[i]+']'):'') + '</label>\n<br>\n');	
		// --
		
		prog[i][0] = noTags(prog[i][0]); // remove HTML tag from program defintion
		if (multi) pi++; // line break in label -> uses more space

		if (prog[i+1] != null) // new column ?, handle different resolutions 
		{
			pi++;      			
			if ( (winheight >=600) && pi>maxentries ) {
			  //debug (cat[i][0] + " pi=" + pi+ " col=" + col + " maxe=" + maxentries,1);  
				if (col<cols)
				{ txt += ('</td><td width="' + colwidth + '%" valign="top" nowrap>'); col++; }
				else 
				{ 
					txt += backnext(lasti,colwidth,true,cols); pages++; col=1; //pi=0; cats=0;
				}
				pi=1;
			}         
		}
	}

	if (lasti>1) //insert scroll buttons on last page
	{
		previ = lasti - 1;
		if (previ!=0) txt += backnext(lasti,colwidth,false,cols);
	}
	txt += ('</td></tr></table>');  
	tabs--; debug("Rendering of boxes finished",1);

	document.all.layerboxes.innerHTML = txt;
}

//
// This function creates a page-break and the virtual scrollbar
//
function backnext(li,colw,next, cols) 
{
	position = "boxes.js";
	var txt = new String();
	txt = "";

	previ = li - 1;
	nexti = li + 1;     

	var colwidth=Math.round(100/cols,0);     
	txt += ('</td></tr>\n<tr class="rtclass"><td colspan="' + cols + '" height="100%" >' );
	
	txt += ('<table class="tclass" height="100%" cellspacing=0 cellpadding=0><tr><td><hr size="1"></td>');
	if (previ!=0)
		txt += ('<td class="backnext" align="center"><a class="backnext" href="#pg' + previ + '"></a></td>');
  else
		txt += ('<td class="backnext"><hr size="1"></td>');
  txt += ('<td width=10><hr size="1"></td>');
	if (next) 
		txt += ('<td class="backnext" align="center"><a class="backnext" href="#pg' + nexti + '"></a></td>');
  else
		txt += ('<td class="backnext"><hr size="1"></td>');
	txt += ('<td width=50><hr size="1"></td></tr></table>');
	
	txt += ('</td></tr></table>');
	
	if (next)
	{
		txt += ('<table class="tclass">');
		txt += ('<tr class="rtclass"><td width="' + colwidth + '%" valign="top" nowrap>');
		txt += ('<a name="#pg' + nexti + '"></a>'); 
  }      
	else txt+=('<table><tr><td>');
	lasti= nexti;	
	return txt;
}		