#Region ;**** Directives created by AutoIt3Wrapper_GUI ****
#AutoIt3Wrapper_icon=Resources\folder.ico
#AutoIt3Wrapper_outfile=foldertree.exe
#AutoIt3Wrapper_Res_Comment=Folders tree constructor
#AutoIt3Wrapper_Res_Description=Tree-like view of folders
#AutoIt3Wrapper_Res_Fileversion=0.0.0.1
#AutoIt3Wrapper_Res_Fileversion_AutoIncrement=y
#AutoIt3Wrapper_Res_LegalCopyright=Kaster
#AutoIt3Wrapper_Res_Language=1049
#EndRegion ;**** Directives created by AutoIt3Wrapper_GUI ****

#include 'Include\File.au3'
#include 'Include\Array.au3'
#include 'Include\ExtConstants.au3'
;----------------------------------
DirCreate(@ScriptDir & '\Include')
DirCreate(@ScriptDir & '\Resources')
DirCreate(@ScriptDir & '\Collected files')
FileInstall('Include\File.au3', @ScriptDir & '\Include\File.au3')
FileInstall('Include\Array.au3', @ScriptDir & '\Include\Array.au3')
FileInstall('Include\ExtConstants.au3', @ScriptDir & '\Include\ExtConstants.au3')
FileInstall('Resources\folder.ico', @ScriptDir & '\Resources\folder.ico')
FileInstall('Resources\arrow.jpg', @ScriptDir & '\Resources\arrow.jpg')
;----------------------------------
TraySetIcon(@ScriptDir & '\Resources\folder.ico')

#Region Global Variables
Global $sRoot

Global $s_bLine1 = ''
Global $s_bLine2 = ''

For $i = 1 To 120
	$s_bLine1 &= '-'
Next

For $i = 1 To 20
	$s_bLine2 &= '_'
Next

Global $iTotal_Files = 0
Global $iTotal_Folders = 0

Global $sSeperater = ''

Global $s_Open_pTag = '<p class=mystyle><span style=''font-family:"Courier New"''>'
Global $s_Close_pTag = '</span></p>'
Global $s_Open_sTag = '<span style="color:red">'
Global $s_Close_sTag = '</span>'
#EndRegion Global Variables
;

$sRoot = FileSelectFolder('Choose folder to tree-like representation', '', 7, @ScriptDir)

If @error Then
	MsgBox(48, 'Warning', 'The folder was''nt been chosen. Script will be shut off now.', 3)
	Exit
EndIf

_Main()

Func _Main()
	$sRoot_Name = ''
	
	If StringRight($sRoot, 2) = ':\' Then
		$sRoot_Name = 'Disk ' & StringTrimRight($sRoot, 2)
	Else
		$sRoot_Name = StringRegExpReplace($sRoot, '^.*\\', '')
	EndIf
	
	$nMsg = MsgBox(51, 'Warning', _
		'For text-like representation of folders tree, please, press "Yes".' & @CRLF & _
		'For representation in html-like form, please, press "No"' & @CRLF & _
		'For Exit the script, please, press "Cancel"')
	
	If $nMsg = 6 Then
		$sFile_Content = $sRoot_Name & ' (' & $sRoot & ')' & @CRLF
		$sFile_Content &= $s_bLine1 & @CRLF
		
		$sFile_Content &= _TxtWrite_Proc($sRoot)
		$sFile_Content &= $s_bLine2 & @CRLF
		
		$sEnd_Line = 'The root folder (' & $sRoot & ') has ' & $iTotal_Files & ' file(s) in ' & $iTotal_Folders & ' folder(s)'
		
		$sFile_Content &= $sEnd_Line & @CRLF
		
		$hFile = FileOpen(@ScriptDir & '\Collected files\' & $sRoot_Name & '.txt', 2)
		FileWrite($hFile, $sFile_Content)
		FileClose($hFile)
		
		ShellExecute(@ScriptDir & '\Collected files\' & $sRoot_Name & '.txt')
	ElseIf $nMsg = 7 Then
		$sFile_Content = '<html>' & @CRLF
		$sFile_Content &= '<head>' & @CRLF
		$sFile_Content &= '<meta http-equiv=Content-Type content="text/html; charset=windows-1251">' & @CRLF
		$sFile_Content &= '<style>' & @CRLF
		
		$sFile_Content &= _
			'<!--' & @CRLF & _
			'/* Font Definitions */' & @CRLF & _
			'p.mystyle, li.mystyle, div.mystyle' & @CRLF & _
			'{mso-style-link:"Plain Text Char";' & @CRLF & _
			'margin:0in;' & @CRLF & _
			'margin-bottom:.0001pt;' & @CRLF & _
			'font-size:10.5pt;' & @CRLF & _
			'font-family:Consolas;}' & @CRLF & _
			'@page Section1' & @CRLF & _
			'{size:595.45pt 841.7pt;' & @CRLF & _
			'margin:56.9pt 66.8pt 56.9pt 66.8pt;}' & @CRLF & _
			'div.Section1' & @CRLF & _
			'{page:Section1;}' & @CRLF & _
			'-->' & @CRLF & '</style>' & @CRLF & '</head>' & @CRLF & '<body lang=RU-RU>' & @CRLF
		
		$sFile_Content &= $s_Open_pTag & '<b>' & $sRoot_Name & ' (' & $sRoot & ')' & '</b>' & $s_Close_pTag & @CRLF
		$sFile_Content &= $s_Open_pTag & $s_bLine1 & $s_Close_pTag & @CRLF
		
		$sFile_Content &= _HtmlWrite_Proc($sRoot)
		
		$sFile_Content &= $s_Open_pTag & '<span style="color:green">' & $s_bLine1 & '</span>' & $s_Close_pTag & @CRLF
		
		$sEnd_Line = _
			'The root folder (' & $sRoot & ') has <span style="color:red">' & _
			$iTotal_Files & '</span> file(s) in <span style="color:red">' & _
			$iTotal_Folders & '</span> folder(s)'
		
		$sFile_Content &= '<p class=mystyle align=left style="text-align:left"><span style=''font-family:"Courier New"''><b>' & _
			$sEnd_Line & '</b></span></p>' & @CRLF
		
		$sFile_Content &= '</body>' & @CRLF & '</html>' & @CRLF
		
		$hFile = FileOpen(@ScriptDir & '\Collected files\' & $sRoot_Name & '.html', 2)
		FileWrite($hFile, $sFile_Content)
		FileClose($hFile)
		
		ShellExecute(@ScriptDir & '\Collected files\' & $sRoot_Name & '.html')
	EndIf
EndFunc

Func _TxtWrite_Proc($sPath)
	$sSeperater &= '____'
	
	Local $sRet_Content = ""
	Local $aFiles = _FileListToArray($sPath, "*", 1)
	Local $aFolders = _FileListToArray($sPath, "*", 2)
	
	If Not IsArray($aFiles) And Not IsArray($aFolders) Then Return "" ;No files/folders found
	
	For $i = 1 To UBound($aFolders)-1
		$iTotal_Folders += 1
		$sLast_Sep = $sSeperater
		
		$sLine = $sSeperater & '[' & $aFolders[$i] & ']'
		$sRet_Content &= $sLine & @CRLF
		
		$sNew_Path = $sPath & '\' & $aFolders[$i]
		$sRet_Content &= _TxtWrite_Proc($sNew_Path)
		$sSeperater = $sLast_Sep
	Next
	
	For $i = 1 To UBound($aFiles)-1
		If $i = 1 Then $sRet_Content &= $sSeperater & '|' & StringLeft($s_bLine1, 120 - StringLen($sSeperater & '|')) & @CRLF
		
		$sLine = $sSeperater & '|' & $aFiles[$i]
		$sRet_Content &= $sLine & @CRLF
		
		If $i = $aFiles[0] Then _
			$sRet_Content &= $sSeperater & '|' & StringRight($s_bLine1, 120 - StringLen($sSeperater & '|')) & @CRLF
		
		$iTotal_Files += 1
	Next
	
	Return $sRet_Content
EndFunc

Func _HtmlWrite_Proc($sPath)
	$sSeperater &= '____'
	
	Local $sRet_Content = ""
	Local $aFiles = _FileListToArray($sPath, "*", 1)
	Local $aFolders = _FileListToArray($sPath, "*", 2)
	
	If Not IsArray($aFiles) And Not IsArray($aFolders) Then Return "" ;No files/folders found
	
	For $i = 1 To UBound($aFolders)-1
		$iTotal_Folders += 1
		$sLast_Sep = $sSeperater
		$sLine = $sSeperater & $s_Open_sTag & '<b>[' & $aFolders[$i] & ']</b>' & $s_Close_sTag
		
		$sPath_Html = StringReplace($sPath, '\', '/')
		$sNew_ScriptDir = StringReplace(@ScriptDir, '\', '/')
		
		$sRet_Content &= _
			$s_Open_pTag & $sLine & _
			'<a href="file:///' & $sPath_Html & '/' & $aFolders[$i] & _
			'"><img border=0 width=12 height=9 id="pic1" src="file:///' & _
			$sNew_ScriptDir & '/Resources/arrow.jpg" title="Please, click to open the specified folder"></a></p>' & @CRLF
		
		$sNew_Path = $sPath & '\' & $aFolders[$i]
		$sRet_Content &= _HtmlWrite_Proc($sNew_Path)
		$sSeperater = $sLast_Sep
	Next
	
	For $i = 1 To UBound($aFiles)-1
		If $i = 1 Then _
			$sRet_Content &= $s_Open_pTag & $sSeperater & '|' & _
				StringLeft($s_bLine1, 120 - StringLen($sSeperater & '|')) & $s_Close_pTag & @CRLF
		
		$sLine = $sSeperater & '|' & _GetTag($aFiles[$i])
		
		$sRet_Content &= $s_Open_pTag & $sLine & $s_Close_pTag & @CRLF
		
		If $i = $aFiles[0] Then _
			$sRet_Content &= $s_Open_pTag & $sSeperater & '|' & _
				StringRight($s_bLine1, 120 - StringLen($sSeperater & '|')) & $s_Close_pTag & @CRLF
		
		$iTotal_Files += 1
	Next
	
	Return $sRet_Content
EndFunc

Func _PathIsFolder($sPath)
	Return StringInStr(FileGetAttrib($sPath), "D")
EndFunc

Func _GetTag($sFile_Name)
	Local $sExt = StringRegExpReplace($sFile_Name, "^.*\.", "")
	Local $sRet_Tag = ""
	
	If _ExtFound($HTM_EXT, $sExt) Then
		$sRet_Tag = '<span style="color:8000FF">' & $sFile_Name & '</span>'
	ElseIf _ExtFound($ECL_EXT, $sExt) Then
		$sRet_Tag = '<span style="color:636D98">' & $sFile_Name & '</span>'
	ElseIf _ExtFound($TXT_EXT, $sExt) Then
		$sRet_Tag = '<span style="color:800080">' & $sFile_Name & '</span>'
	ElseIf _ExtFound($ARC_EXT, $sExt) Then
		$sRet_Tag = '<span style="color:6C6C00">' & $sFile_Name & '</span>'
	ElseIf _ExtFound($EXE_EXT, $sExt) Then
		$sRet_Tag = '<span style="color:B05800">' & $sFile_Name & '</span>'
	ElseIf _ExtFound($IMG_EXT, $sExt) Then
		$sRet_Tag = '<span style="color:757575">' & $sFile_Name & '</span>'
	ElseIf _ExtFound($AUD_EXT, $sExt) Then
		$sRet_Tag = '<span style="color:00B0B0">' & $sFile_Name & '</span>'
	ElseIf _ExtFound($VID_EXT, $sExt) Then
		$sRet_Tag = '<span style="color:006A9B">' & $sFile_Name & '</span>'
	ElseIf _ExtFound($PIC_EXT, $sExt) Then
		$sRet_Tag = '<span style="color:006C36">' & $sFile_Name & '</span>'
	ElseIf _ExtFound($PRS_EXT, $sExt) Then
		$sRet_Tag = '<span style="color:FF5500">' & $sFile_Name & '</span>'
	ElseIf _ExtFound($SYS_EXT, $sExt) Then
		$sRet_Tag = '<span style="color:262670">' & $sFile_Name & '</span>'
	ElseIf $sExt = $sFile_Name Then
		$sRet_Tag = '<span style ="color:04216C">' & '<i>' & $sFile_Name & '</i></span>'
	Else
		$sRet_Tag = '<span style="color:000000">' & $sFile_Name & '</span>'
	EndIf
	
	Return $sRet_Tag
EndFunc

Func _ExtFound($sExtTags, $sExt)
	Return StringInStr("|" & $sExtTags & "|", "|" & $sExt & "|")
EndFunc
