#define MyAppName "My Application"
#define MyAppNamePortable "MyApplicationPortable"
#define MyAppConstantName "{pf}"
#define MyAppDirName "My Application"

[Setup]
AppName={#MyAppName}
AppVersion=1.5
DefaultDirName={pf}\{#MyAppDirName}
OutputDir=.

[Files]
#ifndef IS_ENHANCED
  #if VER < 0x06000000
; https://web.archive.org/web/20150510131335if_/http://restools.hanzify.org/inno/callbackctrl/InnoCallbackCtrl_V1.1.zip
Source: CallbackCtrl.dll; Flags: dontcopy
  #endif
#endif

[Code]
// CallbackCtrl.dll Functions
#ifndef IS_ENHANCED
  #if VER < 0x06000000
type
  TSubclassProc = function(hWnd: HWND; uMsg: UINT; wParam: UINT_PTR; lParam: INT_PTR;
    uIdSubclass: UINT_PTR; dwRefData: DWORD_PTR): INT_PTR;
function WrapSubclassProc(Callback: TSubclassProc; ParamCount: Integer): LongWord; external 'wrapcallbackaddr@files:callbackctrl.dll stdcall';
  #endif
#endif

// Shell Functions
function SetWindowSubclass(hWnd: HWND; pfnSubclass: LongWord; uIdSubclass: UINT_PTR; dwRefData: DWORD_PTR): BOOL; external 'SetWindowSubclass@comctl32.dll stdcall';
function RemoveWindowSubclass(hWnd: HWND; pfnSubclass: LongWord; uIdSubclass: UINT_PTR): BOOL; external 'RemoveWindowSubclass@comctl32.dll stdcall';
function DefSubclassProc(hWnd: HWND; uMsg: UINT; wParam: UINT_PTR; lParam: INT_PTR): INT_PTR; external 'DefSubclassProc@comctl32.dll stdcall';

const
  WM_NOTIFY = $004E;

  TV_FIRST              = $1100;
  TVM_EXPAND            = (TV_FIRST + 2);
  TVM_GETNEXTITEM       = (TV_FIRST + 10);

  TVN_FIRST         = (0-400);
  TVN_SELCHANGEDW   = (TVN_FIRST-51);
  TVN_ITEMEXPANDEDW = (TVN_FIRST-55);

  TVE_COLLAPSE  = $0001;
  TVE_EXPAND    = $0002;

  TVGN_ROOT   = $0000;
  TVGN_NEXT   = $0001;
  TVGN_PARENT = $0003;
  TVGN_CHILD  = $0004;

#ifndef IS_ENHANCED
  BM_CLICK = $00F5;
#endif

type
  TTVItem = record
    mask: UINT;
    hItem: THandle;
    state: UINT;
    stateMask: UINT;
    pszText: LongWord;
    cchTextMax: Integer;
    iImage: Integer;
    iSelectedImage: Integer;
    cChildren: Integer;
    lParam: Longint;
  end;

  TNMHdr = record
    hwndFrom: HWND;
    idFrom: LongWord;
    code: UINT;
  end;

  TNMTreeView = record
    hdr: TNMHdr;
    action: UINT;
    itemOld: TTVItem;
    itemNew: TTVItem;
    ptDrag: TPoint;
  end;

// Run-Time Library (RTL) Routines
procedure ReadNMHdr(out Destination: TNMHdr; Source: Longint; Length: DWORD); external 'RtlMoveMemory@kernel32.dll stdcall';
procedure ReadNMTreeView(out Destination: TNMTreeView; Source: Longint; Length: DWORD); external 'RtlMoveMemory@kernel32.dll stdcall';

function TreeView_Expand(hwnd: HWND; hitem: THandle; code: Integer): Boolean;
begin
  Result := Boolean(SendMessage(hwnd, TVM_EXPAND, code, hitem));
end;

function TreeView_GetNextItem(hwnd: HWND; hitem: THandle; code: Integer): THandle;
begin
  Result := THandle(SendMessage(hwnd, TVM_GETNEXTITEM, code, hitem));
end;

function TreeView_GetParent(hwnd: HWND; hitem: THandle): THandle;
begin
  Result := TreeView_GetNextItem(hwnd, hitem, TVGN_PARENT);
end;

function TreeView_GetChild(hwnd: HWND; hitem: THandle): THandle;
begin
  Result := TreeView_GetNextItem(hwnd, hitem, TVGN_CHILD);
end;

function TreeView_GetNextSibling(hwnd: HWND; hitem: THandle): THandle;
begin
  Result := TreeView_GetNextItem(hwnd, hitem, TVGN_NEXT);
end;

function TreeView_GetRoot(hwnd: HWND; hitem: THandle): THandle;
begin
  Result := TreeView_GetNextItem(hwnd, hitem, TVGN_ROOT);
end;

var
  CustomSelectDirPage: TInputDirWizardPage;
  PCustomSelectDirPageWndProc: LongWord;

function CustomSelectDirPageWndProc(hWnd: HWND; uMsg: UINT; wParam: UINT_PTR; lParam: INT_PTR;
  uIdSubclass: UINT_PTR; dwRefData: DWORD_PTR): INT_PTR;
var
  LNMHdr: TNMHdr;
  LNMTreeView: TNMTreeView;
  LTVItemOldParentHandle, LTVItemNewParentHandle, LTVItemSiblingHandle: THandle;
begin
  case uMsg of
    WM_NOTIFY:
      begin
        Result := DefSubclassProc(hWnd, uMsg, wParam, lParam);
        ReadNMHdr(LNMHdr, lParam, SizeOf(LNMHdr));
        case LNMHdr.code of
          TVN_SELCHANGEDW:
            begin
              ReadNMTreeView(LNMTreeView, lParam, SizeOf(LNMTreeView));
              if (LNMTreeView.itemNew.hItem > 0) and
                (LNMTreeView.itemOld.hItem > 0) then
              begin
                LTVItemNewParentHandle := TreeView_GetParent(LNMHdr.hwndFrom, LNMTreeView.itemNew.hItem);
                LTVItemOldParentHandle := TreeView_GetParent(LNMHdr.hwndFrom, LNMTreeView.itemOld.hItem);
                { New and Old are siblings. }
                if LTVItemOldParentHandle = LTVItemNewParentHandle then
                begin
                  TreeView_Expand(LNMHdr.hwndFrom, LNMTreeView.itemOld.hItem, TVE_COLLAPSE);
                  TreeView_Expand(LNMHdr.hwndFrom, LNMTreeView.itemNew.hItem, TVE_EXPAND);
                end else
                begin
                  { Collapse all New siblings. }
                  LTVItemSiblingHandle := TreeView_GetChild(LNMHdr.hwndFrom, LTVItemNewParentHandle);
                  while LTVItemSiblingHandle > 0 do
                  begin
                    if LTVItemSiblingHandle <> LNMTreeView.itemNew.hItem then
                      TreeView_Expand(LNMHdr.hwndFrom, LTVItemSiblingHandle, TVE_COLLAPSE) else
                      TreeView_Expand(LNMHdr.hwndFrom, LTVItemSiblingHandle, TVE_EXPAND);
                    LTVItemSiblingHandle := TreeView_GetNextSibling(LNMHdr.hwndFrom, LTVItemSiblingHandle);
                  end;
                end;
                { Select new directory. }
                with TFolderTreeView(CustomSelectDirPage.FindComponent('DirTreeView')) do
                begin
                  CustomSelectDirPage.Values[0] := Directory + '\{#MyAppDirName}';
                  ChangeDirectory(CustomSelectDirPage.Values[0], True);
                end;
              end;
            end;
        end;
      end;
  else
    Result := DefSubclassProc(hWnd, uMsg, wParam, lParam);
  end;
end;

procedure DirBrowseButtonClick(Sender: TObject);
var
  LDirTreeView: TFolderTreeView;
begin
  LDirTreeView := TFolderTreeView(CustomSelectDirPage.FindComponent('DirTreeView'));
  LDirTreeView.ChangeDirectory(WizardDirValue, True);

  TreeView_Expand(LDirTreeView.Handle, TreeView_GetRoot(LDirTreeView.Handle, 0), TVE_COLLAPSE);

  CustomSelectDirPage.Tag := 1;
#ifdef IS_ENHANCED
  WizardForm.NextButton.Click();
#else
  SendMessage(WizardForm.NextButton.Handle, BM_CLICK, 0, 0);
#endif
end;

procedure CustomSelectDirPageActivate(Sender: TWizardPage);
var
  LCustomSelectDirPageDesc: string;
  LDirTreeView: TFolderTreeView;
begin
  WizardForm.BackButton.Caption := '';
  WizardForm.NextButton.Caption := SetupMessage(msgButtonOK);
  WizardForm.CancelButton.Caption := SetupMessage(msgButtonCancel);
  LCustomSelectDirPageDesc := WizardForm.PageDescriptionLabel.Caption;
  StringChangeEx(LCustomSelectDirPageDesc, '[name]', '%1', True);
  WizardForm.PageDescriptionLabel.Caption := FmtMessage(LCustomSelectDirPageDesc, ['{#MyAppName}']);

  CustomSelectDirPage.Values[0] := WizardDirValue;
  LDirTreeView := TFolderTreeView(Sender.FindComponent('DirTreeView'));
  LDirTreeView.ChangeDirectory(CustomSelectDirPage.Values[0], True);
end;

procedure CustomSelectDirPageCancelButtonClick(Sender: TWizardPage; var ACancel, AConfirm: Boolean);
begin
  Sender.Tag := 0;
  ACancel := False;
  AConfirm := False;
#ifdef IS_ENHANCED
  WizardForm.BackButton.Click();
#else
  SendMessage(WizardForm.BackButton.Handle, BM_CLICK, 0, 0);
#endif
end;

function CustomSelectDirPageBackButtonClick(Sender: TWizardPage): Boolean;
var
  LDirTreeView: TFolderTreeView;
  LTVItemHandle: THandle;
begin
  Result := Sender.Tag = 0;

  LDirTreeView := TFolderTreeView(Sender.FindComponent('DirTreeView'));
  LTVItemHandle := TreeView_GetRoot(LDirTreeView.Handle, 0);
  while LTVItemHandle > 0 do
  begin
    TreeView_Expand(LDirTreeView.Handle, LTVItemHandle, TVE_COLLAPSE);
    LTVItemHandle := TreeView_GetNextSibling(LDirTreeView.Handle, LTVItemHandle);
  end;

  CustomSelectDirPage.Values[0] := ExpandConstant('{#SetupSetting("DefaultDirName")}');
  LDirTreeView.ChangeDirectory(CustomSelectDirPage.Values[0], True);
end;

function CustomSelectDirPageNextButtonClick(Sender: TWizardPage): Boolean;
begin
  Result := False;

  Sender.Tag := 0;
  WizardForm.DirEdit.Text := CustomSelectDirPage.Values[0];
#ifdef IS_ENHANCED
  WizardForm.BackButton.Click();
#else
  SendMessage(WizardForm.BackButton.Handle, BM_CLICK, 0, 0);
#endif
end;

function CustomSelectDirPageShouldSkipPage(Sender: TWizardPage): Boolean;
begin
  Result := Sender.Tag = 0;
end;

procedure InitializeWizard();
var
  LDirBrowseButton: TButton;
  LDirTreeView: TFolderTreeView;
begin
  LDirBrowseButton := TButton.Create(WizardForm);
  with LDirBrowseButton do
  begin
    Parent := WizardForm.SelectDirPage;
    SetBounds(WizardForm.DirBrowseButton.Left, WizardForm.DirBrowseButton.Top,
      WizardForm.DirBrowseButton.Width, WizardForm.DirBrowseButton.Height);
    Caption := SetupMessage(msgButtonBrowse);
    OnClick := @DirBrowseButtonClick;
  end;

  CustomSelectDirPage := CreateInputDirPage(wpSelectDir,
    SetupMessage(msgWizardSelectDir), SetupMessage(msgSelectDirDesc), '', False, '');
  with CustomSelectDirPage do
  begin
    Add(SetupMessage(msgBrowseDialogLabel));
    PromptLabels[0].Align := alTop;
    Edits[0].Align := alTop;
    Edits[0].Text := WizardDirValue;
    Buttons[0].Hide;
    SubCaptionLabel.Top := Edits[0].Top + Edits[0].Height;
    SubCaptionLabel.Align := alTop;
  #ifdef IS_ENHANCED
    PCustomSelectDirPageWndProc := CallbackAddr('CustomSelectDirPageWndProc');
  #elif VER >= 0x06000000
    PCustomSelectDirPageWndProc := CreateCallback(@CustomSelectDirPageWndProc);
  #else
    PCustomSelectDirPageWndProc := WrapSubclassProc(@CustomSelectDirPageWndProc, 6);
  #endif
    SetWindowSubclass(Surface.Handle, PCustomSelectDirPageWndProc, 0, 0);

    LDirTreeView := TFolderTreeView.Create(CustomSelectDirPage);
    with LDirTreeView do
    begin
      Name := 'DirTreeView';
      Parent := Surface;
      Align := alClient;
    end;

    OnActivate := @CustomSelectDirPageActivate;
    OnCancelButtonClick := @CustomSelectDirPageCancelButtonClick;
    OnBackButtonClick := @CustomSelectDirPageBackButtonClick;
    OnNextButtonClick := @CustomSelectDirPageNextButtonClick;
    OnShouldSkipPage := @CustomSelectDirPageShouldSkipPage;
  end;
end;

procedure DeinitializeSetup();
begin
  if ExpandConstant('{wizardhwnd}') = '0' then Exit;
  if PCustomSelectDirPageWndProc > 0 then
    RemoveWindowSubclass(CustomSelectDirPage.Surface.Handle, PCustomSelectDirPageWndProc, 0);
end;

