!include "MUI2.nsh"

!include "ProcessFunc.nsh"

!insertmacro MUI_PAGE_INSTFILES
!insertmacro MUI_LANGUAGE "Russian"

ShowInstDetails show
OutFile TestProcFunc.exe

Section "TestProc"

;====     ====================

/* ${FindProcessName} ".exe" $var
    --
     $var   
        $var = 1 >  
        $var = none >   
        $var = error > 
*/

  ${FindProcessName} "explorer.exe" $1
  StrCmp $1 none Done1
  StrCmp $1 error Done1
     MessageBox MB_ICONINFORMATION|MB_OK "$$1 = $1$\nProcess [ explorer ] found"
  Done1:
  StrCmp $1 none 0 +2
  MessageBox MB_ICONINFORMATION|MB_OK "$$1 = $1$\nProcess [ explorer ] not found"
  StrCmp $1 error 0 +2
  MessageBox MB_ICONINFORMATION|MB_OK "$$1 = $1$\nProcess error"
  
;=====      ====================

/* ${FindProcessPath} ".exe" $var
    --
     $var   
        $var =   
        $var = none >   
        $var = error > 
*/
  ${FindProcessPath} "explorer.exe" $2
  StrCmp $2 none Done2
  StrCmp $2 error Done2
     MessageBox MB_ICONINFORMATION|MB_OK "Path process [ explorer ]:$\n$$2 = $2"
  Done2:
  StrCmp $2 none 0 +2
  MessageBox MB_ICONINFORMATION|MB_OK "$$2 = $2$\nProcess [ explorer ] not found"
  StrCmp $2 error 0 +2
  MessageBox MB_ICONINFORMATION|MB_OK "$$2 = $2$\nProcess error"

;=======   ====================

/* ${FindProcessName} ".exe" $var
    --
     $var   
        $var =  
        $var = none >   
        $var = error > 
*/

  ${FindProcessPID} explorer.exe $3
  StrCmp $3 none Done3
  StrCmp $3 error Done3
     MessageBox MB_ICONINFORMATION|MB_OK "PID process [ explorer ] = $3"
  Done3:
  StrCmp $3 none 0 +2
  MessageBox MB_ICONINFORMATION|MB_OK "$$3 = $3$\nProcess [ explorer ] not found"
  StrCmp $3 error 0 +2
  MessageBox MB_ICONINFORMATION|MB_OK "$$3 = $3$\nProcess error"

;==== =================================================
/* ${KillProcess} ".exe" $var
    --
     $var   
        $var = 1 >   
        $var = 2 >   
        $var = none >   
        $var = error > 
*/
  ${KillProcess} "explorer.exe" $4
  StrCmp $4 2 Done4
  StrCmp $4 none Done4
  StrCmp $4 error Done4
     MessageBox MB_ICONINFORMATION|MB_OK "Kill process [ explorer ]:$\n$$4 = $4"
     Exec "$2" ; 
  Done4:
  StrCmp $4 2 0 +2
  MessageBox MB_ICONINFORMATION|MB_OK "Not kill process [ explorer ]:$\n$$4 = $4"
  StrCmp $4 none 0 +2
  MessageBox MB_ICONINFORMATION|MB_OK "$$4 = $4$\nProcess [ explorer ] not found"
  StrCmp $4 error 0 +2
  MessageBox MB_ICONINFORMATION|MB_OK "$$4 = $4\nProcess error"
  
;====   =========================================

  ${If} ${ProcessExists} "explorer.exe"
     MessageBox MB_ICONINFORMATION|MB_OK " "
     ;   ,   
  ${Else}
     MessageBox MB_ICONINFORMATION|MB_OK "  "
     ;   ,    
  ${EndIf}
  
;====     ===========

/*
   ${ProcessWait} "process.exe" "time" $var
   ---
   process.exe >  
   time >     ( 0  ~)
    time = -1,     
    $var   :
     $var = none  >   
     $var = error >      
     $var =  1    >   
*/

  ${ProcessWait} "explorer.exe" "1000" $5 ; 1 
  StrCmp $5 none Done5
  StrCmp $5 error Done5
      DetailPrint "ProcessWait 1000ms explorer.exe  = $5"
  Done5:
  StrCmp $5 none 0 +2
  MessageBox MB_ICONINFORMATION|MB_OK "$$5 = $5$\nProcess [ explorer ] not found"
  StrCmp $5 error 0 +2
  MessageBox MB_ICONINFORMATION|MB_OK "$$5 = $5\nProcess error"
;==       =============

/*
   ${ExecWait} "Path\app.exe [parametr1] [parametr2]" $var
   ---
       $var  :
      $var = 0 >   
      $var = 1 >   
      $var = error >   
      $var = [exitcode] >   
   ---
         .
   .    ,  nsExec.dll
   nsExec::Exec "app.exe"
*/

  ${ExecWait} "calc.exe" $6
  StrCmp $6 none Done6
  StrCmp $6 error Done6
    DetailPrint "ExecWait [ calc.exe ] exitcode: $6"
  Done6:
  StrCmp $6 1 0 +2
  MessageBox MB_ICONINFORMATION|MB_OK "$$6 = $6$\nProcess [ calc.exe ] kill"  ;    
  StrCmp $6 error 0 +2
  MessageBox MB_ICONINFORMATION|MB_OK "$$6 = $6\nProcess error"
;=======  ========================================

/*  ${EnumProcess} Function
  ---
   $0 - $9   !!!
        :
      $3 >  
      $4 >  
      $5 >   
      $6 > ""    +   
      $8 >  
      $9 >   
  ---
   $R0 - $R9   
*/
  ClearErrors
  FileOpen $R0 Process.txt w
  
  ${EnumProcess} Process
  IfErrors 0 +2 ;  ,     
  MessageBox MB_ICONSTOP|MB_OK "Error createsnapshot" IDOK
  
  FileClose $R0
  
SectionEnd

Function Process
    DetailPrint "*********************************"
    DetailPrint "PID = $4"         ; 
    DetailPrint "Name = $3"        ; 
    DetailPrint "Path = $5"        ;  
    DetailPrint "Priority = $8"    ; 
    DetailPrint "UserName = $9"    ;  
;------------------------------------------------------------
    ;    
    FileWrite $R0 "\
       *********************************$\r$\n$\r$\n\
       PID = $4$\r$\n\
       Name = $3$\r$\n\
       Path = $5$\r$\n\
       PathDOS = $6$\r$\n\
       Priority = $8$\r$\n\
       UserName = $9$\r$\n$\r$\n"
;------------------------------------------------------------
FunctionEnd
