﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Data.OleDb;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using System.Diagnostics;

namespace EStest
{
  public partial class FormMain : Form
  {
    public FormMain()
    {
      InitializeComponent();
    }
    private OleDbConnection cn;
    private DataSet ds = new DataSet();
    private OleDbDataAdapter daFactor;
    private OleDbDataAdapter daFactorValue;
    private OleDbDataAdapter daValue;
    private OleDbDataAdapter daTable;
    private OleDbDataAdapter daTableValue;
    private OleDbDataAdapter daRule;
    private BindingSource bsFactor      = new BindingSource();
    private BindingSource bsFactorValue = new BindingSource();
    private BindingSource bsTable       = new BindingSource();
    private BindingSource bsTableValue  = new BindingSource();
    private BindingSource bsValueFactor = new BindingSource();
    private BindingSource bsRule        = new BindingSource();  

    private void DBcon(String DBname)
    {
      cn = new OleDbConnection("Provider=Microsoft.Jet.OLEDB.4.0; Data Source=" + Application.StartupPath +
                                "\\\\" + DBname);
      try
      {
        cn.Open();
      }
      catch 
      {
        MessageBox.Show("Ошибка соединения с базой данных " + "\"" + DBname + "\"", "Ошибка подключения к базе",
                         MessageBoxButtons.OK, MessageBoxIcon.Error);
        Application.Exit();
      }
    }

    private void TuningDgv()
    {
// Настройка внешнего вида таблицы DicFactor
      dgvFactor.Columns["ID"].Visible = false;
      dgvFactor.Columns["Factor"].HeaderText     = "Фактор";
      dgvFactor.Columns["FactorNum"].HeaderText  = "Номер фактора";
      dgvFactor.Columns["FactorMemo"].HeaderText = "Примечание";
                                            //dgvFactor.Columns["FactorNum"].HeaderText.Length;
      dgvFactor.Columns["FactorNum"].DefaultCellStyle.Alignment = DataGridViewContentAlignment.MiddleCenter;
      dgvFactor.ColumnHeadersDefaultCellStyle.Alignment = DataGridViewContentAlignment.MiddleCenter;
// Настройка внешнего вида таблицы DicFactorValue
      dgvValue.Columns["ID"].Visible = false;
      dgvValue.Columns["FactorValue"].HeaderText     = "Значение";
      dgvValue.Columns["FactorValueNum"].HeaderText  = "Номер значения";
      dgvValue.Columns["FactorValueMemo"].HeaderText = "Примечание";
      dgvValue.Columns["FactorValue"].AutoSizeMode   = DataGridViewAutoSizeColumnMode.AllCells;
      dgvValue.Columns["FactorValueNum"].MinimumWidth = dgvValue.Columns["FactorValueNum"].HeaderCell.Size.Width +
                                                        dgvValue.Columns["FactorValueNum"].HeaderText.Length;
      dgvValue.Columns["FactorValueNum"].DefaultCellStyle.Alignment = DataGridViewContentAlignment.MiddleCenter;
      dgvValue.ColumnHeadersDefaultCellStyle.Alignment = DataGridViewContentAlignment.MiddleCenter;
// Настройка внешнего вида таблицы FactorValue
      dgvFactorValue.Columns["ID"].Visible = false;
      dgvFactorValue.Columns["FactorID"].Visible = false;
// Настройка внешнего вида таблицы Table
      dgvTable.Columns["ID"].Visible = false;
      dgvTable.Columns["TableName"].AutoSizeMode = DataGridViewAutoSizeColumnMode.AllCells;
      dgvTable.Columns["FactorID"].AutoSizeMode = DataGridViewAutoSizeColumnMode.AllCells;
      dgvTable.Columns["TableMemo"].AutoSizeMode = DataGridViewAutoSizeColumnMode.AllCells;
      dgvTable.ColumnHeadersDefaultCellStyle.Alignment = DataGridViewContentAlignment.MiddleCenter;
// Настройка внешнего вида таблицы TableValue
      dgvTableValue.Columns["ID"].Visible = false;
      dgvTableValue.Columns["TableFactorID"].Visible = false;
      dgvTableValue.Columns["FactorValueID"].MinimumWidth = dgvTableValue.Columns["FactorValueID"].HeaderCell.Size.Width +
                                                            dgvTableValue.Columns["FactorValueID"].HeaderText.Length * 3;
      dgvTableValue.Columns["FactorValueID"].AutoSizeMode = DataGridViewAutoSizeColumnMode.AllCells;
      dgvTableValue.ColumnHeadersDefaultCellStyle.Alignment = DataGridViewContentAlignment.MiddleCenter;
      dgvTableValue.Columns["FactorValueID"].DefaultCellStyle.Alignment = DataGridViewContentAlignment.MiddleCenter;
// Настройка внешнего вида таблицы Rule
      dgvRule.Columns["ID"].Visible = false;
      dgvRule.Columns["TableValueID"].Visible = false;
      dgvRule.Columns["FactorID"].AutoSizeMode = DataGridViewAutoSizeColumnMode.AllCells;
      dgvRule.Columns["FactorValueID"].MinimumWidth = dgvRule.Columns["FactorValueID"].HeaderCell.Size.Width + 
                                                      dgvRule.Columns["FactorValueID"].HeaderText.Length * 3;
      dgvRule.Columns["FactorValueID"].AutoSizeMode = DataGridViewAutoSizeColumnMode.AllCells;
      dgvRule.ColumnHeadersDefaultCellStyle.Alignment = DataGridViewContentAlignment.MiddleCenter;
      dgvRule.Columns["FactorValueID"].DefaultCellStyle.Alignment = DataGridViewContentAlignment.MiddleCenter;
    }

    private void FillTables()
    {
      daFactor.Fill(ds.Tables["DicFactor"]);
      daValue.Fill(ds.Tables["DicFactorValue"]);
      daFactorValue.Fill(ds.Tables["FactorValue"]);
      daTable.Fill(ds.Tables["TableFactor"]);
      daTableValue.Fill(ds.Tables["TableValue"]);
      daRule.Fill(ds.Tables["Rule"]);
      TuningDgv();
    }

    private void MakeStructureTable()
    {
// Создание структуры таблицы DicFactor
      ds.Tables.Add("DicFactor");
      daFactor = new OleDbDataAdapter("SELECT * FROM tblDicFactor", cn);
      daFactor.FillSchema(ds.Tables["DicFactor"], SchemaType.Mapped);
// Создание структуры таблицы DicFactorValue
      ds.Tables.Add("DicFactorValue");
      daValue = new OleDbDataAdapter("SELECT * FROM tblDicFactorValue", cn);
      daValue.FillSchema(ds.Tables["DicFactorValue"], SchemaType.Mapped);
// Создание структуры таблицы FactorValue
      ds.Tables.Add("FactorValue");
      daFactorValue = new OleDbDataAdapter("SELECT * FROM tblFactorValue", cn);
      daFactorValue.FillSchema(ds.Tables["FactorValue"], SchemaType.Mapped);
// Создание структуры таблицы TableFactor
      ds.Tables.Add("TableFactor");
      daTable = new OleDbDataAdapter("SELECT * FROM tblTableFactor", cn);
      daTable.FillSchema(ds.Tables["TableFactor"], SchemaType.Mapped);
// Создание структуры таблицы TableValue
      ds.Tables.Add("TableValue");
      daTableValue = new OleDbDataAdapter("SELECT * FROM tblTableValue", cn);
      daTableValue.FillSchema(ds.Tables["TableValue"], SchemaType.Mapped);
// Создание структуры таблицы Rule
      ds.Tables.Add("Rule");
      daRule = new OleDbDataAdapter("SELECT * FROM tblRule", cn);
      daRule.FillSchema(ds.Tables["Rule"], SchemaType.Mapped);
    }

    private void MakeStructureDgv()
    {
      dgvFactorValue.AutoGenerateColumns = false;
      dgvTable.AutoGenerateColumns = false;
      dgvTableValue.AutoGenerateColumns = false;
      dgvRule.AutoGenerateColumns = false;
// Создание структуры dgvFactorValue
      dgvFactorValue.Columns.Add(new DataGridViewTextBoxColumn()
      {
        Name = "ID",
        HeaderText = "ID",
        DataPropertyName = "ID"
      });
      dgvFactorValue.Columns.Add(new DataGridViewTextBoxColumn()
      {
        Name = "FactorID",
        HeaderText = "FactorID",
        DataPropertyName = "FactorID"
      });
      dgvFactorValue.Columns.Add(new DataGridViewComboBoxColumn()
      {
        Name = "FactorValueID",
        HeaderText = "Значение",
        DataPropertyName = "FactorValueID",
        DataSource = ds.Tables["DicFactorValue"],
        DisplayMember = "FactorValue",
        ValueMember = "ID"
      });

// Создание структуры dgvTable
      dgvTable.Columns.Add(new DataGridViewTextBoxColumn()
      {
        Name = "ID",
        HeaderText = "ID",
        DataPropertyName = "ID"
      });
      dgvTable.Columns.Add(new DataGridViewTextBoxColumn()
      {
        Name = "TableName",
        HeaderText = "Таблица",
        DataPropertyName = "TableName"
      });
      dgvTable.Columns.Add(new DataGridViewComboBoxColumn()
      {
        Name = "FactorID",
        HeaderText = "Целевой фактор",
        DataPropertyName = "FactorID",
        DataSource = ds.Tables["DicFactor"],
        DisplayMember = "Factor",
        ValueMember = "ID"
      });
      dgvTable.Columns.Add(new DataGridViewTextBoxColumn()
      {
        Name = "TableMemo",
        HeaderText = "Примечание",
        DataPropertyName = "TableMemo",
      });
// Создание структуры dgvTableValue
      dgvTableValue.Columns.Add(new DataGridViewTextBoxColumn()
      {
        Name = "ID",
        HeaderText = "ID",
        DataPropertyName = "ID"
      });
      dgvTableValue.Columns.Add(new DataGridViewTextBoxColumn()
      {
        Name = "TableFactorID",
        HeaderText = "TableFactorID",
        DataPropertyName = "TableFactorID"
      });
      dgvTableValue.Columns.Add(new DataGridViewComboBoxColumn()
      {
        Name = "FactorValueID",
        HeaderText = "Значение целевого фактора",
        DataPropertyName = "FactorValueID",
        DataSource = ds.Tables["DicFactorValue"],
        DisplayMember = "FactorValue",
        ValueMember = "ID"
      });
      dgvTableValue.Columns.Add(new DataGridViewTextBoxColumn()
      {
        Name = "TableValueMemo",
        HeaderText = "Примечание",
        DataPropertyName = "TableValueMemo"
      });
      //    Создание структуры dgvRule
      dgvRule.Columns.Add(new DataGridViewTextBoxColumn()
      {
        Name = "ID",
        HeaderText = "ID",
        DataPropertyName = "ID"
      });
      dgvRule.Columns.Add(new DataGridViewTextBoxColumn()
      {
        Name = "TableValueID",
        HeaderText = "TableValueID",
        DataPropertyName = "TableValueID"
        //DataSource = ds.Tables["TableValue"],
        //DisplayMember = "ID", 
        //ValueMember = "ID"
      });
      dgvRule.Columns.Add(new DataGridViewComboBoxColumn()
      {
        Name = "FactorID",
        HeaderText = "Фактор",
        DataPropertyName = "FactorID", 
        DataSource = ds.Tables["DicFactor"],
        DisplayMember = "Factor", 
        ValueMember = "ID"
      });
      dgvRule.Columns.Add(new DataGridViewComboBoxColumn()
      {
        Name = "FactorValueID",
        HeaderText = "Значение фактора",
        DataPropertyName = "FactorValueID",
        DataSource = ds.Tables["DicFactorValue"],
        DisplayMember = "FactorValue",
        ValueMember = "ID"
      });
      dgvRule.Columns.Add(new DataGridViewTextBoxColumn()
      {
        Name = "RuleMemo",
        HeaderText = "Примечание",
        DataPropertyName = "RuleMemo"
      });
      dgvFactor.DataSource = ds;
      dgvFactor.DataMember = ds.Tables["DicFactor"].TableName;
      dgvValue.DataSource = ds;
      dgvValue.DataMember = ds.Tables["DicFactorValue"].TableName;
// Настройка названий столбцов
      dgvFactor.Columns["Factor"].HeaderText = "Фактор";
      dgvFactor.Columns["FactorNum"].HeaderText = "Номер фактора";
      dgvFactor.Columns["FactorMemo"].HeaderText = "Примечание";
      dgvValue.Columns["FactorValue"].HeaderText = "Значение";
      dgvValue.Columns["FactorValueNum"].HeaderText = "Номер значения";
      dgvValue.Columns["FactorValueMemo"].HeaderText = "Примечание";
    }

    private void MakeRelation()  //Создание отношений между таблицами 
    {
      DataRelation drFactorValue = new DataRelation("RelFactorValue", ds.Tables["DicFactor"].Columns["ID"],
                                                    ds.Tables["FactorValue"].Columns["FactorID"]);
      ds.Relations.Add(drFactorValue);
      DataRelation drTableValue = new DataRelation("RelTableValue", ds.Tables["TableFactor"].Columns["ID"],
                                                    ds.Tables["TableValue"].Columns["TableFactorID"]);
      ds.Relations.Add(drTableValue);
      DataRelation drValueRule = new DataRelation("RelTableValueRule", ds.Tables["TableValue"].Columns["ID"],
                                                   ds.Tables["Rule"].Columns["TableValueID"]);
      ds.Relations.Add(drValueRule);
// Формирование связи таблиц
      dgvFactor.DataSource = bsFactor;
      bsFactor.DataSource  = ds;
      bsFactor.DataMember  = ds.Tables["DicFactor"].TableName;
// -------------------------------------------------------
      dgvFactorValue.DataSource = bsFactorValue;
      bsFactorValue.DataSource  = bsFactor;
      bsFactorValue.DataMember       = ds.Relations["RelFactorValue"].RelationName;
// -------------------------------------------------------
      dgvTable.DataSource = bsTable;
      bsTable.DataSource  = ds;
      bsTable.DataMember  = ds.Tables["TableFactor"].TableName;
// -------------------------------------------------------
      dgvTableValue.DataSource = bsTableValue;
      bsTableValue.DataSource  = bsTable;
      bsTableValue.DataMember  = ds.Relations["RelTableValue"].RelationName;
// -------------------------------------------------------
      dgvRule.DataSource  = bsRule;
      bsRule.DataSource = bsTableValue;
      bsRule.DataMember = ds.Relations["RelTableValueRule"].RelationName;
    }

    private void FormMain_Load(object sender, EventArgs e)
    {
      DBcon("EsTest.mdb");
      MakeStructureTable();
      MakeStructureDgv();
      MakeRelation();
// Формирование команд Insert, Update, Delete с помощью OleDbCommandBuilder
      OleDbCommandBuilder cmdFactor      = new OleDbCommandBuilder(daFactor);
      OleDbCommandBuilder cmdFactorValue = new OleDbCommandBuilder(daFactorValue);
      OleDbCommandBuilder cmdValue       = new OleDbCommandBuilder(daValue);
      OleDbCommandBuilder cmdTable       = new OleDbCommandBuilder(daTable);
      OleDbCommandBuilder cmdTableValue  = new OleDbCommandBuilder(daTableValue);
      OleDbCommandBuilder cmdRule        = new OleDbCommandBuilder(daRule);
      FillTables(); // Заполнение таблиц
      ds.Dispose();
      cn.Close();
    }

    private void btnRefresh_Click(object sender, EventArgs e)
    {
      ds.Clear();
      FillTables();
    }

    private void FormMain_FormClosing(object sender, FormClosingEventArgs e)
    {
      if (ds.HasChanges())
      {
        DialogResult result = MessageBox.Show("Сохранить?", "Данные были изменены!", MessageBoxButtons.YesNoCancel,
                                               MessageBoxIcon.Information);
        switch (result)
        {
          case System.Windows.Forms.DialogResult.Yes:
            if (ds.Tables["DicFactor"].GetChanges() != null)
              daFactor.Update(ds.Tables["DicFactor"]);
            if (ds.Tables["DicFactorValue"].GetChanges() != null)
              daValue.Update(ds.Tables["DicFactorValue"]);
            if (ds.Tables["FactorValue"].GetChanges() != null)
              daFactorValue.Update(ds.Tables["FactorValue"]);
            if (ds.Tables["TableFactor"].GetChanges() != null)
              daTable.Update(ds.Tables["TableFactor"]);
            if (ds.Tables["TableValue"].GetChanges() != null)
              daTableValue.Update(ds.Tables["TableValue"]);
            if (ds.Tables["Rule"].GetChanges() != null)
              daRule.Update(ds.Tables["Rule"]);
            break;
          case System.Windows.Forms.DialogResult.No:
            Environment.Exit(1);
            break;
          case System.Windows.Forms.DialogResult.Cancel:
            e.Cancel = true;
            break;
        }
      } 
    }

    private void btnSaveDict_Click(object sender, EventArgs e)
    {
      if (ds.HasChanges())
      {
        if (ds.Tables["DicFactor"].GetChanges() != null)
          daFactor.Update(ds.Tables["DicFactor"]);
        if (ds.Tables["DicFactorValue"].GetChanges() != null)
          daValue.Update(ds.Tables["DicFactorValue"]);
        if (ds.Tables["FactorValue"].GetChanges() != null)
          daFactorValue.Update(ds.Tables["FactorValue"]);
      }
    }

    private void btnSaveRel_Click(object sender, EventArgs e)
    {
      if (ds.HasChanges())
      {
        if (ds.Tables["TableFactor"].GetChanges() != null)
        {
          daTable.Update(ds.Tables["TableFactor"]);
        }
        if (ds.Tables["TableValue"].GetChanges() != null)
          daTableValue.Update(ds.Tables["TableValue"]);
        if (ds.Tables["Rule"].GetChanges() != null)
          daRule.Update(ds.Tables["Rule"]);
      }
    }

    private void btnRefreshRel_Click(object sender, EventArgs e)
    {
      btnRefresh_Click(sender, EventArgs.Empty);
    }
 
  } //class
} // namespace
