!include "MUI2.nsh"
;!include "VPatchLib.nsh"
!include "Logiclib.nsh"
!include "WinVer2.nsh"
!include "ProcessFunc.nsh"
SetCompressor /SOLID lzma
!define MUI_LANGDLL_REGISTRY_ROOT "HKLM"
!define MUI_LANGDLL_REGISTRY_KEY "Software\Example\Option"
!define MUI_LANGDLL_REGISTRY_VALUENAME "InstallerLanguage"
!define MUI_ABORTWARNING
!define MUI_CUSTOMFUNCTION_GUIINIT MUIGUIInit
!define SWP_SHOWWINDOW 0x00000040
!define MUI_PAGE_CUSTOMFUNCTION_LEAVE ComponentsLeave
!define MUI_COMPONENTSPAGE_SMALLDESC
!insertmacro MUI_PAGE_COMPONENTS
Page custom CustomInfo
!insertmacro MUI_PAGE_INSTFILES
;-----------------------------------------------------
!insertmacro MUI_UNPAGE_CONFIRM
!insertmacro MUI_UNPAGE_INSTFILES

!insertmacro MUI_LANGUAGE "Russian"
!insertmacro MUI_LANGUAGE "Ukrainian"
;--------------------------------------------------------------------
Function un.onInit
!insertmacro MUI_UNGETLANGUAGE
FunctionEnd
;--------------------------------------------------------------------
Caption "Example"
OutFile "example.exe"
RequestExecutionLevel admin
;-------------------------------------------------------
!insertmacro MUI_RESERVEFILE_LANGDLL
;--------------------------------
Section /o "$(PROGRUS)" SecRUS
  SetOutPath $INSTDIR
    CreateDirectory "$INSTDIR\Backup"
    ;!insertmacro VPatchFile
SectionEnd
Section /o "$(PROGUKR)" SecUKR
  SetOutPath $INSTDIR
     CreateDirectory "$INSTDIR\Backup"
     ;!insertmacro VPatchFile
SectionEnd
Section /o "$(PROGRUS64)" SecRUS64
  SetOutPath $INSTDIR
     CreateDirectory "$INSTDIR\Backup"
    ;!insertmacro VPatchFile
SectionEnd
Section /o "$(PROGUKR64)" SecUKR64
   SetOutPath $INSTDIR
    CreateDirectory "$INSTDIR\Backup"
    ;!insertmacro VPatchFile
SectionEnd
Section "-Post"
   WriteUninstaller "$INSTDIR\Uninstall.exe"
   SetAutoClose false
SectionEnd
;--------------------------------
Function .OnInit
!insertmacro MUI_LANGDLL_DISPLAY
;  "": ,  
   ${WinName} $1
   ${WinType} $2
   ${WinServerName} $3
   ${WinServicePack} $4
   ${WinPlatformArchitecture} $5
   StrCpy $6 "$1 $2 $3 $4 (x$5)"
   Var /Global text5
   StrCpy $text5 "$6" ;   -   
;       
   Var /Global IsWow64Process
   System::Call kernel32::GetCurrentProcess()i.s
   System::Call kernel32::IsWow64Process(is,*i.s)
   Pop $IsWow64Process
   StrCmp $IsWow64Process "1" 0 +3
   call Is64Bit
   goto +2
   call Is32Bit
FunctionEnd
;---------------------------------------------------------
Function MUIGUIInit
;  CRC exe-    
   CRCCheck::GenCRC "$INSTDIR\WinSnap64.exe"
   Pop $R1
   CRCCheck::GenCRC "$INSTDIR\WinSnap.exe"
   Pop $R2
   StrCpy $1 $R1
   StrCpy $2 $R2
; ,  :   .
##  
FunctionEnd
;---------------------------------------------------------------
Function Is64Bit
;  ,   64 
  SectionSetText ${SecRUS} ""
  SectionSetText ${SecUKR} ""
FunctionEnd
Function Is32Bit
;  ,   32 
  SectionSetText ${SecRUS64} ""
  SectionSetText ${SecUKR64} ""
FunctionEnd
;-----------------------------------------------------------------
Function .onSelChange
;      4
  !insertmacro StartRadioButtons $1
    !insertmacro RadioButton ${SecRUS}
    !insertmacro RadioButton ${SecUKR}
    !insertmacro RadioButton ${SecRUS64}
    !insertmacro RadioButton ${SecUKR64}
  !insertmacro EndRadioButtons
FunctionEnd
;-----------------------------------------------------------------------
Function ComponentsLeave
;    - ,  
${IfNot} ${SectionIsSelected} ${SecRUS}
${AndIfNot} ${SectionIsSelected} ${SecUKR}
${AndIfNot} ${SectionIsSelected} ${SecRUS64}
${AndIfNot} ${SectionIsSelected} ${SecUKR64}
  MessageBox MB_OK "$(not_component)" ;     
  Abort
${EndIf}
;      ;    ,   
  SectionGetFlags ${SecRUS} $0
  SectionGetFlags ${SecUKR} $1
  SectionGetFlags ${SecRUS64} $2
  SectionGetFlags ${SecUKR64} $3
Var /Global text_lang
    StrCmp $0 "1" +2 0
    StrCmp $2 "1" 0 +3
           StrCpy $4 "$(lang_rus)"
           StrCpy $text_lang "$4"
    StrCmp $1 "1" +2 0
    StrCmp $3 "1" 0 +3
           StrCpy $4 "$(lang_ukr)"
           StrCpy $text_lang "$4"
FunctionEnd

Function CustomInfo
!insertmacro MUI_HEADER_TEXT $(confirm_select) $(confirm_select_subtitle)
  InitPluginsDir
  File /oname=$PLUGINSDIR\msg.ini "msg.ini"
  WriteINIStr $PLUGINSDIR\msg.ini "Field 1" "Text" "$(text1)"
  WriteINIStr $PLUGINSDIR\msg.ini "Field 2" "Text" "$(text2)"
  WriteINIStr $PLUGINSDIR\msg.ini "Field 4" "Text" "$(text4)"
  WriteINIStr $PLUGINSDIR\msg.ini "Field 5" "Text" "$text5"
  WriteINIStr $PLUGINSDIR\msg.ini "Field 6" "Text" "$(text6)"
  WriteINIStr $PLUGINSDIR\msg.ini "Field 7" "Text" "$INSTDIR"
  WriteINIStr $PLUGINSDIR\msg.ini "Field 8" "Text" "$(text8)"
  WriteINIStr $PLUGINSDIR\msg.ini "Field 9" "Text" "$(text9)"
  WriteINIStr $PLUGINSDIR\msg.ini "Field 10" "Text" "$text_lang"
  
InstallOptions::initDialog /NOUNLOAD "$PLUGINSDIR\msg.ini"
InstallOptions::show
FunctionEnd
;-----------------------------------------
;  () 
Section "un.install" ;SecUN
   delete "$INSTDIR\WinSnap64.exe"
   delete "$INSTDIR\WinSnap.exe"
   Rename $INSTDIR\Backup\WinSnap64.exe.bak $INSTDIR\WinSnap64.exe
   Rename $INSTDIR\Backup\WinSnap.exe.bak $INSTDIR\WinSnap.exe
   delete "$INSTDIR\Uninstall.exe"
   DeleteRegKey HKLM "Software\Alexander Avdonin\WinSnap\Option"
   RMDir /r "$INSTDIR\Backup"
   SetAutoClose false
SectionEnd
;----------------------------------------------------------------
LangString text2 ${LANG_RUSSIAN} "     :"
LangString text2 ${LANG_UKRAINIAN} "     :"
LangString text9 ${LANG_RUSSIAN} "  WinSnap:"
LangString text9 ${LANG_UKRAINIAN} "  WinSnap:"
LangString lang_rus ${LANG_RUSSIAN} " "
LangString lang_rus ${LANG_UKRAINIAN} " "
LangString lang_ukr ${LANG_RUSSIAN} " "
LangString lang_ukr ${LANG_UKRAINIAN} " "
LangString text4 ${LANG_RUSSIAN} " :"
LangString text4 ${LANG_UKRAINIAN} " :"
LangString text6 ${LANG_RUSSIAN} "  :"
LangString text6 ${LANG_UKRAINIAN} " :"
LangString confirm_select ${LANG_RUSSIAN} " !"
LangString confirm_select ${LANG_UKRAINIAN} "ϳ !"
LangString confirm_select_subtitle ${LANG_RUSSIAN} "    "
LangString confirm_select_subtitle ${LANG_UKRAINIAN} "    "
;  ,     
LangString not_component ${LANG_RUSSIAN} "      !"
LangString not_component ${LANG_UKRAINIAN} " ,     !"
;    (, )
LangString PROGRUS ${LANG_RUSSIAN} "  (x86)"
LangString PROGRUS ${LANG_UKRAINIAN} "  (x86)"
LangString PROGUKR ${LANG_RUSSIAN} "  (x86)"
LangString PROGUKR ${LANG_UKRAINIAN} "  (x86)"
LangString PROGRUS64 ${LANG_RUSSIAN} "  (x64)"
LangString PROGRUS64 ${LANG_UKRAINIAN} "  (x64)"
LangString PROGUKR64 ${LANG_RUSSIAN} "  (x64)"
LangString PROGUKR64 ${LANG_UKRAINIAN} "  (x64)"