program IfDVD;

uses SysUtils, Windows;

{$R *.res}

const
  FILE_DEVICE_DVD = $00000033;
  IOCTL_STORAGE_GET_MEDIA_TYPES_EX = $002d0c04;

type
  TGetMediaTypes = packed record
    DeviceType : ULONG;
    Buffer     : Array [1..2044] of Byte;  //   ;
  end;

function DVDPresent: Boolean;
var
  hDevice: THandle;
  MediaTypes: TGetMediaTypes;
  dwDrives, dwSize: DWORD;
  I: Integer;
  Drive: Char;

procedure RaiseSysErr;
var
  S: string;
begin
  S := SysErrorMessage(GetLastError);

  if Drive <> #0 then
    S := Drive + ': ' + S;

  raise Exception.Create(S);
end;

begin
  Result := False;
  Drive := #0;

  dwDrives := GetLogicalDrives;
  if dwDrives = 0 Then RaiseSysErr;

  for I := 0 to 25 do
    if (dwDrives and (1 shl I)) > 0 then begin
      Drive := Chr(I + Ord('A'));

      if GetDriveType(PChar(Drive + ':\')) = DRIVE_CDROM then begin
        hDevice := CreateFile(PChar('\\.\' + Drive + ':'),
                     GENERIC_READ or GENERIC_WRITE,
                     FILE_SHARE_READ or FILE_SHARE_WRITE, nil,
                     OPEN_EXISTING, 0, 0);

        if hDevice = INVALID_HANDLE_VALUE then
          RaiseSysErr;

        try
          if DeviceIoControl(hDevice, IOCTL_STORAGE_GET_MEDIA_TYPES_EX,
               nil, 0, @MediaTypes, SizeOf(TGetMediaTypes), dwSize, nil) then

            if MediaTypes.DeviceType = FILE_DEVICE_DVD then begin
              Result := True;
              Exit;
            end;

        finally
          CloseHandle(hDevice);
        end;
      end;
    end;
end;

function RunAppAndWait(const CommandLine: string; HideWindow: Boolean = False): Boolean;
var
  PI: TProcessInformation;
  SI: TStartupInfo;
  TargetName: TFileName;

begin
  FillChar(SI, SizeOf(SI), 0);
  SI.cb := SizeOf(SI);

  if HideWindow then begin
    SI.dwFlags := STARTF_USESHOWWINDOW;
    SI.wShowWindow := SW_HIDE;
  end;

  TargetName := CommandLine;
  Result := CreateProcess(nil, PChar(TargetName),
              nil, nil, False, 0, nil, nil, SI, PI);

  if Result then try
    WaitForSingleObject(PI.hProcess, INFINITE);

  finally
    CloseHandle(PI.hProcess);
    CloseHandle(PI.hThread);
  end;
end;

function CheckQ(const S: string): string;
begin
  if Pos(' ', S) > 0 then
    Result := '"' + S + '"'
  else
    Result := S;
end;

procedure Main;
var
  I, First, Last: Integer;
  Hide: Boolean;
  Param: string;

begin
  if not DVDPresent then Exit;

  First := 1;
  Last := ParamCount;
  Hide := False;

  if Last > 0 then begin
    Param := ParamStr(1);
    if (Param = '/h') or (Param = '/H') or
       (Param = '-h') or (Param = '-H') then begin

      Hide := True;
      First := 2;
    end;
  end;

  if Last < First then Exit;

  Param := CheckQ(ParamStr(First));
  for I := First + 1 to Last do
    Param := Param + ' ' + CheckQ(ParamStr(I));

  if not RunAppAndWait(Param, Hide) then
    raise Exception.Create(SysErrorMessage(GetLastError) + ' '#13 + Param);
end;

begin
  try
    Main;

  except on E: Exception do
    MessageBox(0, PChar(E.Message + ' '), 'IfDVD', MB_ICONERROR);
  end;
end.
