format PE64 Console
include '%fasm%\win64ax.inc'
section '.code' executable
start:
	sub rsp, 8*5

	invoke GetCommandLine
	mov [icl],eax

	invoke ExpandEnvironmentStrings,'%WinDir%\Microsoft.NET\Framework64\v3.5\vbc.exe',lpFile,MAX_PATH

	mov dword [sinfo.cb],sinfo
	mov dword [sinfo.dwFlags],STARTF_USESTDHANDLES

	invoke GetStdHandle,STD_INPUT_HANDLE
	mov dword [sinfo.hStdInput],eax

	invoke GetStdHandle,STD_OUTPUT_HANDLE
	mov dword [sinfo.hStdOutput],eax

	invoke CreateProcess,lpFile,[icl],NULL,NULL,DETACHED_PROCESS,NORMAL_PRIORITY_CLASS,NULL,NULL,sinfo,pinfo
	cmp eax,NULL
	je exit

	invoke WaitForSingleObject,[pinfo.hProcess],0xffffffff
exit:
	invoke CloseHandle,[sinfo.hStdInput]
	invoke CloseHandle,[sinfo.hStdOutput]
	invoke ExitProcess,NULL

section '.data' readable writable

	lpFile dd MAX_PATH dup NULL
	icl dd MAX_PATH dup NULL

	pinfo PROCESS_INFORMATION
	sinfo STARTUPINFO

section '.idata' import readable

	library kernel32,'KERNEL32.DLL'
	include '%fasm%\api\kernel32.inc'

section '.rsrc' resource readable

	directory RT_ICON,icons,RT_GROUP_ICON,group_icons,RT_VERSION,versions

	resource icons,\
	1,LANG_NEUTRAL,icon_data1,\
	2,LANG_NEUTRAL,icon_data2,\
	3,LANG_NEUTRAL,icon_data3,\
	4,LANG_NEUTRAL,icon_data4

	resource group_icons,1,LANG_NEUTRAL,main_icon
	resource versions,1,LANG_NEUTRAL,version

	icon main_icon,\
	icon_data1,'%fasm%\exec1.ico',\
	icon_data2,'%fasm%\exec2.ico',\
	icon_data3,'%fasm%\exec3.ico',\
	icon_data4,'%fasm%\exec4.ico'

	versioninfo version,VOS__WINDOWS32,VFT_APP,VFT2_UNKNOWN,LANG_ENGLISH+SUBLANG_DEFAULT,NULL,\
		    'FileDescription','vbc.exe',\
		    'LegalCopyright','2001-2005 GmbH',\
		    'FileVersion','9.0.30729.1',\
		    'ProductVersion','9.0.30729.1',\
		    'OriginalFilename','vbc.exe',\
		    'Company','Semiono'
