program FakeSetup;

uses
  Windows,  SysUtils,  ShellApi;

{$R *.res}

var
  filename : string = 'fakelog.txt' ;

function ExpandEnvString(EnvString: string): string; forward;  
{******************************************************************************}
function GetTempDir:string;
var
 Tmp : PChar;
begin
 GetMem(Tmp,MAX_PATH);
 try
  ZeroMemory(Tmp,MAX_PATH);
  GetTempPath(MAX_PATH,Tmp);
  Result :=  StrPas (Tmp);
 finally
  FreeMem(Tmp,MAX_PATH);
 end;
end;
{******************************************************************************}
procedure RunAndWait(CmdLn,Param:string; Mode:Integer);
var
  SeeInfo: TShellExecuteInfo;
begin
  SeeInfo.cbSize:= SizeOf(TShellExecuteInfo);
  SeeInfo.fMask:= SEE_MASK_NOCLOSEPROCESS or SEE_MASK_FLAG_NO_UI or SEE_MASK_DOENVSUBST;
  SeeInfo.Wnd:= 0;
  SeeInfo.lpVerb:= 'Open';
  SeeInfo.lpFile:= PChar(CmdLn);
  SeeInfo.lpParameters:=PChar(Param);
  SeeInfo.lpDirectory:='.';
  SeeInfo.nShow:= Mode;
  ShellExecuteEx(@SeeInfo);
  WaitForSingleObject(SeeInfo.hProcess,INFINITE);
end;
{******************************************************************************}
function GetCmdParam:string;
var i:integer;
begin
 Result:='';
 for i := 1 to ParamCount do Result:= Result + ' ' +ParamStr(i);
end;
{******************************************************************************}
function ExpandEnvString(EnvString: string): string;
var Sz: integer;
begin
  Result := '';
  Sz := ExpandEnvironmentStrings(PChar(EnvString), nil, 0);
  SetLength(Result, Sz);
  Sz := ExpandEnvironmentStrings(PChar(EnvString), PChar(Result), Sz);
  SetLength(Result, Sz - 1);
end;
{******************************************************************************}
procedure WriteLog (str:string);
var
  f : TextFile ;
  tmpFileName, tmpStr : String;
begin
  tmpFileName := IncludeTrailingPathDelimiter(GetTempDir)+filename;

  If not (FileExists(tmpFileName )) then
  begin
    AssignFile ( f, tmpFileName );
    Rewrite ( f ) ;
    CloseFile ( f ) ;
  end ;
  AssignFile ( f, tmpFileName );
  Append ( f ) ;
  tmpStr := DatetimeToStr(Now);
  if str = '' then tmpStr := '';
  Writeln ( f, tmpStr , ' ', str ) ;
  CloseFile ( f ) ;
end;
{******************************************************************************}
var
  PresetupPatch : String;
begin
 try
   WriteLog('');
   WriteLog('');
   WriteLog('EVENT: Fake setup started.');
   presetupPatch := IncludeTrailingPathDelimiter(ExpandEnvString('%systemroot%'))+'system32\presetup.cmd';
   WriteLog(presetupPatch);
   if FileExists(presetupPatch) then
   begin
     RunAndWait(PresetupPatch,'', SW_HIDE) ;
     WriteLog('EVENT: presetup.cmd executed.');
     DeleteFile(PresetupPatch) ;
     WriteLog('EVENT: presetup.cmd deleted.');
   end
   else
     WriteLog('ERROR: presetup.cmd not found.');
   presetupPatch := ExtractFilePath(ParamStr(0));
   if FileExists(presetupPatch +'setup.org') then
   begin
     if FileExists(PresetupPatch+'setup.old') then DeleteFile(PresetupPatch+'setup.old');
     if not MoveFile(PChar(ParamStr(0)),PChar(presetupPatch +'setup.old')) then
     begin
       MessageBox(GetFocus,'ERROR: Fake setup cannot be self-renamed.','Fake Setup',MB_OK or MB_ICONERROR or MB_TASKMODAL or MB_TOPMOST or MB_SETFOREGROUND);
       WriteLog('ERROR: Fake setup cannot be self-renamed.');
       WriteLog('FATAL: Windows setup stopped.');
       exit;
     end;
     WriteLog('EVENT: Fake setup self rename to setup.old.');
     if not MoveFile(PChar(presetupPatch+'setup.org'), PChar({ExtractFilePath(}ParamStr(0){)+'setup.exe'})) then
     begin
       MessageBox(GetFocus,'ERROR: Fake setup cannot rename setup.org to setup.exe.','Fake Setup',MB_OK or MB_ICONERROR or MB_TASKMODAL);
       WriteLog('ERROR: Fake setup cannot rename setup.org to setup.exe.');
       WriteLog('FATAL: Windows setup stopped.');
       exit;
     end;
     WriteLog('EVENT: Fake setup rename setup.org to setup.exe.');
     RunAndWait(PresetupPatch {ExtractFilePath(ParamStr(0))}+'setup.exe',GetCmdParam,SW_SHOW);
     WriteLog('EVENT: Original setup.exe finished.');
   end
   else begin
     MessageBox(GetFocus,Pchar('ERROR: Setup.org (original windows setup) not found.('+presetupPatch+')'),'Fake Setup',MB_OK or MB_ICONERROR or MB_TASKMODAL);
     WriteLog('ERROR: Setup.org (original windows setup) not found.');
     WriteLog('FATAL: Windows setup stopped.');
   end;
 finally
   WriteLog('EVENT: Fake setup finished.');
 end;
end.
