unit CrcTools;

interface

uses
  Windows, Classes, SysUtils;

const

  IMAGE_SIZEOF_SHORT_NAME          = 8;
  IMAGE_SIZEOF_SECTION_HEADER      = 40;
  IMAGE_NUMBEROF_DIRECTORY_ENTRIES = 16;
  IMAGE_RESOURCE_NAME_IS_STRING    = $80000000;
  IMAGE_RESOURCE_DATA_IS_DIRECTORY = $80000000;
  IMAGE_OFFSET_STRIP_HIGH          = $7FFFFFFF;

  MAGE_DOS_SIGNATURE    = $5A4D;       { MZ }
  IMAGE_OS2_SIGNATURE    = $454E;       { NE }
  IMAGE_OS2_SIGNATURE_LE = $454C;       { LE }
  IMAGE_VXD_SIGNATURE    = $454C;       { LE }
  IMAGE_NT_SIGNATURE     = $00004550;   { PE00 }

  PE_SIGNATURE_VS = $00905A4D;
  PE_SIGNATURE_DE = $00505A4D;


type
  PIMAGE_DOS_HEADER = ^IMAGE_DOS_HEADER;
  IMAGE_DOS_HEADER = packed record      { DOS .EXE header }
    e_magic         : WORD;             { Magic number }
    e_cblp          : WORD;             { Bytes on last page of file }
    e_cp            : WORD;             { Pages in file }
    e_crlc          : WORD;             { Relocations }
    e_cparhdr       : WORD;             { Size of header in paragraphs }
    e_minalloc      : WORD;             { Minimum extra paragraphs needed }
    e_maxalloc      : WORD;             { Maximum extra paragraphs needed }
    e_ss            : WORD;             { Initial (relative) SS value }
    e_sp            : WORD;             { Initial SP value }
    e_csum          : WORD;             { Checksum }
    e_ip            : WORD;             { Initial IP value }
    e_cs            : WORD;             { Initial (relative) CS value }
    e_lfarlc        : WORD;             { File address of relocation table }
    e_ovno          : WORD;             { Overlay number }
    e_res           : packed array [0..3] of WORD; { Reserved words }
    e_oemid         : WORD;             { OEM identifier (for e_oeminfo) }
    e_oeminfo       : WORD;             { OEM information; e_oemid specific }
    e_res2          : packed array [0..9] of WORD; { Reserved words }
    e_lfanew        : Longint;          { File address of new exe header }
  end;

  
  PIMAGE_FILE_HEADER = ^IMAGE_FILE_HEADER;
  IMAGE_FILE_HEADER = packed record
    Machine              : WORD;
    NumberOfSections     : WORD;
    TimeDateStamp        : DWORD;
    PointerToSymbolTable : DWORD;
    NumberOfSymbols      : DWORD;
    SizeOfOptionalHeader : WORD;
    Characteristics      : WORD;
  end;


  PIMAGE_DATA_DIRECTORY = ^IMAGE_DATA_DIRECTORY;
  IMAGE_DATA_DIRECTORY = packed record
    VirtualAddress  : DWORD;
    Size            : DWORD;
  end;

  PIMAGE_OPTIONAL_HEADER = ^IMAGE_OPTIONAL_HEADER;
  IMAGE_OPTIONAL_HEADER = packed record
   { Standard fields. }
    Magic           : WORD;
    MajorLinkerVersion : Byte;
    MinorLinkerVersion : Byte;
    SizeOfCode      : DWORD;
    SizeOfInitializedData : DWORD;
    SizeOfUninitializedData : DWORD;
    AddressOfEntryPoint : DWORD;
    BaseOfCode      : DWORD;
    BaseOfData      : DWORD;
   { NT additional fields. }
    ImageBase       : DWORD;
    SectionAlignment : DWORD;
    FileAlignment   : DWORD;
    MajorOperatingSystemVersion : WORD;
    MinorOperatingSystemVersion : WORD;
    MajorImageVersion : WORD;
    MinorImageVersion : WORD;
    MajorSubsystemVersion : WORD;
    MinorSubsystemVersion : WORD;
    Reserved1       : DWORD;
    SizeOfImage     : DWORD;
    SizeOfHeaders   : DWORD;
    CheckSum        : DWORD; // File checksum tested with MapFileAndCheckSum
    Subsystem       : WORD;
    DllCharacteristics : WORD;
    SizeOfStackReserve : DWORD;
    SizeOfStackCommit : DWORD;
    SizeOfHeapReserve : DWORD;
    SizeOfHeapCommit : DWORD;
    LoaderFlags     : DWORD;
    NumberOfRvaAndSizes : DWORD;
    DataDirectory   : packed array [0..IMAGE_NUMBEROF_DIRECTORY_ENTRIES-1] of IMAGE_DATA_DIRECTORY;
  end;

  PIMAGE_SECTION_HEADER = ^IMAGE_SECTION_HEADER;
  IMAGE_SECTION_HEADER = packed record
    Name            : packed array [0..IMAGE_SIZEOF_SHORT_NAME-1] of Char;
    PhysicalAddress : DWORD; // or VirtualSize (union);
    VirtualAddress  : DWORD;
    SizeOfRawData   : DWORD;
    PointerToRawData : DWORD;
    PointerToRelocations : DWORD;
    PointerToLinenumbers : DWORD;
    NumberOfRelocations : WORD;
    NumberOfLinenumbers : WORD;
    Characteristics : DWORD;
  end;

  PIMAGE_NT_HEADERS = ^IMAGE_NT_HEADERS;
  IMAGE_NT_HEADERS = packed record
    Signature       : DWORD;
    FileHeader      : IMAGE_FILE_HEADER;
    OptionalHeader  : IMAGE_OPTIONAL_HEADER;
  end;



 function  CheckPe(FileName:string):boolean;
 function  GetOffset(FileName:string; dwVirtualAddress:DWord):DWord;
 
 function  CorrectFileChecSumm(FileName:string):boolean;
 function  CorrectLdrChecSumm(FileName:string):boolean;

implementation


function MapFileAndCheckSum(Filename: PChar; // File to get checksum
                            var HeaderSum,   // Checksum read from PE file header. For Delphi compiled programs it is always 0
                            CheckSum: DWORD  // Calculated checksum
                            ): DWORD;        // 0 if success
  stdcall; external 'Imagehlp.dll' name 'MapFileAndCheckSumA';




function CheckSumMappedFile(BaseAddress:pointer;
                            FileLength:DWORD;
                            var HeaderSum;      // Checksum read from PE file header. For Delphi compiled programs it is always 0
                            var CheckSum: DWORD // Calculated checksum
                            ):PIMAGE_NT_HEADERS;
 stdcall; external 'Imagehlp.dll' name 'CheckSumMappedFile';





function CheckPe(FileName:string):boolean;
var
    f:file;
    DosHdr:Image_Dos_Header;
    NtHdr:Image_nt_Headers;
begin
result:=false;;
assignfile(f,FileName);
try
 try
  Reset(f,1);
  BlockRead(f,DosHdr,sizeof(DosHdr));
  if DosHdr.e_lfanew < sizeof(DosHdr) then exit;
  if DosHdr.e_magic <> IMAGE_DOS_SIGNATURE then exit;
  Seek(f,DosHdr.e_lfanew);
  BlockRead(f,NtHdr,sizeof(NtHdr));
  if NtHdr.Signature <> IMAGE_NT_SIGNATURE then exit;
  result:=true;
 except
  result:=false;
 end;
 finally
  Closefile(f);
 end;
end;


function GetOffset(FileName:string; dwVirtualAddress:DWord):DWord;
var
    f:file;
    DosHdr:Image_Dos_Header;
    NtHdr:Image_nt_Headers;
    I: integer;
    dwAlignment: DWord;
	  dwFirstSectionOffset: DWord;
    dwFileOffset: DWord;
    dwImageBase:DWord;
    dwSectionBaseAddress: DWord;
    dwAddressFileOffset: DWord;
    dwSectionSize: DWord;
    Section: IMAGE_SECTION_HEADER;

begin
result:=0;
assignfile(f,FileName);
try
 try
 Reset(f,1);
 BlockRead(f,DosHdr,sizeof(DosHdr));
 if DosHdr.e_lfanew < sizeof(DosHdr) then exit;
 if DosHdr.e_magic <> IMAGE_DOS_SIGNATURE then exit;
 Seek(f,DosHdr.e_lfanew);
 BlockRead(f,NtHdr,sizeof(NtHdr));
 if NtHdr.Signature <> IMAGE_NT_SIGNATURE then exit;
 dwImageBase:= NtHdr.OptionalHeader.ImageBase;
 dwAlignment:= NtHdr.OptionalHeader.FileAlignment-1;
 dwFirstSectionOffset:= DosHdr.e_lfanew +
								        sizeof(NtHdr) -
								        sizeof(NtHdr.OptionalHeader) +
								        NtHdr.FileHeader.SizeOfOptionalHeader;
 dwFileOffset := dwFirstSectionOffset +
                 sizeof(IMAGE_SECTION_HEADER) * NtHdr.FileHeader.NumberOfSections +
						     dwAlignment;
 dwFileOffset:= dwFileOffset and ( not dwAlignment);
 Seek(f,dwFirstSectionOffset);
 for I := 0 to NtHdr.FileHeader.NumberOfSections - 1 do  begin
   BlockRead(f,Section,sizeof(Section));
   dwSectionBaseAddress := NtHdr.OptionalHeader.ImageBase + Section.VirtualAddress;
   if (dwSectionBaseAddress <= dwVirtualAddress) and
			(dwSectionBaseAddress + Section.PhysicalAddress > dwVirtualAddress) then begin
        dwAddressFileOffset := dwFileOffset + (dwVirtualAddress - dwSectionBaseAddress);
        if( dwAddressFileOffset > section.SizeOfRawData )then exit else begin
         result:=dwAddressFileOffset;
         exit;
        end;
      end;
   dwSectionSize:=Section.SizeOfRawData + dwAlignment;
   dwSectionSize:= dwSectionSize and (not dwAlignment);
   dwFileOffset:= dwFileOffset + dwSectionSize;
 end;
 except
  Result:=0;
 end;
 finally
  Closefile(f);
 end;
end;


function CorrectFileChecSumm(FileName:string):boolean;

var

 hFile: THandle ;
 hFileMapping: THandle;
 pBaseAddress: pointer;
 dwFileLengtH: DWORD;
 dwFileLengtL: DWORD;
 dwHeaderSum: DWORD; // Checksum as stated by Header
 dwCheckSum: DWORD; // Calculated Checksum
 pNtheader: PIMAGE_NT_HEADERS;

begin
 result:=false;
 hFile := CreateFile(PChar(Filename),
                     GENERIC_READ or GENERIC_WRITE,
                     FILE_SHARE_READ,
                     0,
                     OPEN_EXISTING,
                     FILE_ATTRIBUTE_NORMAL,
                     0 );
 if hFile <> INVALID_HANDLE_VALUE then begin
    dwFileLengtL:=GetFileSize(hFile, @dwFileLengtH);
    hFileMapping := CreateFileMapping(hFile, 0, PAGE_READWRITE, 0, 0, 0);
    if hFileMapping <> 0 then begin
       pBaseAddress := MapViewOfFile( hFileMapping,FILE_MAP_ALL_ACCESS, 0, 0, 0);
       if pBaseAddress <> nil then begin
          pNtheader:=nil;
          pNtheader:= CheckSumMappedFile(pBaseAddress, dwFileLengtL, &dwHeaderSum, &dwCheckSum );
          if pNtheader<> nil then begin
             pNtheader.OptionalHeader.CheckSum:=dwCheckSum;
             result:=true;
          end;
          UnmapViewOfFile(pBaseAddress);
       end;
       CloseHandle(hFileMapping);
    end;
    CloseHandle(hFile);
 end;
end;


function CorrectLdrChecSumm(FileName:string):boolean;

var

 hFile: THandle ;
 hFileMapping: THandle;
 pBaseAddress: pointer;
 pStartAddress: pointer;
 dwHeaderSize: DWORD;
 dwFileLengt: DWORD ;
 dwHeaderSum: DWORD ; // Checksum as stated by Header
 dwCheckSum: DWORD ; // Calculated Checksum
 pNtheader: PIMAGE_NT_HEADERS;
 I: integer;
begin
 result:=false;
 hFile := CreateFile(PChar(Filename),
                     GENERIC_READ or GENERIC_WRITE,
                     FILE_SHARE_READ,
                     0,
                     OPEN_EXISTING,
                     FILE_ATTRIBUTE_NORMAL,
                     0 );
 if hFile <> INVALID_HANDLE_VALUE then begin
    dwFileLengt:=GetFileSize(hFile, nil);
    hFileMapping := CreateFileMapping(hFile, 0, PAGE_READWRITE, 0, 0, 0);
    if hFileMapping <> 0 then begin
       pBaseAddress := MapViewOfFile( hFileMapping, FILE_MAP_ALL_ACCESS, 0, 0, 0);
       if pBaseAddress <> nil then begin
          dwHeaderSize:=0;
          pStartAddress:= Pointer(LongInt(pBaseAddress));
          for I := 0 to dwFileLengt div $10 do begin
            if PDword(pStartAddress)^ = PE_SIGNATURE_VS then break;
            if PDword(pStartAddress)^ = PE_SIGNATURE_DE then break;
            pStartAddress:= Pointer(LongInt(pStartAddress)+$10);
            inc(dwHeaderSize,$10);
          end;
          pNtheader:=nil;
          pNtheader:= CheckSumMappedFile(pStartAddress, dwFileLengt - dwHeaderSize, &dwHeaderSum, &dwCheckSum );
          if pNtheader<> nil then begin
             pNtheader.OptionalHeader.CheckSum:=dwCheckSum;
             result:=true;
          end;
         UnmapViewOfFile(pBaseAddress);
       end;
       CloseHandle(hFileMapping);
    end;
    CloseHandle(hFile);
 end;
end;

end.

