; TTF fonts must be installed in system first

#AutoIt3Wrapper_run_obfuscator=y
#Obfuscator_parameters=/so

#include <ComboConstants.au3>
#include <EditConstants.au3>
#include <GUIConstantsEx.au3>
#include <WindowsConstants.au3>
#include <WinAPI.au3>

#include <print.au3>
#include <barcode.au3>

$barcode_test = GUICreate("BarCode Test", 601, 174, -1, -1)
GUICtrlCreateLabel("Input:", 11, 10, 30, 17)
$Input = GUICtrlCreateInput("", 41, 8, 120, 21)
GUICtrlCreateLabel("Output:", 171, 10, 38, 17)
$Output = GUICtrlCreateInput("", 209, 8, 120, 21)
GUICtrlSetState(-1, $GUI_DISABLE)
$print = GUICtrlCreateButton("Print", 340, 7, 39, 23)
GUICtrlCreateLabel("Type:", 387, 10, 28, 17)
$type = GUICtrlCreateCombo("", 417, 8, 91, 25, BitOR($CBS_DROPDOWNLIST,$CBS_AUTOHSCROLL))
GUICtrlSetData(-1, "Code 128|EAN 8|EAN 13|Code 2 of 5 i|Code 3 of 9", "Code 128")
GUICtrlCreateLabel("Size:", 517, 10, 25, 17)
$size = GUICtrlCreateCombo("", 543, 8, 47, 25, BitOR($CBS_DROPDOWNLIST,$CBS_AUTOHSCROLL))
GUICtrlSetData(-1, "12|18|24|36|48|60|72", "48")
$barcode = GUICtrlCreateLabel("", 10, 39, 580, 130)
GUICtrlSetFont(-1, 48, 400, 0, "Code 128")
GUICtrlSetBkColor(-1, 0xFFFFFF)
GUISetState(@SW_SHOW)

GUIRegisterMsg($WM_COMMAND, "WM_COMMAND")

While 1
	$nMsg = GUIGetMsg()
	Switch $nMsg
		Case $GUI_EVENT_CLOSE
			Exit
		Case $type
			ChangeFont()
			ApplyBarcode()
		Case $size
			ChangeFont()
		Case $print
			Print()
	EndSwitch
WEnd

Func WM_COMMAND($hWinHandle, $iMsg, $wParam, $lParam)
    If _WinAPI_HiWord($wParam) = $EN_CHANGE And _WinAPI_LoWord($wParam) = $Input Then
		ApplyBarcode()
    EndIf
EndFunc

Func ChangeFont()
	Switch GUICtrlRead($type)
		Case 'Code 128'
			$font_name = 'Code 128'
		Case 'EAN 8','EAN 13'
			$font_name = 'Code EAN13'
		Case 'Code 2 of 5 i'
			$font_name = 'Code 2 of 5 interleaved'
		Case 'Code 3 of 9'
			$font_name = 'Code 3 de 9'
	EndSwitch
	GUICtrlSetFont($barcode, GUICtrlRead($size), 400, 0, $font_name)
EndFunc

Func ApplyBarcode()
	Switch GUICtrlRead($type)
		Case 'Code 128'
			$barcode_data = barcode_128(GUICtrlRead($Input))
		Case 'EAN 8'
			$barcode_data = barcode_ean8(GUICtrlRead($Input))
		Case 'EAN 13'
			$barcode_data = barcode_ean13(GUICtrlRead($Input))
		Case 'Code 2 of 5 i'
			$barcode_data = barcode_25i(GUICtrlRead($Input))
		Case 'Code 3 of 9'
			$barcode_data = barcode_39(GUICtrlRead($Input))
	EndSwitch
	GUICtrlSetData($Output, $barcode_data)
	GUICtrlSetData($barcode, $barcode_data)
EndFunc

; print given text on default printer in given size by all available barcode types
Func Print()
	$sPrinter = _GetDefaultPrinter()
	If $sPrinter = "" Then Return

	$hPrintDC = _WinAPI_CreateDC("winspool", $sPrinter)
	_InitPrinter($hPrintDC, "Printing Barcodes from AutoIt") ; print job name

	$hFont = _CreateFont_Simple('Arial', 12, $FW_BOLD)
	$hFontOld = _WinAPI_SelectObject($hPrintDC, $hFont)
	_TextOut_Centered($hPrintDC, 500, 'Input data: ' & GUICtrlRead($Input), 0xFF0000)
	_WinAPI_SelectObject($hPrintDC, $hFontOld)
	_WinAPI_DeleteObject($hFont)

	$hFont = _CreateFont_Simple('Courier', 10, $FW_NORMAL)
	$hFontOld = _WinAPI_SelectObject($hPrintDC, $hFont)
	_WinAPI_SetTextColor($hPrintDC, 0x000000)
	_TextOut_Centered($hPrintDC, 1400, 'Code 128')
	_TextOut_Centered($hPrintDC, 2400, 'EAN 8')
	_TextOut_Centered($hPrintDC, 3400, 'EAN 13')
	_TextOut_Centered($hPrintDC, 4400, 'Code 2 of 5 i')
	_TextOut_Centered($hPrintDC, 5400, 'Code 3 of 9')
	_WinAPI_SelectObject($hPrintDC, $hFontOld)
	_WinAPI_DeleteObject($hFont)

	$hFont = _CreateFont_Simple('Code 128', GUICtrlRead($size), $FW_NORMAL)
	$hFontOld = _WinAPI_SelectObject($hPrintDC, $hFont)
	_TextOut_Centered($hPrintDC, 1500, barcode_128(GUICtrlRead($Input)))
	_WinAPI_SelectObject($hPrintDC, $hFontOld)
	_WinAPI_DeleteObject($hFont)

	$hFont = _CreateFont_Simple('Code EAN13', GUICtrlRead($size), $FW_NORMAL)
	$hFontOld = _WinAPI_SelectObject($hPrintDC, $hFont)
	_TextOut_Centered($hPrintDC, 2500, barcode_ean8(GUICtrlRead($Input)))
	_WinAPI_SelectObject($hPrintDC, $hFontOld)
	_WinAPI_DeleteObject($hFont)

	$hFont = _CreateFont_Simple('Code EAN13', GUICtrlRead($size), $FW_NORMAL)
	$hFontOld = _WinAPI_SelectObject($hPrintDC, $hFont)
	_TextOut_Centered($hPrintDC, 3500, barcode_ean13(GUICtrlRead($Input)))
	_WinAPI_SelectObject($hPrintDC, $hFontOld)
	_WinAPI_DeleteObject($hFont)

	$hFont = _CreateFont_Simple('Code 2 of 5 interleaved', GUICtrlRead($size), $FW_NORMAL)
	$hFontOld = _WinAPI_SelectObject($hPrintDC, $hFont)
	_TextOut_Centered($hPrintDC, 4500, barcode_25i(GUICtrlRead($Input)))
	_WinAPI_SelectObject($hPrintDC, $hFontOld)
	_WinAPI_DeleteObject($hFont)

	$hFont = _CreateFont_Simple('Code 3 de 9', GUICtrlRead($size), $FW_NORMAL)
	$hFontOld = _WinAPI_SelectObject($hPrintDC, $hFont)
	_TextOut_Centered($hPrintDC, 5500, barcode_39(GUICtrlRead($Input)))
	_WinAPI_SelectObject($hPrintDC, $hFontOld)
	_WinAPI_DeleteObject($hFont)

	_DeInitPrinter($hPrintDC)
EndFunc
