;   : http://autoit-script.ru/index.php?topic=3925.msg30926#msg30926
Global $__g_iGDIPRef = 0
Global Const $tagGDIPSTARTUPINPUT = "uint Version;ptr Callback;bool NoThread;bool NoCodecs"
Global $__g_hGDIPDll = 0
Global $__g_iGDIPToken = 0
Global $__g_iGDIPToken = 0

_GDIPlus_Startup()
$sFile = $CmdLine[1]
$hBitmap = _GDIPlus_BitmapCreateFromFile($sFile)
$iPic_W = _GDIPlus_ImageGetWidth($hBitmap)
$iPic_H = _GDIPlus_ImageGetHeight($hBitmap)
_GDIPlus_ImageDispose($hBitmap)
_GDIPlus_Shutdown()
ConsoleWrite($iPic_W & ' ' & $iPic_H)

Func _GDIPlus_Startup($sGDIPDLL = Default, $bRetDllHandle = False)
	$__g_iGDIPRef += 1
	If $__g_iGDIPRef > 1 Then Return True

	If $sGDIPDLL = Default Then
		If @OSBuild > 4999 And @OSBuild < 7600 Then
			; Vista or Server R2008
			$sGDIPDLL = @WindowsDir & "\winsxs\x86_microsoft.windows.gdiplus_6595b64144ccf1df_1.1.6000.16386_none_8df21b8362744ace\gdiplus.dll"
		Else
			$sGDIPDLL = "gdiplus.dll"
		EndIf
	EndIf
	$__g_hGDIPDll = DllOpen($sGDIPDLL)
	If $__g_hGDIPDll = -1 Then
		$__g_iGDIPRef = 0
		Return SetError(1, 2, False)
	EndIf

	Local $sVer = FileGetVersion($sGDIPDLL)
	$sVer = StringSplit($sVer, ".")
	If $sVer[1] > 5 Then $__g_bGDIP_V1_0 = False

	Local $tInput = DllStructCreate($tagGDIPSTARTUPINPUT)
	Local $tToken = DllStructCreate("ulong_ptr Data")
	DllStructSetData($tInput, "Version", 1)
	Local $aResult = DllCall($__g_hGDIPDll, "int", "GdiplusStartup", "struct*", $tToken, "struct*", $tInput, "ptr", 0)
	If @error Then Return SetError(@error, @extended, False)
	If $aResult[0] Then Return SetError(10, $aResult[0], False)

	$__g_iGDIPToken = DllStructGetData($tToken, "Data")
	If $bRetDllHandle Then Return $__g_hGDIPDll
	Return True
EndFunc   ;==>_GDIPlus_Startup
Func _GDIPlus_BitmapCreateFromFile($sFileName)
	Local $aResult = DllCall($__g_hGDIPDll, "int", "GdipCreateBitmapFromFile", "wstr", $sFileName, "handle*", 0)
	If @error Then Return SetError(@error, @extended, 0)
	If $aResult[0] Then Return SetError(10, $aResult[0], 0)

	Return $aResult[2]
EndFunc   ;==>_GDIPlus_BitmapCreateFromFile
Func _GDIPlus_ImageGetWidth($hImage)
	Local $aResult = DllCall($__g_hGDIPDll, "int", "GdipGetImageWidth", "handle", $hImage, "uint*", -1)
	If @error Then Return SetError(@error, @extended, -1)
	If $aResult[0] Then Return SetError(10, $aResult[0], -1)

	Return $aResult[2]
EndFunc   ;==>_GDIPlus_ImageGetWidth
Func _GDIPlus_ImageGetHeight($hImage)
	Local $aResult = DllCall($__g_hGDIPDll, "int", "GdipGetImageHeight", "handle", $hImage, "uint*", 0)
	If @error Then Return SetError(@error, @extended, -1)
	If $aResult[0] Then Return SetError(10, $aResult[0], -1)

	Return $aResult[2]
EndFunc   ;==>_GDIPlus_ImageGetHeight
Func _GDIPlus_ImageDispose($hImage)
	Local $aResult = DllCall($__g_hGDIPDll, "int", "GdipDisposeImage", "handle", $hImage)
	If @error Then Return SetError(@error, @extended, False)
	If $aResult[0] Then Return SetError(10, $aResult[0], False)

	Return True
EndFunc   ;==>_GDIPlus_ImageDispose
Func _GDIPlus_Shutdown()
	If $__g_hGDIPDll = 0 Then Return SetError(-1, -1, False)

	$__g_iGDIPRef -= 1
	If $__g_iGDIPRef = 0 Then
		DllCall($__g_hGDIPDll, "none", "GdiplusShutdown", "ulong_ptr", $__g_iGDIPToken)
		DllClose($__g_hGDIPDll)
		$__g_hGDIPDll = 0
	EndIf
	Return True
EndFunc   ;==>_GDIPlus_Shutdown
