//************************************************ [ -  ] ***************************************************//
[code]
function DetectHardware: Integer; external 'hwc_DetectHardware@files:get_hw_caps.dll stdcall';
function GetProcessorName: PAnsiChar; external 'hwc_GetProcessorName@files:get_hw_caps.dll stdcall';
function GetProcessorFreq: Integer; external 'hwc_GetProcessorFreq@files:get_hw_caps.dll stdcall';
function GetVideoCardName: PAnsiChar; external 'hwc_GetVideoCardName@files:get_hw_caps.dll stdcall';
function GetVidMemLocal: Integer; external 'hwc_GetVidMemLocal@files:get_hw_caps.dll stdcall';
function GetPdmWidth: Integer; external 'hwc_GetPdmWidth@files:get_hw_caps.dll stdcall';
function GetPdmHeight: Integer; external 'hwc_GetPdmHeight@files:get_hw_caps.dll stdcall';
function GetSoundCards: Integer; external 'hwc_GetSoundCards@files:get_hw_caps.dll stdcall';
function GetSoundCardName: PAnsiChar; external 'hwc_GetSoundCardName@files:get_hw_caps.dll stdcall';
function GetSystemPhys: Integer; external 'hwc_GetSystemPhys@files:get_hw_caps.dll stdcall';
function GetWindowsName: PAnsiChar; external 'hwc_GetWindowsName@files:get_hw_caps.dll stdcall';

function DelSp(s: string): string;
begin
  while Pos('  ',s)>0 do StringChange(s,'  ',' ');
  Result:=Trim(s);
end;

procedure GroupChange(Sender: TObject);
begin
  GroupEditLabel.Caption := MinimizePathName(WizardForm.GroupEdit.Text, GroupEditLabel.Font, GroupEditLabel.Width);
end;

function NumToStr(Float: Extended): string;
begin
  Result:=Format('%.2n', [Float]);
  StringChange(Result, ',', '.');
  while ((Result[Length(Result)]='0') or (Result[Length(Result)]='.')) and (Pos('.',Result)>0) do SetLength(Result,Length(Result)-1);
end;

function MbOrTB(Float: Extended): string;
begin
  if Float<1024 then Result:=NumToStr(Float)+' MB'
  else if (Float/1024)<1024 then Result:=NumToStr(Float/1024)+' GB'
  else if (Float/(1024*1024))<1024 then Result:=NumToStr(Float/(1024*1024))+' TB'
end;

procedure SysReqFlashing(h: Longword; msg: Longword; idevent: Longword; dwTime: Longword);
var
  i:integer;
begin
  for i:= 0 to GetArrayLength(ASysReq)-1 do
    if ASysReq[i].Font.Color=$FFFFFF then ASysReq[i].Font.Color:=$0000FF else ASysReq[i].Font.Color:=$FFFFFF;
end;

procedure DiskFlashing(h: Longword; msg: Longword; idevent: Longword; dwTime: Longword);
var
  i:integer;
begin
  for i:= 0 to GetArrayLength(ADisk)-1 do
    if ADisk[i].Font.Color=$FFFFFF then ADisk[i].Font.Color:=$0000FF else ADisk[i].Font.Color:=$FFFFFF;
end;

function GetElementIndex(a:TALabel; lbl:TLabel):integer;
var
  i:integer;
  f:boolean;
begin
  Result:=-1;
  f:=False;
  for i:=0 to GetArrayLength(a)-1 do
    if a[i]=lbl then begin
      f:=True;
      Break;
    end;
  if f then Result:=i;
end;

procedure AddLabelToArray(var a:TALabel; lbl:TLabel);
begin
  if GetElementIndex(a,lbl)=-1 then begin
    SetArrayLength(a,GetArrayLength(a)+1);
    a[GetArrayLength(a)-1]:=lbl;
  end;
end;

procedure DeleteLabelFromArray(var a:TALabel; lbl:integer);
var
  Last,i:integer;
begin
  if lbl<>-1 then begin
    Last:=GetArrayLength(a)-1;
    if lbl<Last then
      for i:=lbl to Last-1 do a[i]:=a[i+1];
    SetArrayLength(a,Last);
  end;
end;

procedure GetFreeSpaceCaption(Sender: TObject);
var
  CurrentDisk: String;
  i:integer;
begin
  CurrentDisk:=ExtractFileDrive(WizardForm.DirEdit.Text);
  DirEditLabel.Caption:=MinimizePathName(WizardForm.DirEdit.Text, DirEditLabel.Font, DirEditLabel.Width);
  if not GetSpaceOnDisk(CurrentDisk,True,FreeMB,TotalMB) then begin
    KillTimer(WizardForm.Handle,WFDiskTimerID);
    SetArrayLength(ADisk,0);
    TotalSpaceLabel.Visible:=False;
    FreeSpaceLabel.Visible:=False;
    BtnSetEnabled(hNextBtn,False);
    WizardForm.NextButton.Enabled:=False;
    OldDisk:=CurrentDisk;
    Exit;
  end;

  TotalSpaceLabel.Visible:=True;
  FreeSpaceLabel.Visible:=True;

  if CurrentDisk<>OldDisk then begin
    OldDisk:=CurrentDisk;
    TotalSpaceLabel.Caption := ExpandConstant('{cm:TotalSpace} ') + MbOrTB(TotalMb);
    FreeSpaceLabel.Caption := ExpandConstant('{cm:FreeSpace} ') + MbOrTB(FreeMb) + ' (' + IntToStr((FreeMb*100) div TotalMB) + ' %)';

    if WizardForm.CurPageID = wpSelectDir then begin
      if FreeMB>={#TNeedSize} then begin
        i:=GetElementIndex(ADisk,FreeSpaceLabel);
        if i<>-1 then begin
          DeleteLabelFromArray(ADisk,i);
          FreeSpaceLabel.Font.Color:=$FFFFFF;
          if GetArrayLength(ADisk)=0 then KillTimer(WizardForm.Handle,WFDiskTimerID);
        end;
      end else AddLabelToArray(ADisk,FreeSpaceLabel);

      if TotalMb>={#TNeedSize} then begin
        i:=GetElementIndex(ADisk,TotalSpaceLabel);
        if i<>-1 then begin
          DeleteLabelFromArray(ADisk,i);
          TotalSpaceLabel.Font.Color:=$FFFFFF;
          if GetArrayLength(ADisk)=0 then KillTimer(WizardForm.Handle,WFDiskTimerID);
        end;
      end else AddLabelToArray(ADisk,TotalSpaceLabel);

      if GetArrayLength(ADisk)>0 then SetTimer(WizardForm.Handle,WFDiskTimerID,1000,WrapTimerProc(@DiskFlashing,4));
      BtnSetEnabled(hNextBtn,not (GetArrayLength(ADisk)>0));
      WizardForm.NextButton.Enabled:=not (GetArrayLength(ADisk)>0);
    end;
  end;
end;


function Install: Boolean;
begin
  if (Cancel <> 0) or MyError or (UnPackError <> 0) then
    Result:= True;
end;


function NoIcons: Boolean;
begin
  Result:= BtnGetEnabled(hGroupBrowseBtn);
end;

function Desktop: Boolean;
begin
  Result:= BtnGetChecked(DesktopCheck);
end;

function QuickLaunch: Boolean;
begin
  Result:= BtnGetChecked(QuickLaunchCheck);
end;

function DirectX: Boolean;
begin
  ProgressInfoLabel.Visible:=False;
  FilenameLabel.Hide;
  Result:= BtnGetChecked(DirectXCheck);
end;

procedure NoIconsClick(hBtn:HWND);
var
  Check:boolean;
begin
  sndPlaySound(ExpandConstant('{tmp}\Check.wav'), $0001);
  Check:=BtnGetChecked(hBtn);
  BtnSetEnabled(hGroupBrowseBtn, not Check);
  GroupEditLabel.Enabled:=not Check;
  if Check then NoIconsLabel.Font.Color:=$00FFFF else NoIconsLabel.Font.Color:=$FFFFFF;
end;

procedure NoIconsLabelClick(Sender:TObject);
begin
  BtnSetChecked(NoIconsCheck, not BtnGetChecked(NoIconsCheck));
  NoIconsClick(NoIconsCheck);
end;

procedure DesktopClick(hBtn:HWND);
begin
  sndPlaySound(ExpandConstant('{tmp}\Check.wav'), $0001);
  if BtnGetChecked(hBtn) then DesktopLabel.Font.Color:=$00FFFF else DesktopLabel.Font.Color:=$FFFFFF;
end;

procedure DesktopLabelClick(Sender:TObject);
begin
  BtnSetChecked(DesktopCheck, not BtnGetChecked(DesktopCheck));
  DesktopClick(DesktopCheck);
end;

procedure QuickLaunchClick(hBtn:HWND);
begin
  sndPlaySound(ExpandConstant('{tmp}\Check.wav'), $0001);
  if BtnGetChecked(hBtn) then QuickLaunchLabel.Font.Color:=$00FFFF else QuickLaunchLabel.Font.Color:=$FFFFFF;
end;

procedure QuickLaunchLabelClick(Sender:TObject);
begin
  BtnSetChecked(QuickLaunchCheck, not BtnGetChecked(QuickLaunchCheck));
  QuickLaunchClick(QuickLaunchCheck);
end;

procedure DirectXClick(hBtn:HWND);
begin
  sndPlaySound(ExpandConstant('{tmp}\Check.wav'), $0001);
  if BtnGetChecked(hBtn) then DirectXLabel.Font.Color:=$00FFFF else DirectXLabel.Font.Color:=$FFFFFF;
end;

procedure DirectXLabelClick(Sender:TObject);
begin
  BtnSetChecked(DirectXCheck, not BtnGetChecked(DirectXCheck));
  DirectXClick(DirectXCheck);
end;

procedure DirectXProgress;
begin
  StatusLabel.Caption:=ExpandConstant('{cm:DirectXInstall}')
end;

procedure CreatePageComponents;
var
  Pdm: string;
  vr,VidRam : Longint;
  Version: TWindowsVersion;
begin
  PageNameLabel:=TLabel.Create(WizardForm);
  with PageNameLabel do begin
    AutoSize:= False;
    SetBounds(ScaleX(70), ScaleY(185), ScaleX(400), ScaleY(30));
    Transparent:=True;
    Font.Name:= 'Georgia';
    Font.Size:= 13;
    Font.Color:=$FFFFFF;
    Font.Style:=[fsBold];
    Parent:=WizardForm;
  end;

  PageDescriptionLabel:=TLabel.Create(WizardForm);
  with PageDescriptionLabel do begin
    AutoSize:= False;
    SetBounds(ScaleX(100), ScaleY(215), ScaleX(600), ScaleY(50));
    Wordwrap:= True;
    Transparent:=True;
    Font.Name:= 'Georgia';
    Font.Size:= 10;
    Font.Color:=$FFFFFF;
    Font.Style:=[fsBold, fsItalic];
    Parent:=WizardForm;
  end;

////////////////////// WelcomePage //////////////////////

  WelcomeLabel1:= TLabel.Create(WizardForm);
  with WelcomeLabel1 do begin
    AutoSize:=False
    SetBounds(ScaleX(75), ScaleY(185), ScaleX(648), ScaleY(65));
    WordWrap:=True
    Alignment := taCenter;
    Transparent:=True
    Font.Name:='Georgia';
    Font.Size:= 16;
    Font.Color:=$FFFFFF;
    Font.Style:=[fsBold]
    Caption:= ExpandConstant('{cm:Welcome1}');
    Parent:=WizardForm
  end;

  WelcomeLabel2:=TLabel.Create(WizardForm);
  with WelcomeLabel2 do begin
    AutoSize:=False
    SetBounds(ScaleX(75), ScaleY(275), ScaleX(648), ScaleY(200));
    WordWrap:=True
    Transparent:=True
    Font.Name:='Georgia';
    Font.Size:= 11;
    Font.Color:=$FFFFFF;
    Font.Style := [fsBold, fsItalic];
    Caption:= ExpandConstant('{cm:Welcome2}');
    Parent:=WizardForm
  end;

////////////////////// WelcomePage //////////////////////

////////////////////// SystemPage //////////////////////

  SystemPage:=CreateCustomPage(wpLicense, ExpandConstant('{cm:Requirements1}'), ExpandConstant('{cm:Requirements2}'));

  RequirementsLbl := TLabel.Create(WizardForm);
  with RequirementsLbl do begin
    AutoSize:=False;
    SetBounds(ScaleX(100), ScaleY(250), ScaleX(605), ScaleY(50));
    Transparent:=True;
    Font.Name:= 'Georgia';
    Font.Size:= 10;
    Font.Color:=$FFFFFF;
    Font.Style:=[fsBold, fsItalic];
    Caption := ExpandConstant('{cm:Requirements3}');
    Parent:=WizardForm;
  end;

  //=================  -  =================//

  ProcessorLbl := TLabel.Create(WizardForm);
  with ProcessorLbl do begin
    AutoSize:=False;
    SetBounds(ScaleX(107), ScaleY(296), ScaleX(150), ScaleY(22));
    Transparent:=True;
    Font.Name:= 'Arial';
    Font.Size:= 9;
    Font.Color:=$FFFFFF;
    Font.Style:=[fsBold];
    Caption := ExpandConstant('{cm:Processor}');
    Parent := WizardForm;
  end;

  ProcessorNameLbl := TLabel.Create(WizardForm);
  with ProcessorNameLbl do begin
    AutoSize:=False;
    SetBounds(ScaleX(278), ScaleY(296), ScaleX(400), ScaleY(22));
    Transparent:=True;
    Font.Name:= 'Arial';
    Font.Size:= 9;
    Font.Color:=$FFFFFF;
    Font.Style:=[fsBold];
    Caption := DelSP(GetProcessorName) + ' @' + IntToStr(GetProcessorFreq) + ' MHz';
    Parent := WizardForm;
  end;

  RegGetSubkeyNames(HKLM, 'Hardware\Description\System\CentralProcessor', Keys)

  if (GetProcessorFreq*GetArrayLength(Keys)) < {#Processor} then
  begin
    RequirementsLbl.Caption := ExpandConstant('{cm:Requirements4}');
    AddLabelToArray(AsysReq,ProcessorNameLbl);
  end;

//=================  -  =================//

//=================  -  =================//

  VideoCardLbl := TLabel.Create(WizardForm);
  with VideoCardLbl do begin
    AutoSize:=False;
    SetBounds(ScaleX(107), ScaleY(327), ScaleX(150), ScaleY(22));
    Transparent:=True;
    Font.Name:= 'Arial';
    Font.Size:= 9;
    Font.Color:=$FFFFFF;
    Font.Style:=[fsBold];
    Caption := ExpandConstant('{cm:VideoCard}');
    Parent := WizardForm;
  end;

  VideoCardNameLbl := TLabel.Create(WizardForm);
  with VideoCardNameLbl do begin
    AutoSize:=False;
    SetBounds(ScaleX(280), ScaleY(327), ScaleX(400), ScaleY(22));
    Transparent:=True;
    Font.Name:= 'Arial';
    Font.Size:= 9;
    Font.Color:=$FFFFFF;
    Font.Style:=[fsBold];
    Caption := GetVideoCardName;
    Parent := WizardForm;
  end;

  Pdm:=' ['+IntToStr(GetPdmWidth)+'x'+IntToStr(GetPdmHeight)+']';

  VidRam:=GetVidMemLocal/1000000;
  if (VidRam<63) or (VidRam>1100) then vr:=VidRam
  else if VidRam<100 then vr:=64
  else if VidRam<200 then vr:=128
  else if VidRam<300 then vr:=256
  else if VidRam<400 then vr:=384
  else if VidRam<600 then vr:=512
  else if VidRam<800 then vr:=792
  else if VidRam>800 then vr:=1024;

  if VidRam=0 then VideoCardNameLbl.Caption:=ExpandConstant('{cm:DeviceDriver}')
    else VideoCardNameLbl.Caption:=DelSp(VideoCardNameLbl.Caption)+' ~'+IntToStr(vr)+' MB'+Pdm;
  if vr<{#VideoCard} then begin
    RequirementsLbl.Caption:=ExpandConstant('{cm:Requirements4}');
    AddLabelToArray(ASysReq,VideoCardNameLbl);
  end;

//=================  -  =================//

//=================  -   =================//

  SoundCardLbl := TLabel.Create(WizardForm);
  with SoundCardLbl do begin
    AutoSize:=False;
    SetBounds(ScaleX(107), ScaleY(358), ScaleX(150), ScaleY(22));
    Transparent:=True;
    Font.Name:= 'Arial';
    Font.Size:= 9;
    Font.Color:=$FFFFFF;
    Font.Style:=[fsBold];
    Caption := ExpandConstant('{cm:SoundCard}');
    Parent := WizardForm;
  end;

  SoundCardNameLbl := TLabel.Create(WizardForm);
  with SoundCardNameLbl do begin
    AutoSize:=False;
    SetBounds(ScaleX(278), ScaleY(358), ScaleX(400), ScaleY(22));
    Transparent:=True;
    Font.Name:= 'Arial';
    Font.Size:= 9;
    Font.Color:=$FFFFFF;
    Font.Style:=[fsBold];
    Caption := GetSoundCardName;
    Parent := WizardForm;
  end;

  if GetSoundCards = 0 then begin
    RequirementsLbl.Caption:= ExpandConstant('{cm:Requirements4}');
    SoundCardNameLbl.Caption:= ExpandConstant('{cm:DeviceDriver}');
    AddLabelToArray(ASysReq,SoundCardNameLbl);
  end;

//=================  -   =================//

//=================  -  =================//

  RAMLbl := TLabel.Create(WizardForm);
  with RAMLbl do begin
    AutoSize:=False;
    SetBounds(ScaleX(107), ScaleY(389), ScaleX(150), ScaleY(22));
    Transparent:=True;
    Font.Name:= 'Arial';
    Font.Size:= 9;
    Font.Color:=$FFFFFF;
    Font.Style:=[fsBold];
    Caption := ExpandConstant('{cm:RAM}');
    Parent := WizardForm;
  end;

  RAMTotalLbl := TLabel.Create(WizardForm);
  with RAMTotalLbl do begin
    AutoSize:=False;
    SetBounds(ScaleX(279), ScaleY(389), ScaleX(400), ScaleY(22));
    Transparent:=True;
    Font.Name:= 'Arial';
    Font.Size:= 9;
    Font.Color:=$FFFFFF;
    Font.Style:=[fsBold];
    Caption := IntToStr(GetSystemPhys + 1) + ' MB';
    Parent := WizardForm;
  end;

  if (GetSystemPhys+1)<{#RAM} then begin
    RequirementsLbl.Caption := ExpandConstant('{cm:Requirements4}');
    AddLabelToArray(ASysReq,RAMTotalLbl);
  end;

//=================  -  =================//

//=================  -   =================//

  SystemLbl := TLabel.Create(WizardForm);
  with SystemLbl do begin
    AutoSize:=False;
    SetBounds(ScaleX(107), ScaleY(420), ScaleX(150), ScaleY(22));
    Transparent:=True;
    Font.Name:= 'Arial';
    Font.Size:= 9;
    Font.Color:=$FFFFFF;
    Font.Style:=[fsBold];
    Caption := ExpandConstant('{cm:OperationSystem}');
    Parent := WizardForm;
  end;

  SystemNameLbl := TLabel.Create(WizardForm);
  with SystemNameLbl do begin
    AutoSize:=False;
    SetBounds(ScaleX(279), ScaleY(420), ScaleX(400), ScaleY(22));
    Transparent:=True;
    Font.Name:= 'Arial';
    Font.Size:= 9;
    Font.Color:=$FFFFFF;
    Font.Style:=[fsBold];
    Caption := GetWindowsName;
    Parent := WizardForm;
  end;

  GetWindowsVersionEx(Version);

  if not Version.NTPlatform or
    (Version.NTPlatform and (Version.Major<{#WinVerMajor})) or
    (Version.NTPlatform and (Version.Major={#WinVerMajor}) and (Version.Minor<{#WinVerMinor})) or
    (Version.NTPlatform and (Version.Major={#WinVerMajor}) and (Version.Minor={#WinVerMinor}) and (Version.ServicePackMajor<{#ServicePack})) then begin
    RequirementsLbl.Caption := ExpandConstant('{cm:Requirements4}');
    AddLabelToArray(ASysReq,SystemNameLbl);
  end;

//=================  -   =================//

////////////////////// SystemPage //////////////////////

////////////////////// SelectDirPage //////////////////////

  SelectDirBrowseLabel := TLabel.Create(WizardForm);
  with SelectDirBrowseLabel do begin
    AutoSize:=False;
    SetBounds(ScaleX(120), ScaleY(250), ScaleX(600), ScaleY(50));
    WordWrap:= True;
    Transparent:=True;
    Font.Name:= 'Georgia'
    Font.Size:= 10;
    Font.Color:=$FFFFFF;
    Font.Style:=[fsBold, fsItalic];
    Caption:= WizardForm.SelectDirBrowseLabel.Caption;
    Parent := WizardForm;
  end;

  DirEditLabel := TLabel.Create(WizardForm);
  with DirEditLabel do begin
    AutoSize:=False;
    SetBounds(ScaleX(127), ScaleY(308), ScaleX(446), ScaleY(15));
    WordWrap:= True;
    ShowAccelChar := False;
    Transparent:=True;
    Font.Name:= 'Arial'
    Font.Size:= 9;
    Font.Color:=$FFFFFF;
    Font.Style:=[fsBold];
    Caption := MinimizePathName(WizardForm.DirEdit.Text, DirEditLabel.Font, DirEditLabel.Width);
    Parent := WizardForm;
  end;

  TotalSpaceLabel := TLabel.Create(WizardForm);
  with TotalSpaceLabel do begin
    AutoSize:=False;
    SetBounds(ScaleX(130), ScaleY(360), ScaleX(500), ScaleY(17));
    Transparent:=True;
    Font.Name:= 'Georgia';
    Font.Size:= 9;
    Font.Color:=$FFFFFF;
    Font.Style:=[fsBold, fsItalic];
    Parent := WizardForm;
  end;

  FreeSpaceLabel := TLabel.Create(WizardForm);
  with FreeSpaceLabel do begin
    AutoSize:=False;
    SetBounds(ScaleX(130), ScaleY(380), ScaleX(500), ScaleY(17));
    Transparent:=True;
    Font.Name:= 'Georgia';
    Font.Size:= 9;
    Font.Color:=$FFFFFF;
    Font.Style:=[fsBold, fsItalic];
    Parent := WizardForm;
  end;

  NeedSpaceLabel := TLabel.Create(WizardForm);
  with NeedSpaceLabel do begin
    AutoSize:=False;
    SetBounds(ScaleX(130), ScaleY(420), ScaleX(500), ScaleY(17));
    Transparent:=True;
    Font.Name:= 'Georgia';
    Font.Size:= 9;
    Font.Color:=$FFFFFF;
    Font.Style:=[fsBold, fsItalic];
    Caption := ExpandConstant('{cm:NeedSpace} ') + MbOrTB({#NeedSize});
    Parent := WizardForm;
  end;

  NeedSpaceTLabel := TLabel.Create(WizardForm);
  with NeedSpaceTLabel do begin
    AutoSize:=False;
    SetBounds(ScaleX(130), ScaleY(400), ScaleX(500), ScaleY(17));
    Transparent:=True;
    Font.Name:= 'Georgia';
    Font.Size:= 9;
    Font.Color:=$FFFFFF;
    Font.Style:=[fsBold, fsItalic];
    Caption := ExpandConstant('{cm:TNeedSpace} ') + MbOrTB({#TNeedSize});
    Parent := WizardForm;
  end;

////////////////////// SelectDirPage //////////////////////

////////////////////// SelectComponentsPage //////////////////////

////////////////////// SelectComponentsPage //////////////////////

////////////////////// SelectProgramGroupPage //////////////////////

  SelectStartMenuFolderBrowseLabel := TLabel.Create(WizardForm);
  with SelectStartMenuFolderBrowseLabel do begin
    AutoSize:=False;
    SetBounds(ScaleX(120), ScaleY(250), ScaleX(600), ScaleY(50));
    WordWrap:= True;
    Transparent:=True;
    Font.Name:= 'Georgia'
    Font.Size:= 10;
    Font.Color:=$FFFFFF;
    Font.Style:=[fsBold, fsItalic];
    Caption:= WizardForm.SelectStartMenuFolderBrowseLabel.Caption;
    Parent := WizardForm;
  end;

  GroupEditLabel := TLabel.Create(WizardForm);
  with GroupEditLabel do begin
    AutoSize:=False;
    SetBounds(ScaleX(127), ScaleY(308), ScaleX(446), ScaleY(15));
    WordWrap:= True;
    ShowAccelChar := False;
    Transparent:=True;
    Font.Name:= 'Arial'
    Font.Size:= 9;
    Font.Color:=$FFFFFF;
    Font.Style:=[fsBold];
    Caption := MinimizePathName(WizardForm.GroupEdit.Text, GroupEditLabel.Font, GroupEditLabel.Width);
    Parent := WizardForm;
  end;

  NoIconsCheck:=BtnCreate(WizardForm.Handle,ScaleX(75),ScaleY(430),ScaleX(28),ScaleY(28),ExpandConstant('{tmp}\CheckBox.png'),8,True);
  BtnSetEvent(NoIconsCheck,BtnClickEventID,WrapBtnCallback(@NoIconsClick,1));
  BtnSetEvent(NoIconsCheck,BtnMouseEnterEventID,WrapBtnCallback(@WFBtnEnter,1));
  BtnSetCursor(NoIconsCheck,GetSysCursorHandle(32649));

  NoIconsLabel := TLabel.Create(WizardForm);
  with NoIconsLabel do begin
    AutoSize:=False;
    SetBounds(ScaleX(115), ScaleY(437), ScaleX(275), ScaleY(17));
    OnClick:= @NoIconsLabelClick;
    Cursor:= CrHand;
    Transparent:=True;
    Font.Name:= 'Georgia'
    Font.Size:= 10;
    Font.Color:=$FFFFFF;
    Font.Style:=[fsBold,fsItalic];
    Caption := WizardForm.NoIconsCheck.Caption;
    Parent := WizardForm;
  end;

  WizardForm.DirEdit.OnChange := @GetFreeSpaceCaption;
  WizardForm.DirEdit.Text:= WizardForm.DirEdit.Text;
  WizardForm.GroupEdit.OnChange := @GroupChange;

////////////////////// SelectProgramGroupPage //////////////////////

////////////////////// SelectTasksPade //////////////////////

  SelectTasksPage := CreateCustomPage(wpSelectProgramGroup, ExpandConstant('{cm:TasksName}'), ExpandConstant('{cm:TasksDescription}'));
  SelectTasksLabel := TLabel.Create(WizardForm);
  with SelectTasksLabel do begin
    AutoSize:=False;
    SetBounds(ScaleX(120), ScaleY(250), ScaleX(600), ScaleY(50));
    WordWrap:= True;
    Transparent:=True;
    Font.Name:= 'Georgia'
    Font.Size:= 10;
    Font.Color:=$FFFFFF;
    Font.Style:=[fsBold, fsItalic];
    Caption:= ExpandConstant('{cm:SelectTasksLabel}');
    Parent := WizardForm;
  end;

  DesktopCheck:=BtnCreate(WizardForm.Handle,ScaleX(75),ScaleY(315),ScaleX(28),ScaleY(28),ExpandConstant('{tmp}\CheckBox.png'),8,True);
//DesktopCheck:=BtnCreate(WizardForm.Handle,ScaleX(75),ScaleY(315),ScaleX(28),ScaleY(28),ExpandConstant('{tmp}\CheckBox.png'),8,True);
  BtnSetEvent(DesktopCheck,BtnClickEventID,WrapBtnCallback(@DesktopClick,1));
  BtnSetEvent(DesktopCheck,BtnMouseEnterEventID,WrapBtnCallback(@WFBtnEnter,1));
  BtnSetCursor(DesktopCheck,GetSysCursorHandle(32649));

  DesktopLabel := TLabel.Create(WizardForm);
  with DesktopLabel do begin
    AutoSize:=False;
    SetBounds(ScaleX(115), ScaleY(320), ScaleX(265), ScaleY(17));
  //SetBounds(ScaleX(115), ScaleY(320), ScaleX(265), ScaleY(17));
    OnClick:= @DesktopLabelClick;
    Cursor:= CrHand;
    Transparent:=True;
    Font.Name:= 'Georgia'
    Font.Size:= 10;
    Font.Color:=$00FFFF;
    Font.Style:=[fsBold,fsItalic];
    Caption := ExpandConstant('{cm:Desktop}');
    Parent := WizardForm;
  end;

  QuickLaunchCheck:=BtnCreate(WizardForm.Handle,ScaleX(75),ScaleY(344),ScaleX(28),ScaleY(28),ExpandConstant('{tmp}\CheckBox.png'),8,True);
  BtnSetEvent(QuickLaunchCheck,BtnClickEventID,WrapBtnCallback(@QuickLaunchClick,1));
  BtnSetEvent(QuickLaunchCheck,BtnMouseEnterEventID,WrapBtnCallback(@WFBtnEnter,1));
  BtnSetCursor(QuickLaunchCheck,GetSysCursorHandle(32649));

  QuickLaunchLabel := TLabel.Create(WizardForm);
  with QuickLaunchLabel do begin
    AutoSize:=False;
    SetBounds(ScaleX(115), ScaleY(350), ScaleX(345), ScaleY(17));
//SetBounds(ScaleX(115), ScaleY(350), ScaleX(345), ScaleY(17));
    OnClick:= @QuickLaunchLabelClick;
    Cursor:= CrHand;
    Transparent:=True;
    Font.Name:= 'Georgia'
    Font.Size:= 10;
    Font.Color:=$FFFFFF;
    Font.Style:=[fsBold,fsItalic];
    Caption := ExpandConstant('{cm:QuickLaunch}');
    Parent := WizardForm;
  end;

  DirectXCheck:=BtnCreate(WizardForm.Handle,ScaleX(75),ScaleY(375),ScaleX(28),ScaleY(28),ExpandConstant('{tmp}\CheckBox.png'),8,True);
//DirectXCheck:=BtnCreate(WizardForm.Handle,ScaleX(75),ScaleY(375),ScaleX(28),ScaleY(28),ExpandConstant('{tmp}\CheckBox.png'),8,True);
  BtnSetEvent(DirectXCheck,BtnClickEventID,WrapBtnCallback(@DirectXClick,1));
  BtnSetEvent(DirectXCheck,BtnMouseEnterEventID,WrapBtnCallback(@WFBtnEnter,1));
  BtnSetCursor(DirectXCheck,GetSysCursorHandle(32649));

  DirectXLabel := TLabel.Create(WizardForm);
  with DirectXLabel do begin
    AutoSize:=False;
    SetBounds(ScaleX(115), ScaleY(380), ScaleX(365), ScaleY(17));
  //SetBounds(ScaleX(115), ScaleY(380), ScaleX(145), ScaleY(17));
    OnClick:= @DirectXLabelClick;
    Cursor:= CrHand;
    Transparent:=True;
    Font.Name:= 'Georgia'
    Font.Size:= 10;
    Font.Color:=$FFFFFF;
    Font.Style:=[fsBold,fsItalic];
    Caption := ExpandConstant('{cm:DirectX}');
    Parent := WizardForm;
  end;

////////////////////// SelectTasksPade //////////////////////

////////////////////// InstallingPage //////////////////////

  StatusLabel := TLabel.Create(WizardForm);
  with StatusLabel do begin
    AutoSize:=False;
    SetBounds(ScaleX(120), ScaleY(245), ScaleX(558), ScaleY(17));
    Transparent:=True;
    Font.Name:= 'Georgia'
    Font.Size:= 10;
    Font.Color:=$FFFFFF;
    Font.Style:=[fsBold,fsItalic];
    Parent := WizardForm;
  end;

  FilenameLabel := TLabel.Create(WizardForm);
  with FilenameLabel do begin
    AutoSize:=False;
    SetBounds(ScaleX(120), ScaleY(270), ScaleX(558), ScaleY(17));
    Transparent:=True;
    Font.Name:= 'Georgia'
    Font.Size:= 9;
    Font.Color:=$FFFFFF;
    Font.Style:=[fsBold,fsItalic];
    Parent := WizardForm;
  end;

  ProgressInfoLabel := TLabel.Create(WizardForm);
  with ProgressInfoLabel do
  begin
    AutoSize:=False;
    SetBounds(ScaleX(80), ScaleY(355), ScaleX(638), ScaleY(17));
    Alignment := taCenter;
    Transparent:=True;
    Font.Name:= 'Georgia'
    Font.Size:= 10;
    Font.Color:=$FFFFFF;
    Font.Style:=[fsBold,fsItalic];
    Parent := WizardForm;
  end;

////////////////////// InstallingPage //////////////////////

////////////////////// FinishedPage //////////////////////

  FinishedHeadingLabel:= TLabel.Create(WizardForm);
  with FinishedHeadingLabel do begin
    AutoSize:=False
    SetBounds(ScaleX(75), ScaleY(185), ScaleX(648), ScaleY(65));
    WordWrap:=True
    Alignment := taCenter;
    Transparent:=True
    Font.Name:='Georgia';
    Font.Size:= 16;
    Font.Color:=$FFFFFF;
    Font.Style:=[fsBold]
    Caption:= ExpandConstant('{cm:FinishedHeading}');
    Parent:=WizardForm
  end;

  FinishedLabel:=TLabel.Create(WizardForm);
  with FinishedLabel do begin
    AutoSize:=False
    SetBounds(ScaleX(75), ScaleY(275), ScaleX(648), ScaleY(200));
    WordWrap:=True
    Transparent:=True
    Font.Name:='Georgia';
    Font.Size:= 11;
    Font.Color:=$FFFFFF;
    Font.Style := [fsBold, fsItalic];
    Caption:= ExpandConstant('{cm:FinishedLabel}')+#13#13+ExpandConstant('{cm:FinishedLabel2}');
    Parent:=WizardForm
  end;
end;

////////////////////// FinishedPage //////////////////////

////////////////////// UninstallingPage //////////////////////

function InitializeUninstall: Boolean;
begin
  FileCopy(ExpandConstant('{app}\botva2.dll'), ExpandConstant('{tmp}\botva2.dll'), False);
  FileCopy(ExpandConstant('{app}\innocallback.dll'), ExpandConstant('{tmp}\innocallback.dll'), False);
  FileCopy(ExpandConstant('{app}\isskin.dll'), ExpandConstant('{tmp}\isskin.dll'), False);
  FileCopy(ExpandConstant('{app}\Tiger.cjstyles'), ExpandConstant('{tmp}\Tiger.cjstyles'), False);
  LoadSkin(ExpandConstant('{tmp}\Tiger.cjstyles'), '');
  Result:=True;
end;

//==================   ==================//

procedure DeleteSavedGames(CurUninstallStep: TUninstallStep);
begin
  if CurUninstallStep=usUninstall then
  if DirExists(ExpandConstant('{#SavesDir}')+'\{#Saves}') then
  if MsgBox(ExpandConstant('{cm:DeleteSave}'), mbInformation, MB_YESNO) = idYes then
  DelTree(ExpandConstant('{#SavesDir}')+'\{#Saves}', True, True, True)
end;

//==================   ==================//

procedure InitializeUninstallProgressForm;
var
  h:HWND;
begin
  with UninstallProgressForm do
  begin
    ClientWidth:=ScaleX(798);
    ClientHeight:=ScaleY(543);
    BorderStyle:=bsSingle
    BorderIcons:=[biSystemMenu]
    OuterNotebook.Hide;
    InnerNotebook.Hide;
    Center;
    Bevel.Hide;
    CancelButton.Left:=ScaleX(660);
 //CancelButton.Left:=ScaleX(660);
    CancelButton.Top:=ScaleY(495);
 //CancelButton.Top:=ScaleY(495);
    CancelButton.Width:=CancelButton.Width+15;

    WizardUninstLabel := TLabel.Create(UninstallProgressForm);
    with WizardUninstLabel do begin
      AutoSize:=False;
      SetBounds(ScaleX(70), ScaleY(185), ScaleX(400), ScaleY(30));
      Transparent:=True;
      Font.Name:= 'Georgia'
      Font.Size:= 13;
      Font.Color:=$FFFFFF;
      Font.Style:=[fsBold];
      Caption:= ExpandConstant('{cm:WizardUninst}');
      Parent := UninstallProgressForm;
    end;

    UninstPageDescriptLabel := TLabel.Create(UninstallProgressForm);
    with UninstPageDescriptLabel do begin
      AutoSize:=False;
      SetBounds(ScaleX(100), ScaleY(215), ScaleX(600), ScaleY(50));
      WordWrap:= True;
      Transparent:=True;
      Font.Name:= 'Georgia'
      Font.Size:= 10;
      Font.Color:=$FFFFFF;
      Font.Style:=[fsBold, fsItalic];
      Caption:= ExpandConstant('{cm:UninstDescript}');
      Parent := UninstallProgressForm;
    end;

    StatusUninstLabel := TLabel.Create(UninstallProgressForm);
    with StatusUninstLabel do begin
      AutoSize:=False;
      SetBounds(ScaleX(120), ScaleY(250), ScaleX(560), ScaleY(17));
      Transparent:=True;
      Font.Name:= 'Georgia'
      Font.Size:= 10;
      Font.Color:=$FFFFFF;
      Font.Style:=[fsBold, fsItalic];
      Caption:= ExpandConstant('{cm:StatusUninst}');
      Parent := UninstallProgressForm;
    end;

    Installing := TLabel.Create(UninstallProgressForm);
    with  Installing do begin
      AutoSize:=False;
      SetBounds(ScaleX(170), ScaleY(96), ScaleX(114), ScaleY(20));
      Transparent:=True;
      Font.Name:= 'Arial';
      Font.Size:= 10;
      Font.Color:=$FFFFFF;
      Font.Style:=[fsBold];
      Caption := ExpandConstant('{cm:Installing}');
      Parent := UninstallProgressForm;
    end;

    Uninstalling := TLabel.Create(UninstallProgressForm);
    with  Uninstalling do begin
      AutoSize:=False;
      SetBounds(ScaleX(570), ScaleY(96), ScaleX(114), ScaleY(20));
      Transparent:=True;
      Font.Name:= 'Arial';
      Font.Size:= 10;
      Font.Color:=$00FFFF;
      Font.Style:=[fsBold];
      Caption := ExpandConstant('{cm:Uninstalling}');
      Parent := UninstallProgressForm;
    end;

    ProgressInfoLabel := TLabel.Create(UninstallProgressForm);
    with ProgressInfoLabel do begin
      AutoSize:=False;
      SetBounds(ScaleX(120), ScaleY(355), ScaleX(560), ScaleY(17));
      Alignment := taCenter;
      Transparent:=True;
      Font.Name:= 'Georgia';
      Font.Size:= 10;
      Font.Color:=$FFFFFF;
      Font.Style:=[fsBold,fsItalic];
      Parent := UninstallProgressForm;
    end;

    h:=UninstallProgressForm.Handle;

    FileCopy(ExpandConstant('{app}\WizardImage.jpg'), ExpandConstant('{tmp}\WizardImage.jpg'), False);
    FileCopy(ExpandConstant('{app}\Workspace.png'), ExpandConstant('{tmp}\Workspace.png'), False);
    FileCopy(ExpandConstant('{app}\StatusPanel.png'), ExpandConstant('{tmp}\StatusPanel.png'), False);
    FileCopy(ExpandConstant('{app}\StatusPanel2.png'), ExpandConstant('{tmp}\StatusPanel2.png'), False);
    FileCopy(ExpandConstant('{app}\button.png'), ExpandConstant('{tmp}\button.png'), False);
    FileCopy(ExpandConstant('{app}\ProgressBackground.png'), ExpandConstant('{tmp}\ProgressBackground.png'), False);
    FileCopy(ExpandConstant('{app}\ProgressImg.png'), ExpandConstant('{tmp}\ProgressImg.png'), False);

    ImgLoad(h,ExpandConstant('{tmp}\WizardImage.jpg'),ScaleX(0),ScaleY(0),UninstallProgressForm.ClientWidth,UninstallProgressForm.ClientHeight,True,True);
    ImgLoad(h,ExpandConstant('{tmp}\Workspace.png'),ScaleX(42), ScaleY(160),ScaleX(714),ScaleY(309),True,True);
    ImgLoad(h,ExpandConstant('{tmp}\StatusPanel.png'),ScaleX(0), ScaleY(95),UninstallProgressForm.ClientWidth,ScaleY(20),True,True);
    ImgLoad(h,ExpandConstant('{tmp}\StatusPanel2.png'),ScaleX(399), ScaleY(95),ScaleX(399), ScaleY(20),True,True);
    ImgLoad(h,ExpandConstant('{tmp}\ProgressBackground.png'),119,300,560,25,True,True);

    UPFButtonFont:=TFont.Create;
    UPFButtonFont.Style:=[fsBold];

    UninstallProgressForm.CancelButton.Visible:=False;
    with UninstallProgressForm.CancelButton do begin
      hCancelUninstBtn:=BtnCreate(h,Left-8,Top-8,Width+16,Height+16,ExpandConstant('{tmp}\button.png'),18,False);
      BtnSetText(hCancelUninstBtn, UninstallProgressForm.CancelButton.Caption);
      BtnSetFont(hCancelUninstBtn,UPFButtonFont.Handle);
      BtnSetFontColor(hCancelUninstBtn,$DAE369,$DAE369,$DAE369,$B6B6B6);
      BtnSetEnabled(hCancelUninstBtn,False);
    end;
  end;
  ImgApplyChanges(h);
end;

////////////////////// UninstallingPage //////////////////////

procedure HideComponents;
begin
  WelcomeLabel1.Hide;
  WelcomeLabel2.Hide;
  RequirementsLbl.Hide;
  ProcessorLbl.Hide;
  ProcessorNameLbl.Hide;
  VideoCardLbl.Hide;
  VideoCardNameLbl.Hide;
  SoundCardLbl.Hide;
  SoundCardNameLbl.Hide;
  RAMLbl.Hide;
  RAMTotalLbl.Hide;
  SystemLbl.Hide;
  SystemNameLbl.Hide;
  SelectDirBrowseLabel.Hide;
  DirEditLabel.Hide;
  TotalSpaceLabel.Hide;
  FreeSpaceLabel.Hide;
  NeedSpaceLabel.Hide;
  NeedSpaceTLabel.Hide;
  NoIconsLabel.Hide;
  SelectStartMenuFolderBrowseLabel.Hide;
  WizardForm.GroupBrowseButton.Hide;
  GroupEditLabel.Hide;
  SelectTasksLabel.Hide;
  DesktopLabel.Hide;
  QuickLaunchLabel.Hide;
  DirectXLabel.Hide;
  StatusLabel.Hide;
  FilenameLabel.Hide;
  FinishedHeadingLabel.Hide;
  FinishedLabel.Hide;
  ProgressInfoLabel.Hide;
  WizardForm.ComponentsList.Hide;
#ifdef ISDone
  LabelTime3.Hide;
  LabelStatusRollback.Hide;
  LabelStatus.Hide;
#endif
#ifdef FreeArc
  LabelStatusRollback.Hide;
  LabelStatus.Hide;
#endif
end;

procedure ShowComponents(CurPageID: Integer);
begin
  PageNameLabel.Caption:=WizardForm.PageNameLabel.Caption
  PageDescriptionLabel.Caption:=WizardForm.PageDescriptionLabel.Caption

  case CurPageID of
    wpWelcome:
    begin
      Welcome.Font.Color := $00FFFF;
      WelcomeLabel1.Show
      WelcomeLabel2.Show
    end;

    Page.ID:
    begin
      Language.Font.Color := $00FFFF;
      //LanguageLabel1.Show;
    end;

    SystemPage.ID:
    begin
      System.Font.Color := $00FFFF;
      ImgSetVisibility(RequirementsPanel,True);
      RequirementsLbl.Show;
      ProcessorLbl.Show;
      ProcessorNameLbl.Show;
      VideoCardLbl.Show;
      VideoCardNameLbl.Show;
      SoundCardLbl.Show;
      SoundCardNameLbl.Show;
      RAMLbl.Show;
      RAMTotalLbl.Show;
      SystemLbl.Show;
      SystemNameLbl.Show;
    end;

    wpSelectDir:
    begin
      Catalogue.Font.Color := $00FFFF;
      ImgSetVisibility(Edit,True);
      ImgSetVisibility(DirFolder,True);
      ImgSetVisibility(HardDrivePanel,True);
      ImgSetVisibility(HDD,True);
      BtnSetVisibility(hDirBrowseBtn,True);
      SelectDirBrowseLabel.Show
      DirEditLabel.Show;
      TotalSpaceLabel.Show;
      FreeSpaceLabel.Show;
      NeedSpaceLabel.Show;
      NeedSpaceTLabel.Show;
    end;

    wpSelectProgramGroup:
    begin
      StartMenu.Font.Color := $00FFFF;
      ImgSetVisibility(GroupFolder,True);
      ImgSetVisibility(Edit,True);
      BtnSetVisibility(hGroupBrowseBtn,True);
      BtnSetVisibility(NoIconsCheck,True);
      SelectStartMenuFolderBrowseLabel.Show;
      WizardForm.GroupBrowseButton.Show;
      GroupEditLabel.Show;
      NoIconsLabel.Show;
    end;

    SelectTasksPage.ID:
    begin
      Tasks.Font.Color := $00FFFF;
      BtnSetVisibility(DesktopCheck,True);
      BtnSetVisibility(QuickLaunchCheck,True);
      BtnSetVisibility(DirectXCheck,True);
      BtnSetChecked(DesktopCheck,True);
      SelectTasksLabel.Show;
      DesktopLabel.Show;
      QuickLaunchLabel.Show;
      DirectXLabel.Show;
      WizardForm.NextButton.Caption:=SetupMessage(msgButtonInstall);
    end;

    wpInstalling:
    begin
      Installing.Font.Color := $00FFFF;
      StatusLabel.Show;
      FilenameLabel.Show;
      ProgressInfoLabel.Show;
    end;

    wpFinished:
    begin
      Finish.Font.Color := $00FFFF;
      BtnSetPosition(hNextBtn, ScaleX(657),ScaleY(487),ScaleX(106),ScaleY(39));
      FinishedHeadingLabel.Show;
      FinishedLabel.Show;
      ImgSetVisibility(PBBkg1Img,False);
      ImgSetVisibility(PBBkg2Img,False);
      ImgSetVisibility(PB1Img,False);
      ImgSetVisibility(PB2Img,False);
#ifdef ISDone
      LabelTime3.Show;
      ImgSetVisibility(PB3Img,False);
#endif
#ifdef FreeArc
      ImgSetVisibility(PB3Img,False);
#endif
    end
  end;
end;
//************************************************ [ -  ] ***************************************************//